/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.bam.bamV1_0;

import htsjdk.beta.codecs.reads.bam.BAMCodec;
import htsjdk.beta.codecs.reads.bam.BAMDecoder;
import htsjdk.beta.codecs.reads.bam.BAMEncoder;
import htsjdk.beta.codecs.reads.bam.bamV1_0.BAMDecoderV1_0;
import htsjdk.beta.codecs.reads.bam.bamV1_0.BAMEncoderV1_0;
import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.exception.HtsjdkUnsupportedOperationException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.SignatureStream;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.reads.ReadsDecoderOptions;
import htsjdk.beta.plugin.reads.ReadsEncoderOptions;
import htsjdk.samtools.SamStreams;
import htsjdk.utils.ValidationUtils;
import java.io.IOException;

public class BAMCodecV1_0
extends BAMCodec {
    public static final HtsVersion VERSION_1 = new HtsVersion(1, 0, 0);

    @Override
    public HtsVersion getVersion() {
        return VERSION_1;
    }

    @Override
    public int getSignatureProbeLength() {
        return 65536;
    }

    @Override
    public int getSignatureLength() {
        return 65498;
    }

    @Override
    public boolean canDecodeSignature(SignatureStream probingInputStream, String sourceName) {
        ValidationUtils.nonNull(probingInputStream);
        ValidationUtils.nonNull(sourceName);
        try {
            return SamStreams.isBAMFile(probingInputStream);
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Failure reading signature from stream for %s", sourceName), e);
        }
    }

    public BAMDecoder getDecoder(Bundle inputBundle, ReadsDecoderOptions decoderOptions) {
        return new BAMDecoderV1_0(inputBundle, decoderOptions);
    }

    public BAMEncoder getEncoder(Bundle outputBundle, ReadsEncoderOptions encoderOptions) {
        return new BAMEncoderV1_0(outputBundle, encoderOptions);
    }

    @Override
    public boolean runVersionUpgrade(HtsVersion sourceCodecVersion, HtsVersion targetCodecVersion) {
        throw new HtsjdkUnsupportedOperationException("Upgrade not yet implemented");
    }
}

