/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.hapref.fasta;

import htsjdk.beta.codecs.hapref.fasta.FASTACodecV1_0;
import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.io.bundle.BundleResourceType;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.hapref.HaploidReferenceDecoder;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloseableIterator;
import java.io.IOException;

public class FASTADecoderV1_0
implements HaploidReferenceDecoder {
    private final String displayName;
    protected Bundle inputBundle;
    private final ReferenceSequenceFile referenceSequenceFile;

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public FASTADecoderV1_0(Bundle inputBundle) {
        this.inputBundle = inputBundle;
        this.displayName = inputBundle.getPrimaryResource().getDisplayName();
        BundleResource referenceResource = inputBundle.getOrThrow(BundleResourceType.HAPLOID_REFERENCE);
        if (referenceResource.getIOPath().isPresent()) {
            this.referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile(referenceResource.getIOPath().get().toPath(), true);
        } else {
            SeekableStream seekableStream = referenceResource.getSeekableStream().orElseThrow(() -> new IllegalArgumentException(String.format("The reference resource %s is not able to supply the required seekable stream", referenceResource.getDisplayName())));
            this.referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile(referenceResource.getDisplayName(), seekableStream, null);
        }
    }

    @Override
    public final String getFileFormat() {
        return "FASTA";
    }

    @Override
    public SAMSequenceDictionary getHeader() {
        return this.referenceSequenceFile.getSequenceDictionary();
    }

    @Override
    public HtsVersion getVersion() {
        return FASTACodecV1_0.VERSION_1;
    }

    @Override
    public CloseableIterator<ReferenceSequence> iterator() {
        this.referenceSequenceFile.reset();
        return new CloseableIterator<ReferenceSequence>(){
            ReferenceSequence nextSeq;
            {
                this.nextSeq = FASTADecoderV1_0.this.referenceSequenceFile.nextSequence();
            }

            @Override
            public boolean hasNext() {
                return this.nextSeq != null;
            }

            @Override
            public ReferenceSequence next() {
                ReferenceSequence tmpSeq = this.nextSeq;
                this.nextSeq = FASTADecoderV1_0.this.referenceSequenceFile.nextSequence();
                return tmpSeq;
            }

            @Override
            public void close() {
                try {
                    FASTADecoderV1_0.this.referenceSequenceFile.close();
                }
                catch (IOException e) {
                    throw new HtsjdkIOException(e);
                }
            }
        };
    }

    @Override
    public boolean isQueryable() {
        return this.hasIndex();
    }

    @Override
    public boolean hasIndex() {
        return FASTADecoderV1_0.bundleContainsIndex(this.inputBundle) && this.referenceSequenceFile.isIndexed();
    }

    public ReferenceSequenceFile getReferenceSequenceFile() {
        return this.referenceSequenceFile;
    }

    @Override
    public void close() {
        if (this.referenceSequenceFile != null) {
            try {
                this.referenceSequenceFile.close();
            }
            catch (IOException e) {
                throw new HtsjdkIOException(e);
            }
        }
    }

    private static boolean bundleContainsIndex(Bundle inputBundle) {
        return inputBundle.get("READS_INDEX").isPresent();
    }
}

