/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.modify;

import edu.mayo.genomicutils.vcf.VCFUtils;
import edu.mayo.genomicutils.vcf.modify.ModifyRowPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class VCFModifierEngine {
    private static final String TAB = "\t";
    private List<ModifyRowPlugin> modifyRowPlugins = new ArrayList<ModifyRowPlugin>();

    public void addModifyRowPlugin(ModifyRowPlugin plugin) {
        this.modifyRowPlugins.add(plugin);
    }

    public void execute(File inputVCF, Writer wtr) throws IOException {
        if (this.modifyRowPlugins.size() == 0) {
            throw new RuntimeException("At least one plugin must be added.");
        }
        PrintWriter pWtr = new PrintWriter(wtr);
        boolean processedMetadataHeader = false;
        boolean processedColumnHeader = false;
        try (BufferedReader br = VCFUtils.open(inputVCF);){
            String line;
            while ((line = br.readLine()) != null) {
                if (!processedMetadataHeader && line.startsWith("##")) {
                    for (ModifyRowPlugin plugin : this.modifyRowPlugins) {
                        line = plugin.modifyMetadataRow(line);
                    }
                    pWtr.println(line);
                    continue;
                }
                if (!processedColumnHeader && (line.startsWith("#C") || line.startsWith("#c"))) {
                    ArrayList<String> newMetadataRows = new ArrayList<String>();
                    String[] colNames = line.split(TAB, -1);
                    for (ModifyRowPlugin plugin : this.modifyRowPlugins) {
                        colNames = plugin.modifyColumnHeaderRow(colNames);
                        newMetadataRows.addAll(plugin.getNewMetadataRows());
                    }
                    for (String newMetadataRow : newMetadataRows) {
                        pWtr.println(newMetadataRow);
                    }
                    this.writeLine(colNames, pWtr);
                    processedMetadataHeader = true;
                    processedColumnHeader = true;
                    continue;
                }
                String[] cols = line.split(TAB, -1);
                for (ModifyRowPlugin plugin : this.modifyRowPlugins) {
                    cols = plugin.modifyDataRow(cols);
                }
                this.writeLine(cols, pWtr);
                processedMetadataHeader = true;
                processedColumnHeader = true;
            }
        }
    }

    private void writeLine(String[] cols, PrintWriter pWtr) {
        for (int i = 0; i < cols.length; ++i) {
            pWtr.print(cols[i]);
            if (i == cols.length - 1) {
                pWtr.println();
                continue;
            }
            pWtr.print(TAB);
        }
    }
}

