/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.header;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SampleDefinition {
    private String name;
    private Map<String, List<Integer>> integerVals = new HashMap<String, List<Integer>>();
    private Map<String, List<Float>> floatVals = new HashMap<String, List<Float>>();
    private Map<String, List<String>> stringVals = new HashMap<String, List<String>>();
    private Map<String, List<Character>> characterVals = new HashMap<String, List<Character>>();
    private Map<String, Boolean> booleanVals = new HashMap<String, Boolean>();

    public SampleDefinition(String name) {
        this.name = name;
    }

    public void addInteger(String key, Integer value) {
        List<Integer> l = this.integerVals.get(key);
        if (l == null) {
            l = new ArrayList<Integer>();
        }
        l.add(value);
        this.integerVals.put(key, l);
    }

    public void addFloat(String key, Float value) {
        List<Float> l = this.floatVals.get(key);
        if (l == null) {
            l = new ArrayList<Float>();
        }
        l.add(value);
        this.floatVals.put(key, l);
    }

    public void addString(String key, String value) {
        List<String> l = this.stringVals.get(key);
        if (l == null) {
            l = new ArrayList<String>();
        }
        l.add(value);
        this.stringVals.put(key, l);
    }

    public void addCharacter(String key, Character value) {
        List<Character> l = this.characterVals.get(key);
        if (l == null) {
            l = new ArrayList<Character>();
        }
        l.add(value);
        this.characterVals.put(key, l);
    }

    public void setBoolean(String key, Boolean value) {
        this.booleanVals.put(key, value);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getIntegerKeys() {
        return this.integerVals.keySet();
    }

    public List<String> getSortedIntegerKeys() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : this.getIntegerKeys()) {
            ret.add(key);
        }
        Collections.sort(ret);
        return ret;
    }

    public List<Integer> getIntegerValues(String key) {
        return this.integerVals.get(key);
    }

    public Set<String> getFloatKeys() {
        return this.floatVals.keySet();
    }

    public List<String> getSortedFloatKeys() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : this.getFloatKeys()) {
            ret.add(key);
        }
        Collections.sort(ret);
        return ret;
    }

    public List<Float> getFloatValues(String key) {
        return this.floatVals.get(key);
    }

    public Set<String> getStringKeys() {
        return this.stringVals.keySet();
    }

    public List<String> getSortedStringKeys() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : this.getStringKeys()) {
            ret.add(key);
        }
        Collections.sort(ret);
        return ret;
    }

    public List<String> getStringValues(String key) {
        return this.stringVals.get(key);
    }

    public Set<String> getCharacterKeys() {
        return this.characterVals.keySet();
    }

    public List<String> getSortedCharacterKeys() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : this.getCharacterKeys()) {
            ret.add(key);
        }
        Collections.sort(ret);
        return ret;
    }

    public List<Character> getCharacterValues(String key) {
        return this.characterVals.get(key);
    }

    public Set<String> getBooleanKeys() {
        return this.booleanVals.keySet();
    }

    public List<String> getSortedBooleanKeys() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : this.getBooleanKeys()) {
            ret.add(key);
        }
        Collections.sort(ret);
        return ret;
    }

    public Boolean getBooleanValue(String key) {
        return this.booleanVals.get(key);
    }

    public String toStringAsVCF() throws UnsupportedEncodingException {
        int count;
        List<Object> values;
        StringBuilder sb = new StringBuilder();
        sb.append("##SAMPLE=<ID=");
        sb.append(this.name);
        sb.append(";");
        for (String key : this.getSortedFloatKeys()) {
            sb.append(key);
            sb.append("=");
            values = this.getFloatValues(key);
            count = 0;
            for (Object value : values) {
                sb.append(value);
                if (++count >= values.size()) continue;
                sb.append(",");
            }
            sb.append(";");
        }
        for (String key : this.getSortedIntegerKeys()) {
            sb.append(key);
            sb.append("=");
            values = this.getIntegerValues(key);
            count = 0;
            for (Object value : values) {
                sb.append(value);
                if (++count >= values.size()) continue;
                sb.append(",");
            }
            sb.append(";");
        }
        for (String key : this.getSortedBooleanKeys()) {
            if (!this.getBooleanValue(key).booleanValue()) continue;
            sb.append(key);
            sb.append(";");
        }
        for (String key : this.getSortedStringKeys()) {
            sb.append(key);
            sb.append("=");
            values = this.getStringValues(key);
            count = 0;
            for (Object value : values) {
                sb.append(this.fixString2URL((String)value));
                if (++count >= values.size()) continue;
                sb.append(",");
            }
            sb.append(";");
        }
        for (String key : this.getSortedCharacterKeys()) {
            sb.append(key);
            sb.append("=");
            values = this.getCharacterValues(key);
            count = 0;
            for (Object value : values) {
                sb.append(value);
                if (++count >= values.size()) continue;
                sb.append(",");
            }
            sb.append(";");
        }
        return sb.substring(0, sb.length() - 1) + ">";
    }

    private String escapeDoubleQuotedStrings(String dblQuotedStr) {
        return dblQuotedStr.replace("\"", "\\\"").replace("\\", "\\\\");
    }

    public String fixString2URL(String in) throws UnsupportedEncodingException {
        String rightbrace = URLEncoder.encode("[", "UTF-8");
        String leftbrace = URLEncoder.encode("]", "UTF-8");
        String semicolon = URLEncoder.encode(";", "UTF-8");
        String comma = URLEncoder.encode(",", "UTF-8");
        String equals = URLEncoder.encode("=", "UTF-8");
        String out = in.replaceAll("\\[", rightbrace);
        out = out.replaceAll("\\]", leftbrace);
        out = out.replaceAll(",", comma);
        out = out.replaceAll(";", semicolon);
        out = out.replaceAll("=", equals);
        return out;
    }
}

