/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.extract;

import edu.mayo.genomicutils.vcf.extract.FlatFileHeader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FlatFileUtil {
    public static boolean isHeaderLine(String line) {
        return line.startsWith("#");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> grabHeaderLines(File f) throws IOException {
        ArrayList<String> headerLines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(f));){
            String line;
            while ((line = br.readLine()) != null && FlatFileUtil.isHeaderLine(line)) {
                headerLines.add(line);
            }
        }
        return headerLines;
    }

    public static FlatFileHeader toFlatFileHeader(List<String> headerLines) {
        FlatFileHeader header = new FlatFileHeader();
        if (headerLines.size() > 0) {
            header.columnHeader = headerLines.get(headerLines.size() - 1);
            if (headerLines.size() > 1) {
                header.miscHeaderLines.addAll(headerLines.subList(0, headerLines.size() - 1));
            }
        }
        return header;
    }
}

