/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.compoundhet;

import edu.mayo.genomicutils.vcf.VCFUtils;
import edu.mayo.genomicutils.vcf.compoundhet.Gene;
import edu.mayo.genomicutils.vcf.compoundhet.GeneDataSource;
import edu.mayo.genomicutils.vcf.compoundhet.HgncDataSource;
import edu.mayo.genomicutils.vcf.compoundhet.HgncEntry;
import edu.mayo.genomicutils.vcf.compoundhet.HgncEntryNotFoundException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneHitAnnotator {
    private static Logger LOGGER = LoggerFactory.getLogger(GeneHitAnnotator.class);
    private static final String INFO_FIELD_ID_ENSG_ID = "ENSEMBL_GENE_ID";
    private static final String INFO_FIELD_ID_HGNC_SYMBOL = "HGNC_APPROVED_SYMBOL";
    private static final String INFO_FIELD_ID_COUNT = "VARIANTS_IN_GENE";
    private static final String TAB = "\t";
    private GeneDataSource geneDataSource;
    private HgncDataSource hgncDataSource;
    private Map<String, Integer> ensemblGeneHitCounts = new HashMap<String, Integer>();

    public GeneHitAnnotator(GeneDataSource geneDataSource, HgncDataSource hgncDataSource) {
        this.geneDataSource = geneDataSource;
        this.hgncDataSource = hgncDataSource;
    }

    public void annotateVCF(File vcf, BufferedWriter outputWriter) throws IOException {
        this.updateVariantCounts(vcf);
        this.addAnnotation(vcf, outputWriter);
    }

    private void updateVariantCounts(File vcf) throws IOException {
        String line;
        BufferedReader inputReader = VCFUtils.open(vcf);
        while ((line = inputReader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] vcfRow = line.split(TAB, -1);
            for (Gene gene : this.findGenes(vcfRow)) {
                Integer count = this.ensemblGeneHitCounts.get(gene.id);
                count = count == null ? 1 : count + 1;
                this.ensemblGeneHitCounts.put(gene.id, count);
            }
        }
    }

    private void addAnnotation(File vcf, BufferedWriter outputWriter) throws IOException {
        String line;
        BufferedReader inputReader = VCFUtils.open(vcf);
        while ((line = inputReader.readLine()) != null) {
            if (line.startsWith("#")) {
                if (!line.startsWith("##")) {
                    outputWriter.write(String.format("##INFO=<ID=%s,Number=1,Type=String,Description=\"HGNC approved symbol of gene that overlaps with this variant\">", INFO_FIELD_ID_HGNC_SYMBOL));
                    outputWriter.newLine();
                    outputWriter.write(String.format("##INFO=<ID=%s,Number=1,Type=String,Description=\"Ensembl gene ID of gene that overlaps with this variant\">", INFO_FIELD_ID_ENSG_ID));
                    outputWriter.newLine();
                    outputWriter.write(String.format("##INFO=<ID=%s,Number=1,Type=Integer,Description=\"Total number of variants in the gene specified by %s\">", INFO_FIELD_ID_COUNT, INFO_FIELD_ID_HGNC_SYMBOL));
                    outputWriter.newLine();
                }
                outputWriter.write(line);
                outputWriter.newLine();
                continue;
            }
            String[] vcfRow = line.split(TAB, -1);
            String originalINFO = vcfRow[7];
            List<Gene> genes = this.findGenes(vcfRow);
            for (Gene gene : genes) {
                try {
                    List<HgncEntry> hgncEntries = this.hgncDataSource.findByEnsemblGeneID(gene.id);
                    for (HgncEntry hgncEntry : hgncEntries) {
                        String newINFO = originalINFO;
                        if (newINFO.length() > 0) {
                            newINFO = newINFO + ";";
                        }
                        newINFO = newINFO + "HGNC_APPROVED_SYMBOL=" + hgncEntry.approvedSymbol + ";";
                        newINFO = newINFO + "ENSEMBL_GENE_ID=" + gene.id + ";";
                        vcfRow[7] = newINFO = newINFO + "VARIANTS_IN_GENE=" + this.ensemblGeneHitCounts.get(gene.id);
                        this.writeTSVRow(outputWriter, vcfRow);
                    }
                }
                catch (HgncEntryNotFoundException e) {
                    LOGGER.warn(String.format("%s Ensembl gene id not found in HGNC", gene.id));
                }
            }
            if (genes.size() != 0) continue;
            this.writeTSVRow(outputWriter, vcfRow);
        }
    }

    private List<Gene> findGenes(String[] vcfRow) {
        String chrom = vcfRow[0];
        int minBP = Integer.parseInt(vcfRow[1]);
        int maxBP = minBP + (vcfRow[3].length() - 1);
        return this.geneDataSource.findGenes(chrom, minBP, maxBP);
    }

    private void writeTSVRow(BufferedWriter outputWriter, String[] rowData) throws IOException {
        for (int i = 0; i < rowData.length; ++i) {
            outputWriter.write(rowData[i]);
            if (i >= rowData.length - 1) continue;
            outputWriter.write(TAB);
        }
        outputWriter.newLine();
    }
}

