/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.LineIteratorImpl;
import htsjdk.tribble.readers.LineReader;
import htsjdk.tribble.util.ParsingUtils;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class VCFUtils {
    public static BufferedReader open(File vcf) throws IOException {
        if (vcf.getName().endsWith(".gz")) {
            GZIPInputStream gzipStream = new GZIPInputStream(new FileInputStream(vcf));
            return new BufferedReader(new InputStreamReader(gzipStream));
        }
        if (vcf.getName().endsWith(".bgz")) {
            return new BufferedReader(new InputStreamReader((InputStream)new BlockCompressedInputStream(vcf)));
        }
        return new BufferedReader(new FileReader(vcf));
    }

    public static boolean isSingleValued(VCFInfoHeaderLine infoLine) {
        return infoLine.getCountType().equals((Object)VCFHeaderLineCount.INTEGER) && infoLine.getCount() == 1;
    }

    public static VCFHeader parseHeader(List<String> headerLines) {
        final Iterator<String> headerLineItr = headerLines.iterator();
        LineReader lineReader = new LineReader(){

            public String readLine() throws IOException {
                return headerLineItr.hasNext() ? (String)headerLineItr.next() : null;
            }

            public void close() {
            }
        };
        VCFCodec vcfCodec = new VCFCodec();
        LineIteratorImpl lineIterator = new LineIteratorImpl(lineReader);
        return (VCFHeader)vcfCodec.readActualHeader((LineIterator)lineIterator);
    }

    public static Map<String, Object> parseInfo(VCFHeader header, String infoCol) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        List infoFields = ParsingUtils.split((String)infoCol, (char)';');
        for (String infoField : infoFields) {
            List value;
            String key;
            int equalsIndex = infoField.indexOf("=");
            if (equalsIndex != -1) {
                key = infoField.substring(0, equalsIndex);
                String valueString = infoField.substring(equalsIndex + 1);
                VCFInfoHeaderLine headerLine = header.getInfoHeaderLine(key);
                if (headerLine == null) continue;
                boolean isArray = !VCFUtils.isSingleValued(headerLine);
                List infoValueSplit = ParsingUtils.split((String)valueString, (char)',');
                value = isArray ? infoValueSplit : infoValueSplit.get(0);
            } else {
                key = infoField;
                VCFInfoHeaderLine headerLine = header.getInfoHeaderLine(key);
                value = headerLine == null || headerLine.getType() == VCFHeaderLineType.Flag;
            }
            if ("".equals(value)) {
                value = ".";
            }
            attributes.put(key, value);
        }
        return attributes;
    }

    public static String decodeInfoFieldValues(String infoFieldValues) {
        String[] specialValues;
        for (String s : specialValues = new String[]{"%3A", "%3B", "%3D", "%25", "%2C", "%0D", "%0A", "%09"}) {
            if (s.equals("%3A")) {
                infoFieldValues = infoFieldValues.replaceAll(s, ":");
                continue;
            }
            if (s.equals("%3B")) {
                infoFieldValues = infoFieldValues.replaceAll(s, ";");
                continue;
            }
            if (s.equals("%3D")) {
                infoFieldValues = infoFieldValues.replaceAll(s, "=");
                continue;
            }
            if (s.equals("%25")) {
                infoFieldValues = infoFieldValues.replaceAll(s, "%");
                continue;
            }
            if (s.equals("%2C")) {
                infoFieldValues = infoFieldValues.replaceAll(s, ",");
                continue;
            }
            if (s.equals("%0D")) {
                infoFieldValues = infoFieldValues.replaceAll(s, "\r");
                continue;
            }
            if (s.equals("%0A")) {
                infoFieldValues = infoFieldValues.replaceAll(s, "\n");
                continue;
            }
            if (!s.equals("%09")) continue;
            infoFieldValues = infoFieldValues.replaceAll(s, "\t");
        }
        return infoFieldValues;
    }
}

