/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.refassembly;

import edu.mayo.genomicutils.refassembly.AssemblyNotSupportedException;
import edu.mayo.genomicutils.refassembly.RefAssemblyFinder;
import htsjdk.tribble.readers.TabixReader;
import java.io.File;
import java.io.IOException;

public class RefBasePairLookup {
    private String mReferenceAssemblyCatalogPath;
    private TabixReader mTabixReader;

    public RefBasePairLookup(String refAssemblyPath) throws AssemblyNotSupportedException, IOException {
        this.mReferenceAssemblyCatalogPath = refAssemblyPath;
        if (!new File(this.mReferenceAssemblyCatalogPath).exists()) {
            throw new AssemblyNotSupportedException(this.mReferenceAssemblyCatalogPath);
        }
        this.mTabixReader = new TabixReader(this.mReferenceAssemblyCatalogPath);
    }

    public RefBasePairLookup(String refAssemblyBaseDir, String refAssemblyName) throws AssemblyNotSupportedException, IOException {
        this(new RefAssemblyFinder().getFullPathToRefAssemblyCatalog(refAssemblyBaseDir, refAssemblyName));
    }

    public String getBasePairAtPosition(String landmark, String minBP, String maxBP) throws IOException {
        String tabixQuery = landmark + ":" + minBP + "-" + maxBP;
        TabixReader.Iterator records = this.mTabixReader.query(tabixQuery);
        return this.getBasePair(records, Integer.parseInt(minBP), Integer.parseInt(maxBP));
    }

    private String getBasePair(TabixReader.Iterator records, int minBP, int maxBP) throws IOException {
        StringBuilder subsequence = new StringBuilder();
        if (records == null) {
            return ".";
        }
        String rec = null;
        boolean isFirst = true;
        int seqEndPos = 0;
        boolean isAtLeastOneRecord = false;
        while ((rec = records.next()) != null) {
            isAtLeastOneRecord = true;
            String[] split = rec.split("\t");
            String seq = split[3];
            if (isFirst) {
                int numToTrimOffFront = minBP - Integer.parseInt(split[1]);
                seq = seq.substring(numToTrimOffFront);
                isFirst = false;
            }
            subsequence.append(seq);
            seqEndPos = Integer.parseInt(split[2]);
        }
        if (!isAtLeastOneRecord) {
            return ".";
        }
        int numToTrimOffEnd = seqEndPos - maxBP;
        return subsequence.substring(0, subsequence.length() - numToTrimOffEnd);
    }
}

