/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.mq.sender;

import edu.mayo.mq.sender.Sender;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemOutSender
implements Sender {
    protected Logger log = LoggerFactory.getLogger(SystemOutSender.class);
    private PrintStream stdout = System.out;
    private PrintStream stderr = System.err;
    private String location = "stdout";

    public SystemOutSender(String location) {
        this.setLocation(location);
    }

    void setStdout(PrintStream stream) {
        this.stdout = stream;
    }

    void setStderr(PrintStream stream) {
        this.stderr = stream;
    }

    @Override
    public void setLocation(String location) {
        this.location = location.equalsIgnoreCase("error") || location.equalsIgnoreCase("err") || location.equalsIgnoreCase("stderr") ? "stderr" : (location.equalsIgnoreCase("out") || location.equalsIgnoreCase("stdout") ? "stdout" : "log4j");
    }

    @Override
    public void write(String message) {
        if (this.location.equalsIgnoreCase("stdout")) {
            this.stdout.println(message);
        } else if (this.location.equalsIgnoreCase("stderr")) {
            this.stderr.println(message);
        } else {
            this.log.info(message);
        }
    }

    @Override
    public void close() {
    }
}

