/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.mq.sender;

import edu.mayo.mq.sender.Sender;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class FileSender
implements Sender {
    private String location;
    private BufferedWriter writer = null;

    public FileSender(String location) {
        this.setLocation(location);
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
        try {
            File file = new File(location);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            this.writer = new BufferedWriter(new FileWriter(location));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(String message) {
        if (this.writer != null) {
            try {
                this.writer.write(message);
                this.writer.write("\n");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close() {
        if (this.writer != null) {
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

