/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.IntrospectedCodeClass;

public class CodeUtils {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final CodeClass TYPE_VOID = IntrospectedCodeClass.forClass(Void.TYPE);
    public static final CodeClass TYPE_INT;
    public static final CodeClass TYPE_FLOAT;
    public static final CodeClass TYPE_DOUBLE;
    public static final CodeClass TYPE_LONG;
    public static final CodeClass TYPE_BYTE;
    public static final CodeClass TYPE_SHORT;
    public static final CodeClass TYPE_CHAR;
    public static final CodeClass TYPE_BOOLEAN;
    public static final CodeClass TYPE_OBJECT;
    public static final CodeClass[] EMPTY_LIST;
    public static final CodeGenerator DO_NOTHING;

    public static String classListToString(CodeClass[] classes) {
        StringBuffer sb = new StringBuffer();
        if (classes.length > 0) {
            sb.append(classes[0].getName());
        }
        for (int a = 1; a < classes.length; ++a) {
            sb.append(", ");
            sb.append(classes[a].getName());
        }
        return sb.toString();
    }

    public static int wordsForType(CodeClass cc) {
        if (cc == TYPE_DOUBLE || cc == TYPE_LONG) {
            return 2;
        }
        if (cc == TYPE_VOID) {
            return 0;
        }
        return 1;
    }

    public static boolean isFloatType(CodeClass cc) {
        return cc == TYPE_DOUBLE || cc == TYPE_FLOAT;
    }

    public static boolean isIntegerType(CodeClass cc) {
        return cc == TYPE_LONG || cc == TYPE_BOOLEAN || cc == TYPE_BYTE || cc == TYPE_CHAR || cc == TYPE_LONG || cc == TYPE_SHORT;
    }

    static {
        TYPE_BYTE = IntrospectedCodeClass.forClass(Byte.TYPE);
        TYPE_INT = IntrospectedCodeClass.forClass(Integer.TYPE);
        TYPE_FLOAT = IntrospectedCodeClass.forClass(Float.TYPE);
        TYPE_DOUBLE = IntrospectedCodeClass.forClass(Double.TYPE);
        TYPE_LONG = IntrospectedCodeClass.forClass(Long.TYPE);
        TYPE_SHORT = IntrospectedCodeClass.forClass(Short.TYPE);
        TYPE_CHAR = IntrospectedCodeClass.forClass(Character.TYPE);
        TYPE_BOOLEAN = IntrospectedCodeClass.forClass(Boolean.TYPE);
        TYPE_OBJECT = IntrospectedCodeClass.forClass(Object.class);
        EMPTY_LIST = new CodeClass[0];
        DO_NOTHING = new CodeGenerator(){

            @Override
            public void writeCode(CodeContext cxt) {
            }

            @Override
            public int stackDepth() {
                return 0;
            }

            @Override
            public int stackDelta() {
                return 0;
            }
        };
    }
}

