/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.modify;

import edu.mayo.pipes.JSON.modify.JsonTypeExtended;
import edu.mayo.pipes.JSON.modify.ModifyJsonColumnHeader;
import edu.mayo.pipes.JSON.modify.ModifyJsonConfigException;
import edu.mayo.pipes.JSON.modify.ModifyJsonConfigLine;
import edu.mayo.pipes.JSON.modify.ModifyJsonOperation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class ModifyJsonConfig {
    public List<ModifyJsonConfigLine> parseConfigFile(File configFile) throws IOException, ModifyJsonConfigException {
        List lines = FileUtils.readLines((File)configFile);
        Map<ModifyJsonColumnHeader, Integer> headerNameToIdxMap = this.toColIdxMap((String)lines.get(0));
        ArrayList<ModifyJsonConfigLine> configLines = new ArrayList<ModifyJsonConfigLine>();
        for (int i = 1; i < lines.size(); ++i) {
            ModifyJsonConfigLine configLine = this.parseLine(((String)lines.get(i)).trim(), headerNameToIdxMap);
            if (configLine == null) continue;
            configLines.add(configLine);
        }
        return configLines;
    }

    private Map<ModifyJsonColumnHeader, Integer> toColIdxMap(String headerLine) throws ModifyJsonConfigException {
        this.verifyHeaderLineStartsWithHash(headerLine);
        String headerLineWithoutHash = this.stripCommentPrefix(headerLine);
        HashMap<ModifyJsonColumnHeader, Integer> colNameToIdxMap = new HashMap<ModifyJsonColumnHeader, Integer>();
        String[] cols = headerLineWithoutHash.split("\t");
        this.verifyColumnHeaderNames(cols);
        for (int i = 0; i < cols.length; ++i) {
            ModifyJsonColumnHeader colHeader = this.getHeader(cols[i]);
            colNameToIdxMap.put(colHeader, i);
            if (ModifyJsonColumnHeader.FIND.equals((Object)colHeader)) break;
        }
        return colNameToIdxMap;
    }

    private void verifyHeaderLineStartsWithHash(String headerLine) throws ModifyJsonConfigException {
        if (!headerLine.startsWith("#")) {
            throw new ModifyJsonConfigException("Modify TJSON config file header should begin with '#'");
        }
    }

    private void verifyColumnHeaderNames(String[] columnHeaderNames) throws ModifyJsonConfigException {
        List<String> allowedColumnHeaders = this.getHeadersEnumAsStringList();
        for (int i = 0; i < columnHeaderNames.length; ++i) {
            try {
                int expectedIdx = i < allowedColumnHeaders.size() ? i : allowedColumnHeaders.size() - 2 + i % 2;
                String expected = allowedColumnHeaders.get(expectedIdx);
                String actual = columnHeaderNames[i];
                if (actual.equalsIgnoreCase(expected)) continue;
                throw new ModifyJsonConfigException("Modify TJSON config - column header not recognized, or not in correct order. (column " + (i + 1) + ").  Expected: " + expected + ".  Actual: " + actual);
            }
            catch (IllegalArgumentException e) {
                throw new ModifyJsonConfigException("Modify TJSON config column header (column " + (i + 1) + ") is not recognized: " + columnHeaderNames[i] + ".  Allowed values: " + allowedColumnHeaders);
            }
        }
    }

    private List<String> getHeadersEnumAsStringList() {
        ArrayList<String> headerStrs = new ArrayList<String>();
        for (ModifyJsonColumnHeader colHeader : ModifyJsonColumnHeader.values()) {
            headerStrs.add(StringUtils.capitalize((String)colHeader.name().toLowerCase()));
        }
        return headerStrs;
    }

    private List<String> getOperationsEnumAsStringList() {
        ArrayList<String> vals = new ArrayList<String>();
        for (ModifyJsonOperation op : ModifyJsonOperation.values()) {
            vals.add(StringUtils.capitalize((String)op.name().toLowerCase()));
        }
        return vals;
    }

    private List<String> getJsonTypesEnumAsStringList() {
        ArrayList<String> vals = new ArrayList<String>();
        for (JsonTypeExtended jsonType : JsonTypeExtended.values()) {
            vals.add(StringUtils.capitalize((String)jsonType.name().toLowerCase()));
        }
        return vals;
    }

    private String stripCommentPrefix(String s) {
        while (s.startsWith("#")) {
            s = s.substring(1);
        }
        return s;
    }

    private ModifyJsonConfigLine parseLine(String configLine, Map<ModifyJsonColumnHeader, Integer> colHeaderNameToIdxMap) throws ModifyJsonConfigException {
        String[] cols = configLine.split("\t");
        if (cols.length == 0) {
            return null;
        }
        ModifyJsonConfigLine config = new ModifyJsonConfigLine();
        config.key = this.getColData(ModifyJsonColumnHeader.KEY, cols, colHeaderNameToIdxMap);
        config.operation = this.getOperation(this.getColData(ModifyJsonColumnHeader.OPERATION, cols, colHeaderNameToIdxMap));
        config.newType = this.getNewJsonTypeExtended(this.getColData(ModifyJsonColumnHeader.NEW_TYPE, cols, colHeaderNameToIdxMap));
        config.count = this.getColData(ModifyJsonColumnHeader.NEW_COUNT, cols, colHeaderNameToIdxMap);
        config.delim = this.getColData(ModifyJsonColumnHeader.DELIM, cols, colHeaderNameToIdxMap);
        config.comment = this.getColData(ModifyJsonColumnHeader.COMMENT, cols, colHeaderNameToIdxMap);
        if (null != colHeaderNameToIdxMap.get((Object)ModifyJsonColumnHeader.FIND)) {
            config.findAndReplace = this.getReplacements(cols, colHeaderNameToIdxMap.get((Object)ModifyJsonColumnHeader.FIND));
        }
        if (config.count != null) {
            this.verifyNewCount(config.count);
        }
        return config;
    }

    private Properties getReplacements(String[] cols, int firstFindColumn) {
        Properties findAndReplace = new Properties();
        for (int i = firstFindColumn; i < cols.length; i += 2) {
            String find = cols[i];
            String replaceWith = i + 1 < cols.length ? cols[i + 1] : "";
            findAndReplace.setProperty(find, replaceWith);
        }
        return findAndReplace;
    }

    private ModifyJsonColumnHeader getHeader(String headerStr) throws ModifyJsonConfigException {
        if (headerStr == null || headerStr.trim().length() == 0) {
            return null;
        }
        for (ModifyJsonColumnHeader header : ModifyJsonColumnHeader.values()) {
            if (!header.name().equalsIgnoreCase(headerStr)) continue;
            return header;
        }
        throw new ModifyJsonConfigException("Modify TJSON config file: Column header not recognized: '" + headerStr + "'.  Allowed values: " + this.getHeadersEnumAsStringList());
    }

    private ModifyJsonOperation getOperation(String operationStr) throws ModifyJsonConfigException {
        if (operationStr == null || operationStr.trim().length() == 0) {
            return null;
        }
        for (ModifyJsonOperation op : ModifyJsonOperation.values()) {
            if (!op.name().equalsIgnoreCase(operationStr)) continue;
            return op;
        }
        throw new ModifyJsonConfigException("Modify TJSON config file: Operation not recognized: '" + operationStr + "'.  Allowed values: " + this.getOperationsEnumAsStringList());
    }

    private JsonTypeExtended getNewJsonTypeExtended(String newJsonTypeExtendedStr) throws ModifyJsonConfigException {
        if (newJsonTypeExtendedStr == null || newJsonTypeExtendedStr.trim().length() == 0) {
            return null;
        }
        for (JsonTypeExtended type : JsonTypeExtended.values()) {
            if (!type.name().equalsIgnoreCase(newJsonTypeExtendedStr)) continue;
            return type;
        }
        throw new ModifyJsonConfigException("Modify TJSON config file: New JSON type not recognized: '" + newJsonTypeExtendedStr + "'.  Allowed values: " + this.getJsonTypesEnumAsStringList());
    }

    private void verifyNewCount(String newCountStr) throws ModifyJsonConfigException {
        boolean isValidCount;
        boolean bl = isValidCount = newCountStr.equals(".") || newCountStr.equals("0") || newCountStr.equals("1");
        if (!isValidCount) {
            throw new ModifyJsonConfigException("Modify TJSON config file: New count is not valid: " + newCountStr + ".  It should be a dot ('.') for arrays, 0 for flags/booleans, or 1 for single values");
        }
    }

    private String getColData(ModifyJsonColumnHeader colHeader, String[] columnData, Map<ModifyJsonColumnHeader, Integer> colHeaderNameToIdxMap) {
        int colIdx = colHeaderNameToIdxMap.get((Object)colHeader);
        if (colIdx >= 0 && colIdx < columnData.length) {
            return columnData[colIdx];
        }
        return null;
    }
}

