/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.exec.AbnormalExitException;
import edu.mayo.exec.UnixStreamCommand;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecPipe
extends AbstractPipe<String, String> {
    private static final Logger sLogger = LoggerFactory.getLogger(ExecPipe.class);
    private static final String[] ARGS = new String[0];
    private static final Map<String, String> NO_CUSTOM_ENV = new HashMap<String, String>();
    private boolean useParentEnv = true;
    private UnixStreamCommand cmd;
    private String commentSymbol = null;

    public ExecPipe(String[] cmdarray) throws IOException {
        this.cmd = new UnixStreamCommand(cmdarray, NO_CUSTOM_ENV, true, true);
        this.cmd.launch();
    }

    public ExecPipe(String[] cmdarray, boolean useParentEnv) throws IOException {
        this.cmd = new UnixStreamCommand(cmdarray, NO_CUSTOM_ENV, useParentEnv, true);
        this.cmd.launch();
    }

    public ExecPipe(String[] cmdarray, Map<String, String> customEnvironmentProperties, boolean useParentEnv) throws IOException {
        this.cmd = new UnixStreamCommand(cmdarray, customEnvironmentProperties, useParentEnv, true);
        this.cmd.launch();
    }

    public ExecPipe(String[] cmdarray, boolean useParentEnv, String commentSymbol) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException {
        this.commentSymbol = commentSymbol;
        this.cmd = new UnixStreamCommand(cmdarray, NO_CUSTOM_ENV, useParentEnv, true);
        this.cmd.launch();
        this.cmd.send("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\nchr1\t949608\trs0001\tG\tA\t.\t.\t.");
        this.cmd.receive();
        this.cmd.receive();
        this.cmd.receive();
        this.cmd.receive();
        this.cmd.receive();
    }

    public String processNextStart() {
        try {
            String line = (String)this.starts.next();
            this.cmd.send(line);
            String output = this.cmd.receive();
            return output;
        }
        catch (InterruptedException ex) {
            sLogger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (BrokenBarrierException ex) {
            sLogger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (TimeoutException ex) {
            sLogger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (UnsupportedEncodingException ex) {
            sLogger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            sLogger.error(ex.getMessage(), (Throwable)ex);
            throw new NoSuchElementException();
        }
        catch (AbnormalExitException ex) {
            sLogger.error(ex.getMessage(), (Throwable)ex);
        }
        throw new NoSuchElementException();
    }

    public void shutdown() throws InterruptedException, UnsupportedEncodingException {
        if (this.cmd != null) {
            this.cmd.terminate();
        }
    }
}

