/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.engine;

import com.googlecode.concurrenttrees.common.LazyIterator;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.OrderControlAttribute;
import com.googlecode.cqengine.attribute.OrderMissingFirstAttribute;
import com.googlecode.cqengine.attribute.OrderMissingLastAttribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.attribute.SimpleNullableAttribute;
import com.googlecode.cqengine.attribute.StandingQueryAttribute;
import com.googlecode.cqengine.engine.QueryEngine;
import com.googlecode.cqengine.engine.QueryEngineInternal;
import com.googlecode.cqengine.index.AttributeIndex;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.compound.CompoundIndex;
import com.googlecode.cqengine.index.compound.support.CompoundAttribute;
import com.googlecode.cqengine.index.compound.support.CompoundQuery;
import com.googlecode.cqengine.index.fallback.FallbackIndex;
import com.googlecode.cqengine.index.sqlite.IdentityAttributeIndex;
import com.googlecode.cqengine.index.sqlite.SQLiteIdentityIndex;
import com.googlecode.cqengine.index.sqlite.SimplifiedSQLiteIndex;
import com.googlecode.cqengine.index.standingquery.StandingQueryIndex;
import com.googlecode.cqengine.index.support.CloseableIterator;
import com.googlecode.cqengine.index.support.CloseableRequestResources;
import com.googlecode.cqengine.index.support.KeyValue;
import com.googlecode.cqengine.index.support.SortedKeyStatisticsAttributeIndex;
import com.googlecode.cqengine.index.support.SortedKeyStatisticsIndex;
import com.googlecode.cqengine.index.unique.UniqueIndex;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.persistence.support.ObjectStoreResultSet;
import com.googlecode.cqengine.persistence.support.sqlite.SQLiteObjectStore;
import com.googlecode.cqengine.query.ComparativeQuery;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.logical.LogicalQuery;
import com.googlecode.cqengine.query.logical.Not;
import com.googlecode.cqengine.query.logical.Or;
import com.googlecode.cqengine.query.option.AttributeOrder;
import com.googlecode.cqengine.query.option.DeduplicationOption;
import com.googlecode.cqengine.query.option.EngineFlags;
import com.googlecode.cqengine.query.option.EngineThresholds;
import com.googlecode.cqengine.query.option.FlagsEnabled;
import com.googlecode.cqengine.query.option.OrderByOption;
import com.googlecode.cqengine.query.option.QueryLog;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.option.Thresholds;
import com.googlecode.cqengine.query.simple.Between;
import com.googlecode.cqengine.query.simple.GreaterThan;
import com.googlecode.cqengine.query.simple.LessThan;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.closeable.CloseableResultSet;
import com.googlecode.cqengine.resultset.common.CostCachingResultSet;
import com.googlecode.cqengine.resultset.connective.ResultSetDifference;
import com.googlecode.cqengine.resultset.connective.ResultSetIntersection;
import com.googlecode.cqengine.resultset.connective.ResultSetUnion;
import com.googlecode.cqengine.resultset.connective.ResultSetUnionAll;
import com.googlecode.cqengine.resultset.filter.FilteringIterator;
import com.googlecode.cqengine.resultset.filter.FilteringResultSet;
import com.googlecode.cqengine.resultset.filter.MaterializedDeduplicatedIterator;
import com.googlecode.cqengine.resultset.iterator.ConcatenatingIterable;
import com.googlecode.cqengine.resultset.iterator.ConcatenatingIterator;
import com.googlecode.cqengine.resultset.iterator.IteratorUtil;
import com.googlecode.cqengine.resultset.iterator.UnmodifiableIterator;
import com.googlecode.cqengine.resultset.order.AttributeOrdersComparator;
import com.googlecode.cqengine.resultset.order.MaterializedDeduplicatedResultSet;
import com.googlecode.cqengine.resultset.order.MaterializedOrderedResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CollectionQueryEngine<O>
implements QueryEngineInternal<O> {
    public static final String ROOT_QUERY = "ROOT_QUERY";
    private volatile Persistence<O, ? extends Comparable> persistence;
    private volatile ObjectStore<O> objectStore;
    private final ConcurrentMap<Attribute<O, ?>, Set<Index<O>>> attributeIndexes = new ConcurrentHashMap();
    private final ConcurrentMap<Attribute<O, ?>, Index<O>> uniqueIndexes = new ConcurrentHashMap();
    private final ConcurrentMap<CompoundAttribute<O>, CompoundIndex<O>> compoundIndexes = new ConcurrentHashMap<CompoundAttribute<O>, CompoundIndex<O>>();
    private final ConcurrentMap<Query<O>, Index<O>> standingQueryIndexes = new ConcurrentHashMap<Query<O>, Index<O>>();
    private final FallbackIndex<O> fallbackIndex = new FallbackIndex();
    private final Set<Index<O>> immutableIndexes = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public void init(final ObjectStore<O> objectStore, final QueryOptions queryOptions) {
        this.objectStore = objectStore;
        Persistence persistenceFromQueryOptions = CollectionQueryEngine.getPersistenceFromQueryOptions(queryOptions);
        this.persistence = persistenceFromQueryOptions;
        if (objectStore instanceof SQLiteObjectStore) {
            SQLiteObjectStore sqLiteObjectStore = (SQLiteObjectStore)objectStore;
            SQLiteIdentityIndex backingIndex = sqLiteObjectStore.getBackingIndex();
            this.addIndex(backingIndex, queryOptions);
        }
        this.forEachIndexDo(new IndexOperation<O>(){

            @Override
            public boolean perform(Index<O> index) {
                queryOptions.put(QueryEngine.class, this);
                queryOptions.put(Persistence.class, CollectionQueryEngine.this.persistence);
                index.init(objectStore, queryOptions);
                return true;
            }
        });
    }

    @Override
    public void destroy(QueryOptions queryOptions) {
    }

    @Override
    public void addIndex(Index<O> index, QueryOptions queryOptions) {
        if (index instanceof StandingQueryIndex) {
            StandingQueryIndex standingQueryIndex = (StandingQueryIndex)index;
            this.addStandingQueryIndex(standingQueryIndex, standingQueryIndex.getStandingQuery(), queryOptions);
        } else if (index instanceof CompoundIndex) {
            CompoundIndex compoundIndex = (CompoundIndex)index;
            Attribute compoundAttribute = compoundIndex.getAttribute();
            this.addCompoundIndex(compoundIndex, (CompoundAttribute<O>)compoundAttribute, queryOptions);
        } else if (index instanceof AttributeIndex) {
            AttributeIndex attributeIndex = (AttributeIndex)index;
            Attribute indexedAttribute = attributeIndex.getAttribute();
            if (indexedAttribute instanceof StandingQueryAttribute) {
                StandingQueryAttribute standingQueryAttribute = (StandingQueryAttribute)indexedAttribute;
                Query standingQuery = standingQueryAttribute.getQuery();
                this.addStandingQueryIndex(index, standingQuery, queryOptions);
            } else {
                this.addAttributeIndex(attributeIndex, queryOptions);
            }
        } else {
            throw new IllegalStateException("Unexpected type of index: " + (index == null ? null : index.getClass().getName()));
        }
        if (!index.isMutable()) {
            this.immutableIndexes.add(index);
        }
    }

    <A> void addAttributeIndex(AttributeIndex<A, O> attributeIndex, QueryOptions queryOptions) {
        Attribute<O, A> attribute = attributeIndex.getAttribute();
        Set<Index> indexesOnThisAttribute = (Set<Index>)this.attributeIndexes.get(attribute);
        if (indexesOnThisAttribute == null) {
            indexesOnThisAttribute = Collections.newSetFromMap(new ConcurrentHashMap());
            this.attributeIndexes.put(attribute, indexesOnThisAttribute);
        }
        if (attributeIndex instanceof SimplifiedSQLiteIndex) {
            for (Index existingIndex : indexesOnThisAttribute) {
                if (!(existingIndex instanceof IdentityAttributeIndex)) continue;
                throw new IllegalStateException("An index has already been added on the primary key attribute used for persistence, and no additional non-heap indexes are allowed on that attribute: " + attribute);
            }
        }
        if (!indexesOnThisAttribute.add(attributeIndex)) {
            throw new IllegalStateException("An equivalent index has already been added for attribute: " + attribute);
        }
        if (attributeIndex instanceof UniqueIndex) {
            this.uniqueIndexes.put(attribute, attributeIndex);
        }
        queryOptions.put(QueryEngine.class, this);
        queryOptions.put(Persistence.class, this.persistence);
        attributeIndex.init(this.objectStore, queryOptions);
    }

    void addStandingQueryIndex(Index<O> standingQueryIndex, Query<O> standingQuery, QueryOptions queryOptions) {
        Index<O> existingIndex = this.standingQueryIndexes.putIfAbsent(standingQuery, standingQueryIndex);
        if (existingIndex != null) {
            throw new IllegalStateException("An index has already been added for standing query: " + standingQuery);
        }
        queryOptions.put(QueryEngine.class, this);
        queryOptions.put(Persistence.class, this.persistence);
        standingQueryIndex.init(this.objectStore, queryOptions);
    }

    void addCompoundIndex(CompoundIndex<O> compoundIndex, CompoundAttribute<O> compoundAttribute, QueryOptions queryOptions) {
        CompoundIndex<O> existingIndex = this.compoundIndexes.putIfAbsent(compoundAttribute, compoundIndex);
        if (existingIndex != null) {
            throw new IllegalStateException("An index has already been added for compound attribute: " + compoundAttribute);
        }
        queryOptions.put(QueryEngine.class, this);
        queryOptions.put(Persistence.class, this.persistence);
        compoundIndex.init(this.objectStore, queryOptions);
    }

    @Override
    public void removeIndex(Index<O> index, QueryOptions queryOptions) {
        boolean removed;
        if (index instanceof StandingQueryIndex) {
            StandingQueryIndex standingQueryIndex = (StandingQueryIndex)index;
            removed = this.standingQueryIndexes.remove(standingQueryIndex.getStandingQuery(), standingQueryIndex);
        } else if (index instanceof CompoundIndex) {
            CompoundIndex compoundIndex = (CompoundIndex)index;
            Attribute compoundAttribute = compoundIndex.getAttribute();
            removed = this.compoundIndexes.remove(compoundAttribute, compoundIndex);
        } else if (index instanceof AttributeIndex) {
            AttributeIndex attributeIndex = (AttributeIndex)index;
            Attribute indexedAttribute = attributeIndex.getAttribute();
            if (indexedAttribute instanceof StandingQueryAttribute) {
                StandingQueryAttribute standingQueryAttribute = (StandingQueryAttribute)indexedAttribute;
                Query standingQuery = standingQueryAttribute.getQuery();
                removed = this.standingQueryIndexes.remove(standingQuery, index);
            } else {
                Set indexesOnThisAttribute = (Set)this.attributeIndexes.get(indexedAttribute);
                removed = indexesOnThisAttribute.remove(attributeIndex);
                if (attributeIndex instanceof UniqueIndex) {
                    boolean bl = removed = this.uniqueIndexes.remove(indexedAttribute, attributeIndex) || removed;
                }
                if (indexesOnThisAttribute.isEmpty()) {
                    this.attributeIndexes.remove(indexedAttribute);
                }
            }
        } else {
            throw new IllegalStateException("Unexpected type of index: " + (index == null ? null : index.getClass().getName()));
        }
        if (removed && !index.isMutable()) {
            this.immutableIndexes.remove(index);
        }
        index.destroy(queryOptions);
    }

    @Override
    public Iterable<Index<O>> getIndexes() {
        ArrayList<Index<O>> indexes = new ArrayList<Index<O>>();
        for (Set attributeIndexes : this.attributeIndexes.values()) {
            indexes.addAll(attributeIndexes);
        }
        indexes.addAll(this.compoundIndexes.values());
        indexes.addAll(this.standingQueryIndexes.values());
        return indexes;
    }

    Iterable<Index<O>> getIndexesOnAttribute(Attribute<O, ?> attribute) {
        Set indexesOnAttribute = (Set)this.attributeIndexes.get(attribute);
        if (indexesOnAttribute == null || indexesOnAttribute.isEmpty()) {
            return Collections.singleton(this.fallbackIndex);
        }
        ArrayList<Set<FallbackIndex<O>>> iterables = new ArrayList<Set<FallbackIndex<O>>>(2);
        iterables.add(indexesOnAttribute);
        iterables.add(Collections.singleton(this.fallbackIndex));
        return new ConcatenatingIterable<Index<O>>(iterables);
    }

    ResultSet<O> getEntireCollectionAsResultSet(final Query<O> query, final QueryOptions queryOptions) {
        return new ObjectStoreResultSet<O>(this.objectStore, query, queryOptions, Integer.MAX_VALUE){

            @Override
            public int getMergeCost() {
                return Integer.MAX_VALUE;
            }

            @Override
            public Query<O> getQuery() {
                return query;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return queryOptions;
            }
        };
    }

    <A> ResultSet<O> retrieveSimpleQuery(SimpleQuery<O, A> query, QueryOptions queryOptions) {
        ResultSet<O> lowestCostResultSet = this.retrieveFromStandingQueryIndexIfAvailable(query, queryOptions);
        if (lowestCostResultSet != null) {
            return lowestCostResultSet;
        }
        Index uniqueIndex = (Index)this.uniqueIndexes.get(query.getAttribute());
        if (uniqueIndex != null && uniqueIndex.supportsQuery(query, queryOptions)) {
            return uniqueIndex.retrieve(query, queryOptions);
        }
        int lowestRetrievalCost = 0;
        Iterable<Index<O>> indexesOnAttribute = this.getIndexesOnAttribute(query.getAttribute());
        for (Index<O> index : indexesOnAttribute) {
            if (!index.supportsQuery(query, queryOptions)) continue;
            ResultSet<O> thisIndexResultSet = index.retrieve(query, queryOptions);
            int thisIndexRetrievalCost = thisIndexResultSet.getRetrievalCost();
            if (lowestCostResultSet != null && thisIndexRetrievalCost >= lowestRetrievalCost) continue;
            lowestCostResultSet = thisIndexResultSet;
            lowestRetrievalCost = thisIndexRetrievalCost;
        }
        if (lowestCostResultSet == null) {
            throw new IllegalStateException("Failed to locate an index supporting query: " + query);
        }
        return new CostCachingResultSet<O>(lowestCostResultSet);
    }

    <A> ResultSet<O> retrieveComparativeQuery(ComparativeQuery<O, A> query, QueryOptions queryOptions) {
        int lowestRetrievalCost = 0;
        ResultSet<O> lowestCostResultSet = null;
        Iterable<Index<O>> indexesOnAttribute = this.getIndexesOnAttribute(query.getAttribute());
        for (Index<O> index : indexesOnAttribute) {
            if (!index.supportsQuery(query, queryOptions)) continue;
            ResultSet<O> thisIndexResultSet = index.retrieve(query, queryOptions);
            int thisIndexRetrievalCost = thisIndexResultSet.getRetrievalCost();
            if (lowestCostResultSet != null && thisIndexRetrievalCost >= lowestRetrievalCost) continue;
            lowestCostResultSet = thisIndexResultSet;
            lowestRetrievalCost = thisIndexRetrievalCost;
        }
        if (lowestCostResultSet == null) {
            throw new IllegalStateException("Failed to locate an index supporting query: " + query);
        }
        return new CostCachingResultSet(lowestCostResultSet);
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query, final QueryOptions queryOptions) {
        ResultSet<O> resultSet;
        OrderByOption orderByOption = queryOptions.get(OrderByOption.class);
        queryOptions.put(ROOT_QUERY, query);
        QueryLog queryLog = queryOptions.get(QueryLog.class);
        Object indexForOrdering = null;
        if (orderByOption != null) {
            Double selectivityThreshold = Thresholds.getThreshold(queryOptions, (Object)EngineThresholds.INDEX_ORDERING_SELECTIVITY);
            if (selectivityThreshold == null) {
                selectivityThreshold = EngineThresholds.INDEX_ORDERING_SELECTIVITY.getThresholdDefault();
            }
            List allSortOrders = orderByOption.getAttributeOrders();
            if (selectivityThreshold != 0.0) {
                AttributeOrder firstOrder = allSortOrders.iterator().next();
                Attribute firstAttribute = firstOrder.getAttribute();
                if (firstAttribute instanceof OrderControlAttribute) {
                    Attribute firstAttributeDelegate = ((OrderControlAttribute)firstAttribute).getDelegateAttribute();
                    firstAttribute = firstAttributeDelegate;
                }
                if (firstAttribute instanceof SimpleAttribute || this.standingQueryIndexes.get(QueryFactory.not(QueryFactory.has(firstAttribute))) != null) {
                    for (Index index : this.getIndexesOnAttribute(firstAttribute)) {
                        if (!(index instanceof SortedKeyStatisticsAttributeIndex) || index.isQuantized()) continue;
                        indexForOrdering = (SortedKeyStatisticsAttributeIndex)index;
                        break;
                    }
                }
                if (queryLog != null) {
                    queryLog.log("indexForOrdering: " + (indexForOrdering == null ? null : indexForOrdering.getClass().getSimpleName()));
                }
                if (indexForOrdering != null) {
                    double querySelectivity;
                    if (selectivityThreshold == 1.0) {
                        querySelectivity = 0.0;
                    } else if (!indexForOrdering.supportsQuery(QueryFactory.has(firstAttribute), queryOptions)) {
                        querySelectivity = 1.0;
                    } else {
                        int queryCardinality = this.retrieveRecursive(query, queryOptions).getMergeCost();
                        int indexCardinality = indexForOrdering.retrieve(QueryFactory.has(firstAttribute), queryOptions).getMergeCost();
                        if (queryLog != null) {
                            queryLog.log("queryCardinality: " + queryCardinality);
                            queryLog.log("indexCardinality: " + indexCardinality);
                        }
                        querySelectivity = indexCardinality == 0 ? 1.0 : (queryCardinality > indexCardinality ? 0.0 : 1.0 - (double)queryCardinality / (double)indexCardinality);
                    }
                    if (queryLog != null) {
                        queryLog.log("querySelectivity: " + querySelectivity);
                        queryLog.log("selectivityThreshold: " + selectivityThreshold);
                    }
                    if (querySelectivity > selectivityThreshold) {
                        indexForOrdering = null;
                    }
                }
            }
        }
        if (indexForOrdering != null) {
            resultSet = this.retrieveWithIndexOrdering(query, queryOptions, orderByOption, (SortedKeyStatisticsIndex<?, O>)indexForOrdering);
            if (queryLog != null) {
                queryLog.log("orderingStrategy: index");
            }
        } else {
            resultSet = this.retrieveWithoutIndexOrdering(query, queryOptions, orderByOption);
            if (queryLog != null) {
                queryLog.log("orderingStrategy: materialize");
            }
        }
        return new CloseableResultSet<O>(resultSet, query, queryOptions){

            @Override
            public void close() {
                super.close();
                CloseableRequestResources.closeForQueryOptions(queryOptions);
            }
        };
    }

    ResultSet<O> retrieveWithoutIndexOrdering(Query<O> query, QueryOptions queryOptions, OrderByOption<O> orderByOption) {
        ResultSet<O> resultSet = this.retrieveRecursive(query, queryOptions);
        if (orderByOption != null) {
            AttributeOrdersComparator<O> comparator = new AttributeOrdersComparator<O>(orderByOption.getAttributeOrders(), queryOptions);
            resultSet = new MaterializedOrderedResultSet<O>(resultSet, comparator);
        }
        if (DeduplicationOption.isMaterialize(queryOptions)) {
            resultSet = new MaterializedDeduplicatedResultSet<O>(resultSet);
        }
        return resultSet;
    }

    ResultSet<O> retrieveWithIndexOrdering(final Query<O> query, final QueryOptions queryOptions, OrderByOption<O> orderByOption, final SortedKeyStatisticsIndex<?, O> indexForOrdering) {
        final List<AttributeOrder<O>> allSortOrders = orderByOption.getAttributeOrders();
        final AttributeOrder<O> primarySortOrder = allSortOrders.get(0);
        final OrderControlAttribute orderControlAttribute = primarySortOrder.getAttribute() instanceof OrderControlAttribute ? (OrderControlAttribute)primarySortOrder.getAttribute() : null;
        final Attribute<O, Comparable<Object>> primarySortAttribute = orderControlAttribute == null ? primarySortOrder.getAttribute() : orderControlAttribute.getDelegateAttribute();
        final boolean primarySortDescending = primarySortOrder.isDescending();
        final boolean attributeCanHaveZeroValues = !(primarySortAttribute instanceof SimpleAttribute);
        final boolean attributeCanHaveMoreThanOneValue = !(primarySortAttribute instanceof SimpleAttribute) && !(primarySortAttribute instanceof SimpleNullableAttribute);
        final RangeBounds rangeBoundsFromQuery = CollectionQueryEngine.getBoundsFromQuery(query, primarySortAttribute);
        return new ResultSet<O>(){

            @Override
            public Iterator<O> iterator() {
                Iterator combinedResults;
                Iterator mainResults = CollectionQueryEngine.this.retrieveWithIndexOrderingMainResults(query, queryOptions, indexForOrdering, allSortOrders, rangeBoundsFromQuery, attributeCanHaveMoreThanOneValue, primarySortDescending);
                if (attributeCanHaveZeroValues) {
                    Iterator missingResults = CollectionQueryEngine.this.retrieveWithIndexOrderingMissingResults(query, queryOptions, primarySortAttribute, allSortOrders, attributeCanHaveMoreThanOneValue);
                    combinedResults = orderControlAttribute instanceof OrderMissingFirstAttribute ? ConcatenatingIterator.concatenate(Arrays.asList(missingResults, mainResults)) : (orderControlAttribute instanceof OrderMissingLastAttribute ? ConcatenatingIterator.concatenate(Arrays.asList(mainResults, missingResults)) : (primarySortOrder.isDescending() ? ConcatenatingIterator.concatenate(Arrays.asList(mainResults, missingResults)) : ConcatenatingIterator.concatenate(Arrays.asList(missingResults, mainResults))));
                } else {
                    combinedResults = mainResults;
                }
                if (attributeCanHaveMoreThanOneValue) {
                    combinedResults = new MaterializedDeduplicatedIterator(combinedResults);
                }
                return combinedResults;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean contains(O object) {
                try (ResultSet rs = CollectionQueryEngine.this.retrieveWithoutIndexOrdering(query, queryOptions, null);){
                    boolean bl = rs.contains(object);
                    return bl;
                }
            }

            @Override
            public boolean matches(O object) {
                return query.matches(object, queryOptions);
            }

            @Override
            public Query<O> getQuery() {
                return query;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return queryOptions;
            }

            @Override
            public int getRetrievalCost() {
                try (ResultSet rs = CollectionQueryEngine.this.retrieveWithoutIndexOrdering(query, queryOptions, null);){
                    int n = rs.getRetrievalCost();
                    return n;
                }
            }

            @Override
            public int getMergeCost() {
                try (ResultSet rs = CollectionQueryEngine.this.retrieveWithoutIndexOrdering(query, queryOptions, null);){
                    int n = rs.getMergeCost();
                    return n;
                }
            }

            @Override
            public int size() {
                try (ResultSet rs = CollectionQueryEngine.this.retrieveWithoutIndexOrdering(query, queryOptions, null);){
                    int n = rs.size();
                    return n;
                }
            }

            @Override
            public void close() {
            }
        };
    }

    Iterator<O> retrieveWithIndexOrderingMainResults(Query<O> query, QueryOptions queryOptions, SortedKeyStatisticsIndex<?, O> indexForOrdering, List<AttributeOrder<O>> allSortOrders, RangeBounds<?> rangeBoundsFromQuery, boolean attributeCanHaveMoreThanOneValue, boolean primarySortDescending) {
        CloseableRequestResources.CloseableResourceGroup closeableResourceGroup = CloseableRequestResources.forQueryOptions(queryOptions).addGroup();
        List<AttributeOrder<O>> sortOrdersForBucket = CollectionQueryEngine.determineAdditionalSortOrdersForIndexOrdering(allSortOrders, attributeCanHaveMoreThanOneValue, indexForOrdering, queryOptions);
        final CloseableIterator<KeyValue<?, O>> keysAndValuesInRange = CollectionQueryEngine.getKeysAndValuesInRange(indexForOrdering, rangeBoundsFromQuery, primarySortDescending, queryOptions);
        closeableResourceGroup.add(keysAndValuesInRange);
        Object sorted = sortOrdersForBucket.isEmpty() ? new LazyIterator<O>(){

            protected O computeNext() {
                return keysAndValuesInRange.hasNext() ? ((KeyValue)keysAndValuesInRange.next()).getValue() : this.endOfData();
            }
        } : IteratorUtil.concatenate(IteratorUtil.groupAndSort(keysAndValuesInRange, new AttributeOrdersComparator<O>(sortOrdersForBucket, queryOptions)));
        return this.filterIndexOrderingCandidateResults((Iterator<O>)sorted, query, queryOptions);
    }

    Iterator<O> retrieveWithIndexOrderingMissingResults(Query<O> query, QueryOptions queryOptions, Attribute<O, Comparable> primarySortAttribute, List<AttributeOrder<O>> allSortOrders, boolean attributeCanHaveMoreThanOneValue) {
        CloseableRequestResources.CloseableResourceGroup closeableResourceGroup = CloseableRequestResources.forQueryOptions(queryOptions).addGroup();
        Not missingValuesQuery = QueryFactory.not(QueryFactory.has(primarySortAttribute));
        ResultSet missingResults = this.retrieveRecursive(missingValuesQuery, queryOptions);
        closeableResourceGroup.add(missingResults);
        Iterator missingResultsIterator = missingResults.iterator();
        missingResultsIterator = this.filterIndexOrderingCandidateResults(missingResultsIterator, query, queryOptions);
        Index indexForMissingObjects = (Index)this.standingQueryIndexes.get(missingValuesQuery);
        List<AttributeOrder<O>> sortOrdersForBucket = CollectionQueryEngine.determineAdditionalSortOrdersForIndexOrdering(allSortOrders, attributeCanHaveMoreThanOneValue, indexForMissingObjects, queryOptions);
        if (!sortOrdersForBucket.isEmpty()) {
            AttributeOrdersComparator<O> comparator = new AttributeOrdersComparator<O>(sortOrdersForBucket, queryOptions);
            missingResultsIterator = IteratorUtil.materializedSort(missingResultsIterator, comparator);
        }
        return missingResultsIterator;
    }

    Iterator<O> filterIndexOrderingCandidateResults(Iterator<O> sortedCandidateResults, final Query<O> query, QueryOptions queryOptions) {
        boolean indexMergeStrategyEnabled = FlagsEnabled.isFlagEnabled(queryOptions, (Object)EngineFlags.PREFER_INDEX_MERGE_STRATEGY);
        if (indexMergeStrategyEnabled) {
            final ResultSet<O> indexAcceleratedQueryResults = this.retrieveWithoutIndexOrdering(query, queryOptions, null);
            if (indexAcceleratedQueryResults.getRetrievalCost() == Integer.MAX_VALUE) {
                indexAcceleratedQueryResults.close();
            } else {
                CloseableRequestResources.CloseableResourceGroup closeableResourceGroup = CloseableRequestResources.forQueryOptions(queryOptions).addGroup();
                closeableResourceGroup.add(indexAcceleratedQueryResults);
                return new FilteringIterator<O>(sortedCandidateResults, queryOptions){

                    @Override
                    public boolean isValid(O object, QueryOptions queryOptions) {
                        return indexAcceleratedQueryResults.contains(object);
                    }
                };
            }
        }
        return new FilteringIterator<O>(sortedCandidateResults, queryOptions){

            @Override
            public boolean isValid(O object, QueryOptions queryOptions) {
                return query.matches(object, queryOptions);
            }
        };
    }

    static <O, A extends Comparable<A>> Persistence<O, A> getPersistenceFromQueryOptions(QueryOptions queryOptions) {
        Persistence persistence = queryOptions.get(Persistence.class);
        if (persistence == null) {
            throw new IllegalStateException("A required Persistence object was not supplied in query options");
        }
        return persistence;
    }

    static <O> List<AttributeOrder<O>> determineAdditionalSortOrdersForIndexOrdering(List<AttributeOrder<O>> allSortOrders, boolean attributeCanHaveMoreThanOneValue, Index<O> index, QueryOptions queryOptions) {
        return index.isQuantized() || attributeCanHaveMoreThanOneValue && !FlagsEnabled.isFlagEnabled(queryOptions, (Object)EngineFlags.INDEX_ORDERING_ALLOW_FAST_ORDERING_OF_MULTI_VALUED_ATTRIBUTES) ? allSortOrders : allSortOrders.subList(1, allSortOrders.size());
    }

    static <A extends Comparable<A>, O> CloseableIterator<KeyValue<A, O>> getKeysAndValuesInRange(SortedKeyStatisticsIndex<A, O> index, RangeBounds<?> queryBounds, boolean descending, QueryOptions queryOptions) {
        RangeBounds<?> typedBounds = queryBounds;
        if (!descending) {
            return index.getKeysAndValues(typedBounds.lowerBound, typedBounds.lowerInclusive, typedBounds.upperBound, typedBounds.upperInclusive, queryOptions).iterator();
        }
        return index.getKeysAndValuesDescending(typedBounds.lowerBound, typedBounds.lowerInclusive, typedBounds.upperBound, typedBounds.upperInclusive, queryOptions).iterator();
    }

    static <A extends Comparable<A>, O> RangeBounds getBoundsFromQuery(Query<O> query, Attribute<O, A> attribute) {
        And and;
        Object lowerBound = null;
        Object upperBound = null;
        boolean lowerInclusive = false;
        boolean upperInclusive = false;
        List<Object> candidateRangeQueries = Collections.emptyList();
        if (query instanceof SimpleQuery) {
            candidateRangeQueries = Collections.singletonList((SimpleQuery)query);
        } else if (query instanceof And && (and = (And)query).hasSimpleQueries()) {
            candidateRangeQueries = and.getSimpleQueries();
        }
        for (SimpleQuery simpleQuery : candidateRangeQueries) {
            SimpleQuery bound;
            if (!attribute.equals(simpleQuery.getAttribute())) continue;
            if (simpleQuery instanceof GreaterThan) {
                bound = (GreaterThan)simpleQuery;
                lowerBound = ((GreaterThan)bound).getValue();
                lowerInclusive = ((GreaterThan)bound).isValueInclusive();
                continue;
            }
            if (simpleQuery instanceof LessThan) {
                bound = (LessThan)simpleQuery;
                upperBound = ((LessThan)bound).getValue();
                upperInclusive = ((LessThan)bound).isValueInclusive();
                continue;
            }
            if (!(simpleQuery instanceof Between)) continue;
            bound = (Between)simpleQuery;
            lowerBound = ((Between)bound).getLowerValue();
            lowerInclusive = ((Between)bound).isLowerInclusive();
            upperBound = ((Between)bound).getUpperValue();
            upperInclusive = ((Between)bound).isUpperInclusive();
        }
        return new RangeBounds<Object>(lowerBound, lowerInclusive, upperBound, upperInclusive);
    }

    ResultSet<O> retrieveRecursive(Query<O> query, final QueryOptions queryOptions) {
        final boolean indexMergeStrategyEnabled = FlagsEnabled.isFlagEnabled(queryOptions, (Object)EngineFlags.PREFER_INDEX_MERGE_STRATEGY);
        ResultSet<O> resultSetFromStandingQueryIndex = this.retrieveFromStandingQueryIndexIfAvailable(query, queryOptions);
        if (resultSetFromStandingQueryIndex != null) {
            return resultSetFromStandingQueryIndex;
        }
        if (query instanceof SimpleQuery) {
            return this.retrieveSimpleQuery((SimpleQuery)query, queryOptions);
        }
        if (query instanceof ComparativeQuery) {
            return this.retrieveComparativeQuery((ComparativeQuery)query, queryOptions);
        }
        if (query instanceof And) {
            CompoundIndex compoundIndex;
            CompoundQuery compoundQuery;
            final And and = (And)query;
            if (!this.compoundIndexes.isEmpty() && (compoundQuery = CompoundQuery.fromAndQueryIfSuitable(and)) != null && (compoundIndex = (CompoundIndex)this.compoundIndexes.get(compoundQuery.getCompoundAttribute())) != null && compoundIndex.supportsQuery(compoundQuery, queryOptions)) {
                return compoundIndex.retrieve(compoundQuery, queryOptions);
            }
            Iterable resultSetsToMerge = new Iterable<ResultSet<O>>(){

                @Override
                public Iterator<ResultSet<O>> iterator() {
                    return new UnmodifiableIterator<ResultSet<O>>(){
                        boolean needToProcessSimpleQueries;
                        boolean needToProcessComparativeQueries;
                        Iterator<LogicalQuery<O>> logicalQueriesIterator;
                        {
                            this.needToProcessSimpleQueries = and.hasSimpleQueries();
                            this.needToProcessComparativeQueries = and.hasComparativeQueries();
                            this.logicalQueriesIterator = and.getLogicalQueries().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.needToProcessSimpleQueries || this.needToProcessComparativeQueries || this.logicalQueriesIterator.hasNext();
                        }

                        @Override
                        public ResultSet<O> next() {
                            if (this.needToProcessSimpleQueries) {
                                this.needToProcessSimpleQueries = false;
                                return CollectionQueryEngine.this.retrieveIntersectionOfSimpleQueries(and.getSimpleQueries(), queryOptions, indexMergeStrategyEnabled);
                            }
                            if (this.needToProcessComparativeQueries) {
                                this.needToProcessComparativeQueries = false;
                                return CollectionQueryEngine.this.retrieveIntersectionOfComparativeQueries(and.getComparativeQueries(), queryOptions);
                            }
                            return CollectionQueryEngine.this.retrieveRecursive(this.logicalQueriesIterator.next(), queryOptions);
                        }
                    };
                }
            };
            boolean useIndexMergeStrategy = CollectionQueryEngine.shouldUseIndexMergeStrategy(indexMergeStrategyEnabled, and.hasComparativeQueries(), resultSetsToMerge);
            return new ResultSetIntersection<O>(resultSetsToMerge, query, queryOptions, useIndexMergeStrategy);
        }
        if (query instanceof Or) {
            ResultSet union;
            final Or or = (Or)query;
            final QueryOptions queryOptionsForOrUnion = or.isDisjoint() ? new QueryOptions(queryOptions.getOptions()){

                @Override
                public Object get(Object key) {
                    return DeduplicationOption.class.equals(key) ? null : super.get(key);
                }
            } : queryOptions;
            Iterable resultSetsToUnion = new Iterable<ResultSet<O>>(){

                @Override
                public Iterator<ResultSet<O>> iterator() {
                    return new UnmodifiableIterator<ResultSet<O>>(){
                        boolean needToProcessSimpleQueries;
                        boolean needToProcessComparativeQueries;
                        Iterator<LogicalQuery<O>> logicalQueriesIterator;
                        {
                            this.needToProcessSimpleQueries = or.hasSimpleQueries();
                            this.needToProcessComparativeQueries = or.hasComparativeQueries();
                            this.logicalQueriesIterator = or.getLogicalQueries().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.needToProcessSimpleQueries || this.needToProcessComparativeQueries || this.logicalQueriesIterator.hasNext();
                        }

                        @Override
                        public ResultSet<O> next() {
                            if (this.needToProcessSimpleQueries) {
                                this.needToProcessSimpleQueries = false;
                                return CollectionQueryEngine.this.retrieveUnionOfSimpleQueries(or.getSimpleQueries(), queryOptionsForOrUnion);
                            }
                            if (this.needToProcessComparativeQueries) {
                                this.needToProcessComparativeQueries = false;
                                return CollectionQueryEngine.this.retrieveUnionOfComparativeQueries(or.getComparativeQueries(), queryOptionsForOrUnion);
                            }
                            return CollectionQueryEngine.this.retrieveRecursive(this.logicalQueriesIterator.next(), queryOptions);
                        }
                    };
                }
            };
            if (DeduplicationOption.isLogicalElimination(queryOptionsForOrUnion)) {
                boolean useIndexMergeStrategy = CollectionQueryEngine.shouldUseIndexMergeStrategy(indexMergeStrategyEnabled, or.hasComparativeQueries(), resultSetsToUnion);
                union = new ResultSetUnion<O>(resultSetsToUnion, query, queryOptions, useIndexMergeStrategy);
            } else {
                union = new ResultSetUnionAll<O>(resultSetsToUnion, query, queryOptions);
            }
            if (((ResultSet)union).getRetrievalCost() == Integer.MAX_VALUE && !or.hasComparativeQueries()) {
                union = new FilteringResultSet<O>(this.getEntireCollectionAsResultSet(query, queryOptions), or, queryOptions){

                    @Override
                    public boolean isValid(O object, QueryOptions queryOptions) {
                        return or.matches(object, queryOptions);
                    }
                };
            }
            return union;
        }
        if (query instanceof Not) {
            Not not = (Not)query;
            ResultSet resultSetToNegate = this.retrieveRecursive(not.getNegatedQuery(), queryOptions);
            return new ResultSetDifference<O>(this.getEntireCollectionAsResultSet(query, queryOptions), resultSetToNegate, query, queryOptions, indexMergeStrategyEnabled);
        }
        throw new IllegalStateException("Unexpected type of query object: " + CollectionQueryEngine.getClassNameNullSafe(query));
    }

    <A> ResultSet<O> retrieveIntersectionOfSimpleQueries(Collection<SimpleQuery<O, ?>> queries, QueryOptions queryOptions, boolean indexMergeStrategyEnabled) {
        Query query;
        ArrayList<ResultSet<O>> resultSets = new ArrayList<ResultSet<O>>(queries.size());
        Iterator<SimpleQuery<O, ?>> iterator = queries.iterator();
        while (iterator.hasNext()) {
            SimpleQuery<O, ?> queryTyped = query = iterator.next();
            ResultSet<O> resultSet = this.retrieveSimpleQuery(queryTyped, queryOptions);
            resultSets.add(resultSet);
        }
        Collection queriesTyped = queries;
        query = queriesTyped.size() == 1 ? (Query)queriesTyped.iterator().next() : new And(queriesTyped);
        boolean useIndexMergeStrategy = indexMergeStrategyEnabled && CollectionQueryEngine.indexesAvailableForAllResultSets(resultSets);
        return new ResultSetIntersection<O>(resultSets, query, queryOptions, useIndexMergeStrategy);
    }

    <A> ResultSet<O> retrieveIntersectionOfComparativeQueries(Collection<ComparativeQuery<O, ?>> queries, QueryOptions queryOptions) {
        Query query;
        ArrayList resultSets = new ArrayList(queries.size());
        Iterator<ComparativeQuery<O, ?>> iterator = queries.iterator();
        while (iterator.hasNext()) {
            ComparativeQuery<O, ?> queryTyped = query = iterator.next();
            ResultSet<O> resultSet = this.retrieveComparativeQuery(queryTyped, queryOptions);
            resultSets.add(resultSet);
        }
        Collection queriesTyped = queries;
        query = queriesTyped.size() == 1 ? (Query)queriesTyped.iterator().next() : new And(queriesTyped);
        return new ResultSetIntersection(resultSets, query, queryOptions, true);
    }

    ResultSet<O> retrieveUnionOfSimpleQueries(final Collection<SimpleQuery<O, ?>> queries, final QueryOptions queryOptions) {
        Query query;
        Iterable resultSetsToUnion = new Iterable<ResultSet<O>>(){

            @Override
            public Iterator<ResultSet<O>> iterator() {
                return new UnmodifiableIterator<ResultSet<O>>(){
                    Iterator<SimpleQuery<O, ?>> queriesIterator;
                    {
                        this.queriesIterator = queries.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.queriesIterator.hasNext();
                    }

                    @Override
                    public ResultSet<O> next() {
                        return CollectionQueryEngine.this.retrieveSimpleQuery(this.queriesIterator.next(), queryOptions);
                    }
                };
            }
        };
        Collection queriesTyped = queries;
        Query query2 = query = queriesTyped.size() == 1 ? (Query)queriesTyped.iterator().next() : new Or(queriesTyped);
        if (DeduplicationOption.isLogicalElimination(queryOptions)) {
            boolean indexMergeStrategyEnabled = FlagsEnabled.isFlagEnabled(queryOptions, (Object)EngineFlags.PREFER_INDEX_MERGE_STRATEGY);
            boolean useIndexMergeStrategy = indexMergeStrategyEnabled && CollectionQueryEngine.indexesAvailableForAllResultSets(resultSetsToUnion);
            return new ResultSetUnion(resultSetsToUnion, query, queryOptions, useIndexMergeStrategy);
        }
        return new ResultSetUnionAll(resultSetsToUnion, query, queryOptions);
    }

    ResultSet<O> retrieveUnionOfComparativeQueries(final Collection<ComparativeQuery<O, ?>> queries, final QueryOptions queryOptions) {
        Query query;
        Iterable resultSetsToUnion = new Iterable<ResultSet<O>>(){

            @Override
            public Iterator<ResultSet<O>> iterator() {
                return new UnmodifiableIterator<ResultSet<O>>(){
                    Iterator<ComparativeQuery<O, ?>> queriesIterator;
                    {
                        this.queriesIterator = queries.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.queriesIterator.hasNext();
                    }

                    @Override
                    public ResultSet<O> next() {
                        return CollectionQueryEngine.this.retrieveComparativeQuery(this.queriesIterator.next(), queryOptions);
                    }
                };
            }
        };
        Collection queriesTyped = queries;
        Query query2 = query = queriesTyped.size() == 1 ? (Query)queriesTyped.iterator().next() : new Or(queriesTyped);
        if (DeduplicationOption.isLogicalElimination(queryOptions)) {
            return new ResultSetUnion(resultSetsToUnion, query, queryOptions, true);
        }
        return new ResultSetUnionAll(resultSetsToUnion, query, queryOptions);
    }

    ResultSet<O> retrieveFromStandingQueryIndexIfAvailable(Query<O> query, QueryOptions queryOptions) {
        Index standingQueryIndex = (Index)this.standingQueryIndexes.get(query);
        if (standingQueryIndex != null) {
            if (standingQueryIndex instanceof StandingQueryIndex) {
                return standingQueryIndex.retrieve(query, queryOptions);
            }
            return standingQueryIndex.retrieve(QueryFactory.equal(QueryFactory.forStandingQuery(query), Boolean.TRUE), queryOptions);
        }
        return null;
    }

    @Override
    public boolean addAll(final ObjectSet<O> objectSet, final QueryOptions queryOptions) {
        this.ensureMutable();
        final FlagHolder modified = new FlagHolder();
        this.forEachIndexDo(new IndexOperation<O>(){

            @Override
            public boolean perform(Index<O> index) {
                modified.value |= index.addAll(objectSet, queryOptions);
                return true;
            }
        });
        return modified.value;
    }

    @Override
    public boolean removeAll(final ObjectSet<O> objectSet, final QueryOptions queryOptions) {
        this.ensureMutable();
        final FlagHolder modified = new FlagHolder();
        this.forEachIndexDo(new IndexOperation<O>(){

            @Override
            public boolean perform(Index<O> index) {
                modified.value |= index.removeAll(objectSet, queryOptions);
                return true;
            }
        });
        return modified.value;
    }

    @Override
    public void clear(final QueryOptions queryOptions) {
        this.ensureMutable();
        this.forEachIndexDo(new IndexOperation<O>(){

            @Override
            public boolean perform(Index<O> index) {
                index.clear(queryOptions);
                return true;
            }
        });
    }

    @Override
    public boolean isMutable() {
        return this.immutableIndexes.isEmpty();
    }

    void ensureMutable() {
        if (!this.immutableIndexes.isEmpty()) {
            throw new IllegalStateException("Cannot modify indexes, an immutable index has been added.");
        }
    }

    boolean forEachIndexDo(IndexOperation<O> indexOperation) {
        ConcatenatingIterable attributeIndexes = new ConcatenatingIterable(this.attributeIndexes.values());
        for (Object index : attributeIndexes) {
            boolean continueIterating = indexOperation.perform((Index<O>)index);
            if (continueIterating) continue;
            return false;
        }
        Collection compoundIndexes = this.compoundIndexes.values();
        for (Index index : compoundIndexes) {
            boolean continueIterating = indexOperation.perform(index);
            if (continueIterating) continue;
            return false;
        }
        Collection standingQueryIndexes = this.standingQueryIndexes.values();
        for (Index index : standingQueryIndexes) {
            boolean continueIterating = indexOperation.perform(index);
            if (continueIterating) continue;
            return false;
        }
        return indexOperation.perform(this.fallbackIndex);
    }

    static String getClassNameNullSafe(Object object) {
        return object == null ? null : object.getClass().getName();
    }

    static <O> boolean shouldUseIndexMergeStrategy(boolean strategyRequested, boolean comparativeQueriesPresent, Iterable<ResultSet<O>> resultSetsToMerge) {
        if (comparativeQueriesPresent) {
            return true;
        }
        return strategyRequested && CollectionQueryEngine.indexesAvailableForAllResultSets(resultSetsToMerge);
    }

    static <O> boolean indexesAvailableForAllResultSets(Iterable<ResultSet<O>> resultSetsToMerge) {
        for (ResultSet<O> resultSet : resultSetsToMerge) {
            if (resultSet.getRetrievalCost() != Integer.MAX_VALUE) continue;
            return false;
        }
        return true;
    }

    static class FlagHolder {
        boolean value = false;

        FlagHolder() {
        }
    }

    static interface IndexOperation<O> {
        public boolean perform(Index<O> var1);
    }

    static class RangeBounds<A extends Comparable<A>> {
        final A lowerBound;
        final boolean lowerInclusive;
        final A upperBound;
        final Boolean upperInclusive;

        public RangeBounds(A lowerBound, boolean lowerInclusive, A upperBound, Boolean upperInclusive) {
            this.lowerBound = lowerBound;
            this.lowerInclusive = lowerInclusive;
            this.upperBound = upperBound;
            this.upperInclusive = upperInclusive;
        }
    }
}

