/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.mq.app.refdata;

import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.lang3.StringUtils;

public class RefdataMessage {
    private static final String SYSTEM_PROP = "SYSTEM";
    private static final String EVENT_TYPE_PROP = "EVENT_TYPE";
    private static final String EVENT_STATUS_PROP = "EVENT_STATUS";
    private static final String UNIQUE_NAME_PROP = "REFDATA_UNIQUE_NAME";
    private static final String COMMON_NAME_PROP = "REFDATA_COMMON_NAME";
    private static final String VERSION_PROP = "REFDATA_VERSION";
    private static final String DATA_PATH_PROP = "REFDATA_PATH";
    private static final String ASSEMBLY_PROP = "REFDATA_ASSEMBLY";
    private static final String SOURCE_RELEASE_DATE_PROP = "REFDATA_SOURCE_RELEASE_DATE";
    private static final String SYSTEM_DEFAULT = "refdata";
    private static final String EVENT_TYPE_DEFAULT = "data_released";
    private static final String EVENT_STATUS_DEFAULT = "success";
    private String system;
    private String eventType;
    private String eventStatus;
    private String uniqueName;
    private String commonName;
    private String version;
    private String dataPath;
    private String assembly;
    private String sourceReleaseDate;

    private RefdataMessage(Builder builder) {
        this.system = builder.system;
        this.eventType = builder.eventType;
        this.eventStatus = builder.eventStatus;
        this.uniqueName = builder.uniqueName;
        this.commonName = builder.commonName;
        this.version = builder.version;
        this.dataPath = builder.dataPath;
        this.assembly = builder.assembly;
        this.sourceReleaseDate = builder.sourceReleaseDate;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(RefdataMessage.composeKeyValuePair(SYSTEM_PROP, this.system));
        stringBuilder.append(RefdataMessage.composeKeyValuePair(EVENT_TYPE_PROP, this.eventType));
        stringBuilder.append(RefdataMessage.composeKeyValuePair(EVENT_STATUS_PROP, this.eventStatus));
        stringBuilder.append(RefdataMessage.composeKeyValuePair(UNIQUE_NAME_PROP, this.uniqueName));
        stringBuilder.append(RefdataMessage.composeKeyValuePair(COMMON_NAME_PROP, this.commonName));
        stringBuilder.append(RefdataMessage.composeKeyValuePair(VERSION_PROP, this.version));
        stringBuilder.append(RefdataMessage.composeKeyValuePair(DATA_PATH_PROP, this.dataPath));
        stringBuilder.append(RefdataMessage.composeKeyValuePair(ASSEMBLY_PROP, this.assembly));
        stringBuilder.append(RefdataMessage.composeKeyValuePair(SOURCE_RELEASE_DATE_PROP, this.sourceReleaseDate));
        return stringBuilder.toString();
    }

    private static String composeKeyValuePair(String key, String value) {
        return String.format("%s:%s%n", key, value);
    }

    public String getSystem() {
        return this.system;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventStatus() {
        return this.eventStatus;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getAssembly() {
        return this.assembly;
    }

    public String getSourceReleaseDate() {
        return this.sourceReleaseDate;
    }

    public void fillJMSMessage(Message message) throws JMSException {
        message.setStringProperty(SYSTEM_PROP, this.getSystem());
        message.setStringProperty(EVENT_TYPE_PROP, this.getEventType());
        message.setStringProperty(EVENT_STATUS_PROP, this.getEventStatus());
        message.setStringProperty(UNIQUE_NAME_PROP, this.getUniqueName());
        message.setStringProperty(COMMON_NAME_PROP, this.getCommonName());
        message.setStringProperty(VERSION_PROP, this.getVersion());
        message.setStringProperty(DATA_PATH_PROP, this.getDataPath());
        message.setStringProperty(ASSEMBLY_PROP, this.getAssembly());
        message.setStringProperty(SOURCE_RELEASE_DATE_PROP, this.getSourceReleaseDate());
    }

    public static class Builder {
        private String system = "refdata";
        private String eventType = "data_released";
        private String eventStatus = "success";
        private String uniqueName;
        private String commonName;
        private String version;
        private String dataPath;
        private String assembly;
        private String sourceReleaseDate;

        public Builder(Message message) throws JMSException {
            this(message.getStringProperty(RefdataMessage.COMMON_NAME_PROP));
            this.system(message.getStringProperty(RefdataMessage.SYSTEM_PROP));
            this.eventType(message.getStringProperty(RefdataMessage.EVENT_TYPE_PROP));
            this.eventStatus(message.getStringProperty(RefdataMessage.EVENT_STATUS_PROP));
            this.uniqueName(message.getStringProperty(RefdataMessage.UNIQUE_NAME_PROP));
            this.version(message.getStringProperty(RefdataMessage.VERSION_PROP));
            this.dataPath(message.getStringProperty(RefdataMessage.DATA_PATH_PROP));
            this.assembly(message.getStringProperty(RefdataMessage.ASSEMBLY_PROP));
            this.sourceReleaseDate(message.getStringProperty(RefdataMessage.SOURCE_RELEASE_DATE_PROP));
        }

        public Builder(String commonName) {
            this.commonName = commonName;
        }

        public Builder system(String system) {
            this.system = system;
            return this;
        }

        public Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        public Builder uniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder dataPath(String dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public Builder assembly(String assembly) {
            this.assembly = assembly;
            return this;
        }

        public Builder sourceReleaseDate(String sourceReleaseDate) {
            this.sourceReleaseDate = sourceReleaseDate;
            return this;
        }

        public RefdataMessage build() {
            this.checkIfEmpty(this.system, "system");
            this.checkIfEmpty(this.eventType, "event type");
            this.checkIfEmpty(this.eventStatus, "event status");
            this.checkIfEmpty(this.uniqueName, "unique name");
            this.checkIfEmpty(this.commonName, "common name");
            this.checkIfEmpty(this.version, "version");
            this.checkIfEmpty(this.dataPath, "data path");
            this.checkIfEmpty(this.assembly, "assembly");
            this.checkIfEmpty(this.sourceReleaseDate, "source release date");
            return new RefdataMessage(this);
        }

        private void checkIfEmpty(String attribute, String description) throws IllegalStateException {
            if (StringUtils.isBlank((CharSequence)attribute)) {
                throw new IllegalStateException("Must supply a non empty value to Builder for " + description);
            }
        }
    }
}

