/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.filter.cqengine.plugin;

import edu.mayo.genomicutils.vcf.filter.cqengine.AttributeType;
import edu.mayo.genomicutils.vcf.filter.cqengine.CQEngineUtil;
import edu.mayo.genomicutils.vcf.filter.cqengine.IndexableObject;
import edu.mayo.genomicutils.vcf.filter.cqengine.plugin.VCFTransformPlugin;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataVCFTransformPluginImpl
implements VCFTransformPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataVCFTransformPluginImpl.class);
    private VCFHeader vcfHeader;
    private IndexableObject indexableObj;

    @Override
    public void init(VCFHeader header) {
        this.vcfHeader = header;
    }

    @Override
    public Map<String, AttributeType> getFields() {
        HashMap<String, AttributeType> m = new HashMap<String, AttributeType>();
        HashSet<String> headerLineKeys = new HashSet<String>();
        for (VCFHeaderLine headerLine : this.vcfHeader.getMetaDataInInputOrder()) {
            if (!this.isMetadataLine(headerLine)) continue;
            if (!headerLineKeys.contains(headerLine.getKey())) {
                headerLineKeys.add(headerLine.getKey());
                String attrName = CQEngineUtil.getAttributeName(headerLine.getKey());
                AttributeType attributeType = MetadataVCFTransformPluginImpl.isArray(headerLine) ? AttributeType.STRING_ARRAY : AttributeType.STRING;
                m.put(attrName, attributeType);
                continue;
            }
            LOGGER.warn(String.format("Duplicate header key %s in line: %s", headerLine.getKey(), headerLine.toString()));
        }
        return m;
    }

    @Override
    public IndexableObject getObject(String[] vcfRow, Set<String> attrNamesInQuery) {
        if (this.indexableObj == null) {
            this.indexableObj = this.toIndexableObject(this.vcfHeader);
        }
        return this.indexableObj;
    }

    private IndexableObject toIndexableObject(VCFHeader vcfHeader) {
        IndexableObject indexableObj = new IndexableObject();
        HashSet<String> headerLineKeys = new HashSet<String>();
        for (VCFHeaderLine headerLine : vcfHeader.getMetaDataInInputOrder()) {
            if (!this.isMetadataLine(headerLine) || headerLineKeys.contains(headerLine.getKey())) continue;
            headerLineKeys.add(headerLine.getKey());
            String attrName = CQEngineUtil.getAttributeName(headerLine.getKey());
            if (MetadataVCFTransformPluginImpl.isArray(headerLine)) {
                indexableObj.put(attrName, MetadataVCFTransformPluginImpl.getArrayValues(headerLine));
                continue;
            }
            indexableObj.put(attrName, headerLine.getValue());
        }
        return indexableObj;
    }

    private boolean isMetadataLine(VCFHeaderLine line) {
        return line.getClass().equals(VCFHeaderLine.class) && !line.getValue().trim().startsWith("<");
    }

    static boolean isArray(VCFHeaderLine line) {
        String trimmedValue = line.getValue().trim();
        return trimmedValue.startsWith("[") && trimmedValue.endsWith("]");
    }

    static List<String> getArrayValues(VCFHeaderLine line) {
        ArrayList<String> list = new ArrayList<String>();
        String trimmedValue = line.getValue().trim();
        String valuesStr = trimmedValue.substring(1, trimmedValue.length() - 1);
        for (String value : valuesStr.split(",")) {
            String trimmed = value.trim();
            if (trimmed.length() <= 0) continue;
            list.add(value.trim());
        }
        return list;
    }
}

