/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.filter.cqengine.plugin;

import edu.mayo.genomicutils.vcf.filter.cqengine.AttributeType;
import edu.mayo.genomicutils.vcf.filter.cqengine.IndexableObject;
import edu.mayo.genomicutils.vcf.filter.cqengine.plugin.VCFTransformPlugin;
import htsjdk.variant.vcf.VCFHeader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FixedVCFTransformPluginImpl
implements VCFTransformPlugin {
    static final String ATTR_CHROM = "CHROM";
    static final String ATTR_POS = "POS";
    static final String ATTR_ID = "ID";
    static final String ATTR_REF = "REF";
    static final String ATTR_ALT = "ALT";
    static final String ATTR_QUAL = "QUAL";
    static final String ATTR_FILTER = "FILTER";

    @Override
    public void init(VCFHeader header) {
    }

    @Override
    public Map<String, AttributeType> getFields() {
        HashMap<String, AttributeType> m = new HashMap<String, AttributeType>();
        m.put(ATTR_CHROM, AttributeType.STRING);
        m.put(ATTR_POS, AttributeType.INTEGER);
        m.put(ATTR_ID, AttributeType.STRING);
        m.put(ATTR_REF, AttributeType.STRING);
        m.put(ATTR_ALT, AttributeType.STRING);
        m.put(ATTR_QUAL, AttributeType.FLOAT);
        m.put(ATTR_FILTER, AttributeType.STRING);
        return m;
    }

    @Override
    public IndexableObject getObject(String[] vcfRow, Set<String> attrNamesInQuery) {
        IndexableObject o = new IndexableObject();
        String chrom = vcfRow[0];
        String pos = vcfRow[1];
        String id = vcfRow[2];
        String ref = vcfRow[3];
        String alt = vcfRow[4];
        String qual = vcfRow[5];
        String filter = vcfRow[6];
        if (attrNamesInQuery.contains(ATTR_CHROM)) {
            o.put(ATTR_CHROM, chrom);
        }
        if (attrNamesInQuery.contains(ATTR_POS)) {
            o.put(ATTR_POS, Integer.parseInt(pos));
        }
        if (attrNamesInQuery.contains(ATTR_ID) && !this.isNull(id)) {
            o.put(ATTR_ID, id);
        }
        if (attrNamesInQuery.contains(ATTR_REF)) {
            o.put(ATTR_REF, ref);
        }
        if (attrNamesInQuery.contains(ATTR_ALT) && !this.isNull(alt)) {
            o.put(ATTR_ALT, alt);
        }
        if (attrNamesInQuery.contains(ATTR_QUAL) && !this.isNull(qual)) {
            o.put(ATTR_QUAL, Float.valueOf(Float.parseFloat(qual)));
        }
        if (attrNamesInQuery.contains(ATTR_FILTER) && !this.isNull(filter)) {
            o.put(ATTR_FILTER, filter);
        }
        return o;
    }

    private boolean isNull(String s) {
        return s.trim().equals(".");
    }
}

