/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.filter.cqengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SqlPreProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlPreProcessor.class);
    private static final char ASTERISK = '*';

    SqlPreProcessor() {
    }

    static String wildcardExpansion(String sql, Collection<String> columnNames) {
        LOGGER.info("Wildcard expansion using columns {} on SQL {}", (Object)columnNames.toString(), (Object)sql);
        String sqlWithoutComments = Pattern.compile("[/][*].*?[*][/]", 32).matcher(sql).replaceAll("");
        int whereIdx = sqlWithoutComments.toUpperCase().indexOf("WHERE");
        if (whereIdx == -1) {
            return sql;
        }
        String whereClause = sqlWithoutComments.substring(whereIdx);
        List<String> expansionTokens = SqlPreProcessor.getExpansionTokens(whereClause, '*');
        Map<String, String> expansionTokenToColumnName = SqlPreProcessor.expandTokens(expansionTokens, columnNames);
        for (String expansionToken : expansionTokenToColumnName.keySet()) {
            String columnName = expansionTokenToColumnName.get(expansionToken);
            sql = sql.replace(expansionToken, columnName);
            LOGGER.info("Expanding {} to be column {}", (Object)expansionToken, (Object)columnName);
        }
        return sql;
    }

    static List<String> getExpansionTokens(String s, char expansionChar) {
        ArrayList<String> expansionTokens = new ArrayList<String>();
        int idx = s.indexOf(expansionChar);
        while (idx != -1) {
            String expansionToken = SqlPreProcessor.grabSurroundingCharacters(s, idx);
            if (expansionToken.length() == 1 && expansionToken.charAt(0) == '*') {
                throw new RuntimeException("At least one alphanumeric character is required next to a wildcard at SQL position: " + idx);
            }
            if (!expansionTokens.contains(expansionToken)) {
                expansionTokens.add(expansionToken);
            }
            idx = s.indexOf(expansionChar, idx + 1);
        }
        return expansionTokens;
    }

    static Map<String, String> expandTokens(List<String> expansionTokens, Collection<String> columnNames) {
        HashMap<String, String> expansionTokenToColumnName = new HashMap<String, String>();
        for (String columnName : columnNames) {
            for (String expansionToken : expansionTokens) {
                if (!FilenameUtils.wildcardMatch((String)columnName.toUpperCase(), (String)expansionToken.toUpperCase())) continue;
                if (expansionTokenToColumnName.containsKey(expansionToken)) {
                    throw new RuntimeException(String.format("Expansion token %s expands to multiple columns: %s %s", expansionToken, expansionTokenToColumnName.get(expansionToken), columnName));
                }
                expansionTokenToColumnName.put(expansionToken, columnName);
            }
        }
        ArrayList<String> nonExpandableTokens = new ArrayList<String>(expansionTokens);
        nonExpandableTokens.removeAll(expansionTokenToColumnName.keySet());
        Collections.sort(nonExpandableTokens);
        int count = 0;
        for (String nonExpandableToken : nonExpandableTokens) {
            String replacement = "NON_EXPANDABLE" + ++count;
            expansionTokenToColumnName.put(nonExpandableToken, replacement);
            LOGGER.warn("The token {} could not be expanded to any of the available columns.  It is being replaced with {}.", (Object)nonExpandableToken, (Object)replacement);
        }
        return expansionTokenToColumnName;
    }

    static String grabSurroundingCharacters(String s, int idx) {
        int leftIdx = idx;
        if (idx > 0) {
            char c;
            int i = idx - 1;
            while (i >= 0 && (Character.isLetterOrDigit(c = s.charAt(i)) || c == '.' || c == '-' || c == '_' || c == '\"')) {
                leftIdx = i--;
            }
        }
        int rightIdx = idx;
        if (idx < s.length() - 1) {
            char c;
            int i = idx + 1;
            while (i < s.length() && (Character.isLetterOrDigit(c = s.charAt(i)) || c == '.' || c == '-' || c == '_' || c == '\"')) {
                rightIdx = i++;
            }
        }
        return s.substring(leftIdx, rightIdx + 1);
    }
}

