/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.filter.cqengine;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.MultiValueAttribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import edu.mayo.genomicutils.vcf.filter.cqengine.AttributeType;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AttributeFactory {
    public static Attribute buildAttribute(String attributeName, AttributeType attributeType) {
        Object attr;
        switch (attributeType) {
            case CHARACTER: {
                attr = AttributeFactory.getCharacterAttrib(attributeName);
                break;
            }
            case INTEGER: {
                attr = AttributeFactory.getIntegerAttrib(attributeName);
                break;
            }
            case FLOAT: {
                attr = AttributeFactory.getFloatAttrib(attributeName);
                break;
            }
            case STRING: {
                attr = AttributeFactory.getStringAttrib(attributeName);
                break;
            }
            case CHARACTER_ARRAY: {
                attr = AttributeFactory.getCharacterListAttrib(attributeName);
                break;
            }
            case INTEGER_ARRAY: {
                attr = AttributeFactory.getIntegerListAttrib(attributeName);
                break;
            }
            case FLOAT_ARRAY: {
                attr = AttributeFactory.getFloatListAttrib(attributeName);
                break;
            }
            case STRING_ARRAY: {
                attr = AttributeFactory.getStringListAttrib(attributeName);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unsupported attribute type: %s", attributeType.name()));
            }
        }
        return attr;
    }

    static MultiValueAttribute<Map, String> getStringListAttrib(final String attributeName) {
        return new MultiValueAttribute<Map, String>(attributeName){

            public Iterable<String> getValues(Map o, QueryOptions queryOptions) {
                return o.containsKey(attributeName) ? (List)o.get(attributeName) : Collections.EMPTY_LIST;
            }
        };
    }

    static SimpleAttribute<Map, String> getStringAttrib(final String attributeName) {
        return new SimpleAttribute<Map, String>(attributeName){

            public String getValue(Map o, QueryOptions queryOptions) {
                return (String)o.get(attributeName);
            }
        };
    }

    static MultiValueAttribute<Map, Integer> getIntegerListAttrib(final String attributeName) {
        return new MultiValueAttribute<Map, Integer>(attributeName){

            public Iterable<Integer> getValues(Map o, QueryOptions queryOptions) {
                return o.containsKey(attributeName) ? (List)o.get(attributeName) : Collections.EMPTY_LIST;
            }
        };
    }

    static SimpleAttribute<Map, Integer> getIntegerAttrib(final String attributeName) {
        return new SimpleAttribute<Map, Integer>(attributeName){

            public Integer getValue(Map o, QueryOptions queryOptions) {
                return (Integer)o.get(attributeName);
            }
        };
    }

    static MultiValueAttribute<Map, Float> getFloatListAttrib(final String attributeName) {
        return new MultiValueAttribute<Map, Float>(attributeName){

            public Iterable<Float> getValues(Map o, QueryOptions queryOptions) {
                return o.containsKey(attributeName) ? (List)o.get(attributeName) : Collections.EMPTY_LIST;
            }
        };
    }

    static SimpleAttribute<Map, Float> getFloatAttrib(final String attributeName) {
        return new SimpleAttribute<Map, Float>(attributeName){

            public Float getValue(Map o, QueryOptions queryOptions) {
                return (Float)o.get(attributeName);
            }
        };
    }

    static MultiValueAttribute<Map, Character> getCharacterListAttrib(final String attributeName) {
        return new MultiValueAttribute<Map, Character>(attributeName){

            public Iterable<Character> getValues(Map o, QueryOptions queryOptions) {
                return o.containsKey(attributeName) ? (List)o.get(attributeName) : Collections.EMPTY_LIST;
            }
        };
    }

    static SimpleAttribute<Map, Character> getCharacterAttrib(final String attributeName) {
        return new SimpleAttribute<Map, Character>(attributeName){

            public Character getValue(Map o, QueryOptions queryOptions) {
                return (Character)o.get(attributeName);
            }
        };
    }
}

