/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.extract;

import edu.mayo.genomicutils.vcf.extract.AggregateColumnValueStrategy;
import edu.mayo.genomicutils.vcf.extract.FlatFileHeader;
import edu.mayo.genomicutils.vcf.extract.FlatFileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlatFileAggregator {
    private String colName;
    private AggregateColumnValueStrategy strategy;
    private String delimiter;

    public FlatFileAggregator(String colName, AggregateColumnValueStrategy valueStrategy, String delimiter) {
        this.colName = colName;
        this.strategy = valueStrategy;
        this.delimiter = delimiter;
    }

    public void aggregate(Writer writer, List<File> flatFiles) throws IOException {
        PrintWriter printWtr = new PrintWriter(writer);
        Map<File, FlatFileHeader> fileToHeaderMap = this.getHeaders(flatFiles);
        this.writeFileHeaderContents(printWtr, flatFiles, fileToHeaderMap);
        for (File f : flatFiles) {
            this.writeFileDataContents(printWtr, this.strategy.getName(f), f);
            printWtr.flush();
        }
    }

    private Map<File, FlatFileHeader> getHeaders(List<File> flatFiles) throws IOException {
        HashMap<File, FlatFileHeader> m = new HashMap<File, FlatFileHeader>();
        for (File flatFile : flatFiles) {
            List<String> allHeaderLines = FlatFileUtil.grabHeaderLines(flatFile);
            m.put(flatFile, FlatFileUtil.toFlatFileHeader(allHeaderLines));
        }
        return m;
    }

    private void writeFileHeaderContents(PrintWriter wtr, List<File> flatFiles, Map<File, FlatFileHeader> fileToHeaderMap) throws IOException {
        ArrayList<String> miscHeaderLinesUnion = new ArrayList<String>();
        for (File flatFile : flatFiles) {
            FlatFileHeader h = fileToHeaderMap.get(flatFile);
            for (String miscHeaderLine : h.miscHeaderLines) {
                if (miscHeaderLinesUnion.contains(miscHeaderLine)) continue;
                miscHeaderLinesUnion.add(miscHeaderLine);
            }
        }
        for (String miscHeaderLine : miscHeaderLinesUnion) {
            wtr.println(miscHeaderLine);
        }
        if (fileToHeaderMap.size() > 0) {
            FlatFileHeader h = fileToHeaderMap.get(fileToHeaderMap.keySet().iterator().next());
            if (h.columnHeader != null && h.columnHeader.length() > 0) {
                wtr.print('#');
                wtr.print(this.colName);
                wtr.print(this.delimiter);
                if (h.columnHeader.length() > 0) {
                    wtr.print(h.columnHeader.substring(1));
                }
                wtr.println();
            }
        }
        wtr.flush();
    }

    private void writeFileDataContents(PrintWriter wtr, String name, File flatFile) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(flatFile));){
            String line;
            boolean pastHeader = false;
            while ((line = br.readLine()) != null) {
                if (!pastHeader) {
                    boolean bl = pastHeader = !FlatFileUtil.isHeaderLine(line);
                }
                if (!pastHeader) continue;
                wtr.print(name);
                wtr.print(this.delimiter);
                wtr.print(line);
                wtr.println();
            }
        }
    }
}

