/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.createcatalog;

import edu.mayo.exec.Command;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabixCmd {
    private static Logger sLogger = LoggerFactory.getLogger(TabixCmd.class);

    public static void main(String[] args) {
        try {
            if (args.length > 0 || args.length == 1 && args[0].equals("-h")) {
                System.out.println("Find the preferred location of the tabix command from (in this order):\n  $PATH\n  $BIOR_LITE_HOME\n  (relative project path - for tests)\n  (resource path - for command line use)");
                System.exit(0);
            }
            File tabixInPath = TabixCmd.getTabixFromPath();
            File tabixInBiorHome = TabixCmd.getTabixFromBiorHome();
            File tabixFromRelPath = TabixCmd.getTabixFromRelativePath();
            File tabixFromRscPath = TabixCmd.getTabixFromResourcePath();
            System.out.println("Tabix in $PATH:                " + TabixCmd.getAbsPath(tabixInPath) + ".  exists?: " + TabixCmd.isExist(tabixInPath));
            System.out.println("Tabix in $BIOR_LITE_HOME/bin:  " + TabixCmd.getAbsPath(tabixInBiorHome) + ".  exists?: " + TabixCmd.isExist(tabixInBiorHome));
            System.out.println("Tabix in relative path:        " + TabixCmd.getAbsPath(tabixFromRelPath) + ".  exists?: " + TabixCmd.isExist(tabixFromRelPath));
            System.out.println("Tabix in resource path:        " + TabixCmd.getAbsPath(tabixFromRscPath) + ".  exists?: " + TabixCmd.isExist(tabixFromRscPath));
            String tabixPrefPath = TabixCmd.getTabixPreferredPath();
            System.out.println("Tabix preferred path:          " + tabixPrefPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File createTabixIndex(String bgzipCatalogPath) throws IOException, InterruptedException {
        String tabixCmdPath = TabixCmd.getTabixPreferredPath();
        String[] cmdArgs = new String[]{tabixCmdPath, "-s", "1", "-b", "2", "-e", "3", bgzipCatalogPath};
        Map<String, String> sysEnvMap = System.getenv();
        Command cmd = new Command(cmdArgs, sysEnvMap, true);
        cmd.execute();
        String stderr = cmd.getStderr();
        String stdout = cmd.getStdout();
        sLogger.info("Info messages from building tabix index via command:");
        sLogger.info("StdOut: " + stdout);
        sLogger.warn("StdErr: " + stderr);
        File tabixIndexFile = new File(bgzipCatalogPath + ".tbi");
        if (!tabixIndexFile.exists()) {
            throw new FileNotFoundException("Tabix index could not be created: " + tabixIndexFile.getCanonicalPath());
        }
        return tabixIndexFile;
    }

    public static String getTabixPreferredPath() throws FileNotFoundException {
        File tabixOnPath = TabixCmd.getTabixFromPath();
        if (TabixCmd.isExist(tabixOnPath)) {
            return tabixOnPath.getAbsolutePath();
        }
        File tabixInBiorBin = TabixCmd.getTabixFromBiorHome();
        if (TabixCmd.isExist(tabixInBiorBin)) {
            return tabixInBiorBin.getAbsolutePath();
        }
        File tabixInRelativePath = TabixCmd.getTabixFromRelativePath();
        if (TabixCmd.isExist(tabixInRelativePath)) {
            return tabixInRelativePath.getAbsolutePath();
        }
        File tabixFromResourcePath = TabixCmd.getTabixFromResourcePath();
        if (TabixCmd.isExist(tabixFromResourcePath)) {
            return tabixFromResourcePath.getAbsolutePath();
        }
        throw new FileNotFoundException("Error: could not find tabix command");
    }

    protected static boolean isExist(File file) {
        return file != null && file.exists();
    }

    protected static String getAbsPath(File file) {
        if (file == null) {
            return "null";
        }
        return file.getAbsolutePath();
    }

    public static File getTabixFromBiorHome() {
        return new File(TabixCmd.getBiorHomeDirSysVar() + "/bin", TabixCmd.getSpecialTabixCmdName());
    }

    public static File getTabixFromPath() {
        return TabixCmd.getFromPath("tabix");
    }

    public static File getFromPath(String cmd) {
        String[] paths;
        String pathVar = TabixCmd.getPathSysVar();
        for (String path : paths = pathVar.split(File.pathSeparator)) {
            File tabixCmd = new File(path, cmd);
            if (!tabixCmd.exists()) continue;
            return tabixCmd;
        }
        return null;
    }

    public static File getTabixFromRelativePath() {
        String OS = System.getProperty("os.name").toLowerCase();
        boolean isMac = OS.contains("mac");
        File tabixCmdPath = new File("src/main/scripts/" + (isMac ? "tabixMac" : "tabixLinux"));
        return tabixCmdPath;
    }

    public static File getTabixFromResourcePath() {
        String pathToClass = TabixCmd.class.getResource("/").getPath();
        System.out.println("pathToClass: " + pathToClass);
        return new File(pathToClass + "../bin", TabixCmd.getSpecialTabixCmdName());
    }

    public static String getBiorHomeDirSysVar() {
        return System.getenv("BIOR_LITE_HOME");
    }

    public static String getPathSysVar() {
        return System.getenv("PATH");
    }

    private static String getSpecialTabixCmdName() {
        String OS = System.getProperty("os.name").toLowerCase();
        boolean isMac = OS.contains("mac");
        return isMac ? "tabixMac" : "tabixLinux";
    }
}

