/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.bior.util.CatalogUtils;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.cli.InvalidDataException;
import edu.mayo.cli.InvalidOptionArgValueException;
import edu.mayo.pipes.JSON.lookup.LookupPipe;
import edu.mayo.pipes.JSON.lookup.lookupUtils.IndexUtils;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class LookupCommand
implements CommandPlugin {
    private static final char OPTION_DRILL_COLUMN = 'c';
    private static final char OPTION_INDEX_FILE = 'i';
    private static final char OPTION_KEY = 'p';
    private static final char OPTION_CATALOG_FILE = 'd';
    private static final char OPTION_CASE_SENSITIVE = 's';
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws InvalidOptionArgValueException, InvalidDataException, IOException, SQLException {
        String catalogFilePath = line.getOptionValue('d');
        CatalogUtils.warnIfDeprecated(catalogFilePath);
        if (!new File(catalogFilePath).exists()) {
            throw new InvalidOptionArgValueException(opts.getOption("d"), catalogFilePath, "The catalog file path '" + catalogFilePath + "' does not exist. Please specify a valid catalog file path.");
        }
        String key = line.getOptionValue('p');
        String indexFilePath = "";
        File indexFile = null;
        if (line.hasOption('i')) {
            indexFilePath = line.getOptionValue('i');
            indexFile = new File(indexFilePath);
        } else {
            try {
                indexFilePath = IndexUtils.getH2DbIndexPath((String)catalogFilePath, (String)key);
                indexFile = new File(indexFilePath);
                if (!indexFile.exists()) {
                    indexFilePath = IndexUtils.getH2DbIndexPath_backwardCompatabilityOnly((String)catalogFilePath, (String)key);
                    indexFile = new File(indexFilePath);
                }
            }
            catch (IOException ioe) {
                throw new InvalidOptionArgValueException(opts.getOption("d"), indexFilePath, "Error locating the index file");
            }
        }
        String defaultIndexNotExistMsg = "The built-in index for " + line.getOptionValue('p') + " does not exist.  Please e-mail the BioR development team at bior@mayo.edu to add this, or create your own custom index using the bior_index command.";
        String specifiedIndexNotExistMsg = "The index file path you specified does not exist: " + indexFilePath;
        String specifiedIndexNotReadableMsg = "The index file path you specified does not have read access:  " + indexFilePath + ".  Please verify file permissions.";
        boolean isIndexSpecified = line.hasOption('i');
        if (indexFile == null || !indexFile.exists()) {
            throw new InvalidOptionArgValueException(opts.getOption("i"), indexFilePath, isIndexSpecified ? specifiedIndexNotExistMsg : defaultIndexNotExistMsg, isIndexSpecified);
        }
        if (!indexFile.canRead()) {
            throw new InvalidOptionArgValueException(opts.getOption("i"), indexFilePath, specifiedIndexNotReadableMsg, isIndexSpecified);
        }
        Integer column = -1;
        if (line.hasOption('c')) {
            column = new Integer(line.getOptionValue('c'));
        }
        boolean isCaseSensitive = line.hasOption('s');
        Metadata metadata = new Metadata(new File(catalogFilePath).getCanonicalPath(), this.operation);
        HistoryInPipe preLogic = new HistoryInPipe(metadata);
        LookupPipe logic = new LookupPipe(catalogFilePath, indexFilePath, column.intValue(), isCaseSensitive);
        HistoryOutPipe postLogic = new HistoryOutPipe();
        this.mPipeline.execute(preLogic, logic, postLogic);
    }
}

