/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.util.StreamConnector;
import edu.mayo.cli.CommandPlugin;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericScriptCommand
implements CommandPlugin {
    private static final Logger sLogger = LoggerFactory.getLogger(GenericScriptCommand.class);
    private static final int BUFFER_SIZE = 1024;

    public void init(Properties props) throws Exception {
    }

    public abstract String getScriptName(CommandLine var1);

    public abstract String[] getScriptArgs(CommandLine var1);

    public abstract Map<String, String> getEnvVars(CommandLine var1);

    public void execute(CommandLine line, Options opts) throws Exception {
        String script = this.getScriptName(line);
        String[] scriptArgs = this.getScriptArgs(line);
        HashMap<String, String> env = new HashMap<String, String>();
        env.putAll(System.getenv());
        env.putAll(this.getEnvVars(line));
        this.execute(script, scriptArgs, env);
    }

    private void execute(String scriptName, String[] scriptArgs, Map<String, String> env) throws IOException, InterruptedException, Exception {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(scriptName);
        for (String arg : scriptArgs) {
            cmdList.add(arg);
        }
        String[] cmdArray = cmdList.toArray(new String[0]);
        ArrayList<String> envList = new ArrayList<String>();
        for (String name : env.keySet()) {
            String value = env.get(name);
            envList.add(name + "=" + value);
        }
        String[] envArray = envList.toArray(new String[0]);
        Process p = Runtime.getRuntime().exec(cmdArray, envArray);
        ByteArrayOutputStream stderrOutputStream = new ByteArrayOutputStream();
        StreamConnector stderrConnector = new StreamConnector(p.getErrorStream(), stderrOutputStream, 1024);
        new Thread(stderrConnector).start();
        StreamConnector stdinConnector = new StreamConnector(System.in, p.getOutputStream(), 1024);
        new Thread(stdinConnector).start();
        StreamConnector stdoutConnector = new StreamConnector(p.getInputStream(), System.out, 1024);
        new Thread(stdoutConnector).start();
        int exitCode = p.waitFor();
        String stderr = stderrOutputStream.toString("UTF-8");
        if (stderr.length() > 0) {
            System.err.println(stderr);
            sLogger.error(stderr);
        }
        if (exitCode != 0) {
            throw new Exception(stderr);
        }
    }
}

