/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.verification;

import htsjdk.tribble.readers.TabixReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeqLookup {
    private static final Logger sLogger = LoggerFactory.getLogger(SeqLookup.class);
    private String refAssemblyCatalogPath;
    private TabixReader tabixReader = null;
    private String chromCached;
    private long minCached;
    private long maxCached;
    private StringBuilder seqCached;

    public SeqLookup(String refAssemblyCatalog) throws IOException {
        this.refAssemblyCatalogPath = refAssemblyCatalog;
        this.tabixReader = new TabixReader(refAssemblyCatalog);
        sLogger.info("SeqLookup: refAssemblyCatalogPath = " + this.refAssemblyCatalogPath);
    }

    public String getRefSeq(String chrom, long min, long max) throws NumberFormatException, IOException {
        this.updateCacheAsNeeded(chrom, min, max);
        this.verifyWithinRange(chrom, min, max);
        return this.getSubSeqFromCache(chrom, min, max);
    }

    private void verifyWithinRange(String chrom, long min, long max) {
        if (!this.isSameChrom(chrom)) {
            throw new IllegalArgumentException("Reference sequence lookup: Chromosome does not match the cached chromosome");
        }
        if (!this.isWithinRange(min, max)) {
            throw new IllegalArgumentException("Reference sequence lookup: Range is not within the cached range");
        }
    }

    private boolean isSameChrom(String chrom) {
        return chrom != null && chrom.equals(this.chromCached);
    }

    private boolean isWithinRange(long min, long max) {
        return min >= this.minCached && max <= this.maxCached;
    }

    private void updateCacheAsNeeded(String chrom, long min, long max) throws NumberFormatException, IOException {
        boolean isWithinCache;
        boolean bl = isWithinCache = chrom.equals(this.chromCached) && min >= this.minCached && max <= this.maxCached;
        if (isWithinCache) {
            return;
        }
        String tabixQuery = chrom + ":" + min + "-" + max;
        TabixReader.Iterator tabixIterator = this.tabixReader.query(tabixQuery);
        String line = null;
        this.chromCached = "";
        this.minCached = -1L;
        this.maxCached = -1L;
        this.seqCached = new StringBuilder();
        while ((line = tabixIterator.next()) != null) {
            String[] cols = line.split("\t");
            this.chromCached = cols[0];
            if (this.minCached == -1L) {
                this.minCached = Long.parseLong(cols[1]);
            }
            this.maxCached = Long.parseLong(cols[2]);
            this.seqCached.append(cols[3]);
        }
        if (this.chromCached.length() == 0 || this.minCached == -1L || this.maxCached == -1L || this.seqCached.length() == 0) {
            throw new IllegalArgumentException("Range [" + tabixQuery + "] could not be retrieved from ref assembly catalog.  This may mean you have the wrong ref catalog assembly for the data you are verifying.");
        }
    }

    private String getSubSeqFromCache(String chrom, long min, long max) {
        int start = (int)(min - this.minCached);
        int end = (int)((long)start + (max - min) + 1L);
        return this.seqCached.substring(start, end);
    }
}

