/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.verification;

import edu.mayo.bior.catalog.verification.LogLevel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang.StringUtils;

public class MessageLogger {
    private Writer writer;
    private long warningCount = 0L;
    private long infoCount = 0L;
    private File logFile = null;
    private ErrorCount errorCounter = new ErrorCount();

    public static MessageLogger loggerFromOutputList(List<Reader> readerList) throws IOException {
        if (readerList.isEmpty()) {
            return null;
        }
        Iterator<Reader> iter = readerList.iterator();
        MessageLogger messageLogger = MessageLogger.loggerFromOutput(iter.next());
        while (iter.hasNext()) {
            MessageLogger.addToLoggerFromOutput(messageLogger, iter.next());
        }
        return messageLogger;
    }

    public static MessageLogger loggerFromOutput(Reader reader) throws IOException {
        MessageLogger messageLogger = new MessageLogger((Writer)new NullWriter());
        MessageLogger.addToLoggerFromOutput(messageLogger, reader);
        return messageLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToLoggerFromOutput(MessageLogger messageLogger, Reader reader) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                Message message = Message.messageFromString(line);
                if (message == null) continue;
                if (message.isError()) {
                    messageLogger.logError(message);
                    continue;
                }
                messageLogger.logMessage(message);
            }
        }
    }

    public MessageLogger(Writer writer) {
        this.writer = writer;
    }

    public MessageLogger(String path) throws IOException {
        this.logFile = new File(path);
        this.writer = new BufferedWriter(new FileWriter(this.logFile));
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void logError(String msg, int code) {
        this.logError(new Message(msg, LogLevel.ERROR, code));
    }

    public void logWarning(String msg) {
        this.logMessage(new Message(msg, LogLevel.WARNING));
    }

    public void logInfo(String msg) {
        this.logMessage(new Message(msg, LogLevel.INFO));
    }

    private void logError(Message error) {
        this.errorCounter.add(error);
        this.writeMessage(error);
    }

    private void logMessage(Message message) {
        if (message.isWarning()) {
            ++this.warningCount;
        } else if (message.isInfo()) {
            ++this.infoCount;
        }
        this.writeMessage(message);
    }

    private void writeMessage(Message message) {
        try {
            this.writer.write(String.format("%s%n", message));
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Problem writing to verify output: " + e.getMessage());
        }
    }

    public long numErrors() {
        return this.errorCounter.numErrors();
    }

    public long numErrorsForCode(int code) {
        return this.errorCounter.numErrorsForCode(code);
    }

    public long numWarnings() {
        return this.warningCount;
    }

    public long numInfos() {
        return this.infoCount;
    }

    public long numMessages() {
        return this.numErrors() + this.numWarnings() + this.numInfos();
    }

    public boolean hasErrors() {
        return this.numErrors() > 0L;
    }

    public boolean hasWarnings() {
        return this.numWarnings() > 0L;
    }

    private static class Message {
        private static final int ERROR_NO_CODE = -99;
        private String msg;
        private LogLevel level;
        private Integer code;

        public static Message messageFromString(String str) {
            String splitOn = ": ";
            String[] fields = str.split(splitOn);
            if (fields.length < 2) {
                return null;
            }
            ArrayList<String> parts2ThruN = new ArrayList<String>();
            for (int i = 1; i < fields.length; ++i) {
                parts2ThruN.add(fields[i]);
            }
            String msg = StringUtils.join(parts2ThruN, (String)splitOn);
            String part1 = fields[0];
            String[] part1Fields = part1.split(" ");
            if (part1Fields.length == 0 || part1Fields.length > 2) {
                return null;
            }
            String levelLabel = part1Fields[0];
            LogLevel level = null;
            if (LogLevel.ERROR.getLabel().equals(levelLabel)) {
                level = LogLevel.ERROR;
            } else if (LogLevel.WARNING.getLabel().equals(levelLabel)) {
                level = LogLevel.WARNING;
            } else if (LogLevel.INFO.getLabel().equals(levelLabel)) {
                level = LogLevel.INFO;
            } else {
                return null;
            }
            Integer code = null;
            if (part1Fields.length == 2) {
                String intString = part1Fields[1];
                try {
                    code = Integer.parseInt(intString);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            } else if (LogLevel.ERROR.equals((Object)level)) {
                code = -99;
            }
            if (LogLevel.ERROR.equals((Object)level) ? code == null : code != null) {
                return null;
            }
            return new Message(msg, level, code);
        }

        public Message(String msg, LogLevel level) {
            this(msg, level, null);
        }

        public Message(String msg, LogLevel level, Integer code) {
            this.level = level;
            this.msg = msg;
            this.code = code;
        }

        public String getMsg() {
            return this.msg;
        }

        public LogLevel getLevel() {
            return this.level;
        }

        public Integer getCode() {
            return this.code;
        }

        public boolean isError() {
            return LogLevel.ERROR == this.level;
        }

        public boolean isWarning() {
            return LogLevel.WARNING == this.level;
        }

        public boolean isInfo() {
            return LogLevel.INFO == this.level;
        }

        public String toString() {
            if (this.isError() && !this.code.equals(-99)) {
                return String.format("%s %d: %s", this.level.getLabel(), this.code, this.msg);
            }
            return String.format("%s: %s", this.level.getLabel(), this.msg);
        }
    }

    private class ErrorCount {
        private Map<Integer, Long> counter = new HashMap<Integer, Long>();

        private ErrorCount() {
        }

        public void add(Message error) {
            int code = error.getCode();
            Long count = this.counter.get(code);
            if (count == null) {
                count = 0L;
            }
            Long l = count;
            Long l2 = count = Long.valueOf(count + 1L);
            this.counter.put(code, count);
        }

        public long numErrors() {
            long totalCount = 0L;
            for (int code : this.counter.keySet()) {
                totalCount += this.numErrorsForCode(code);
            }
            return totalCount;
        }

        public long numErrorsForCode(int code) {
            Long count = this.counter.get(code);
            return count == null ? 0L : count;
        }
    }
}

