/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.latest;

import edu.mayo.bior.catalog.CatalogDataSource;
import edu.mayo.bior.catalog.CatalogFileUtils;
import edu.mayo.bior.catalog.CatalogFiles;
import edu.mayo.bior.catalog.CatalogFormatException;
import edu.mayo.bior.catalog.latest.LatestCatalog;
import edu.mayo.bior.catalog.latest.LatestCatalogNotFoundException;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatestCatalogFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(LatestCatalogFinder.class);
    private Comparator<CatalogDataSource> dataSourceReleaseDateComparator = new Comparator<CatalogDataSource>(){

        @Override
        public int compare(CatalogDataSource dataSrc1, CatalogDataSource dataSrc2) {
            try {
                Date date1 = dataSrc1.getDataSourceReleaseDateAsDateObject();
                Date date2 = dataSrc2.getDataSourceReleaseDateAsDateObject();
                int compareResult = date2.compareTo(date1);
                if (compareResult == 0) {
                    return dataSrc1.getSource().compareTo(dataSrc2.getSource());
                }
                return compareResult;
            }
            catch (CatalogFormatException e) {
                throw new RuntimeException(e);
            }
        }
    };

    LatestCatalog findLatestCatalog(File rootDir, String source, String build) throws CatalogFormatException, LatestCatalogNotFoundException {
        return this.findLatestCatalog(rootDir, source, build, null);
    }

    public LatestCatalog findLatestCatalog(File rootDir, String source, String build, String contains) throws CatalogFormatException, LatestCatalogNotFoundException {
        List<File> allTsvBgzFiles = CatalogFileUtils.findAllTsvBgzFiles(rootDir, false);
        if (allTsvBgzFiles.size() == 0) {
            throw new LatestCatalogNotFoundException(String.format("0 catalogs found under the root directory %s", rootDir.getAbsolutePath()));
        }
        LOGGER.info(String.format("%s catalogs found under the root directory %s", allTsvBgzFiles.size(), rootDir.getAbsolutePath()));
        List<File> filteredTsvBgzFiles = this.filter(allTsvBgzFiles, source, build, contains);
        return this.findLatest(filteredTsvBgzFiles);
    }

    protected List<File> filter(List<File> tsvBgzFiles, String source, String build, String contains) throws CatalogFormatException, LatestCatalogNotFoundException {
        HashSet<String> sourceValues = new HashSet<String>();
        HashSet<String> buildValues = new HashSet<String>();
        int sourceMatchCount = 0;
        int buildMatchCount = 0;
        ArrayList<File> filtered = new ArrayList<File>();
        for (File tsvBgzFile : tsvBgzFiles) {
            boolean containsMatch;
            CatalogFiles catalogFiles = new CatalogFiles(tsvBgzFile);
            if (catalogFiles.getDataSourceFile() == null) {
                LOGGER.warn(String.format("%s does not have a corresponding datasource.properties", tsvBgzFile.getAbsolutePath()));
                continue;
            }
            CatalogDataSource dataSrc = new CatalogDataSource(catalogFiles.getDataSourceFile());
            if (catalogFiles.isDeprecated()) continue;
            sourceValues.add(dataSrc.getSource());
            buildValues.add(dataSrc.getBuild());
            boolean sourceMatch = dataSrc.getSource().equalsIgnoreCase(source);
            boolean buildMatch = dataSrc.getBuild().toUpperCase().startsWith(build.toUpperCase());
            boolean bl = containsMatch = contains == null || tsvBgzFile.getAbsolutePath().contains(contains);
            if (sourceMatch) {
                ++sourceMatchCount;
            }
            if (buildMatch) {
                ++buildMatchCount;
            }
            if (!sourceMatch || !buildMatch || !containsMatch) continue;
            filtered.add(tsvBgzFile);
        }
        if (filtered.size() == 0) {
            ArrayList sortedValues;
            StringWriter sWtr = new StringWriter();
            PrintWriter pWtr = new PrintWriter(sWtr);
            if (sourceMatchCount == 0) {
                pWtr.println(String.format("Found 0 catalogs with source=%s.  Try one of the following available values:", source));
                sortedValues = new ArrayList(sourceValues);
                Collections.sort(sortedValues);
                for (String value : sortedValues) {
                    pWtr.println(value);
                }
            } else if (buildMatchCount == 0) {
                pWtr.println(String.format("Found 0 catalogs with build=%s.  Try one of the following available values:", build));
                sortedValues = new ArrayList(buildValues);
                Collections.sort(sortedValues);
                for (String value : sortedValues) {
                    pWtr.println(value);
                }
            }
            throw new LatestCatalogNotFoundException(sWtr.toString());
        }
        return filtered;
    }

    LatestCatalog findLatest(List<File> tsvBgzFiles) throws CatalogFormatException, LatestCatalogNotFoundException {
        ArrayList<File> missing = new ArrayList<File>();
        HashMap<CatalogDataSource, File> dataSrcToTsvBgz = new HashMap<CatalogDataSource, File>();
        for (File tsvBgzFile : tsvBgzFiles) {
            CatalogFiles catalogFiles = new CatalogFiles(tsvBgzFile);
            CatalogDataSource dataSrc = new CatalogDataSource(catalogFiles.getDataSourceFile());
            if (dataSrc.getDataSourceReleaseDate() == null || dataSrc.getDataSourceReleaseDate().trim().length() == 0) {
                missing.add(catalogFiles.getDataSourceFile());
                continue;
            }
            dataSrcToTsvBgz.put(dataSrc, tsvBgzFile);
        }
        if (missing.size() > 0) {
            Object pWtr;
            StringWriter sWtr;
            if (missing.size() == tsvBgzFiles.size()) {
                sWtr = new StringWriter();
                pWtr = new PrintWriter(sWtr);
                ((PrintWriter)pWtr).println("Unable to find the latest catalog because the following catalog datasource.properties are missing dataSourceReleaseDate:");
                for (File dataSrcProps : missing) {
                    ((PrintWriter)pWtr).println(dataSrcProps.getAbsolutePath());
                }
                throw new CatalogFormatException(sWtr.toString());
            }
            sWtr = new StringWriter();
            pWtr = new PrintWriter(sWtr);
            ((PrintWriter)pWtr).println(String.format("%s catalog datasource.properties are missing dataSourceReleaseDate:", missing.size()));
            for (File dataSrcProps : missing) {
                ((PrintWriter)pWtr).println(dataSrcProps.getAbsolutePath());
            }
            LOGGER.warn(sWtr.toString());
        }
        ArrayList sortedCatalogDataSources = new ArrayList(dataSrcToTsvBgz.keySet());
        for (CatalogDataSource cds : sortedCatalogDataSources) {
            cds.getDataSourceReleaseDateAsDateObject();
        }
        Collections.sort(sortedCatalogDataSources, this.dataSourceReleaseDateComparator);
        CatalogDataSource latestDataSrc = (CatalogDataSource)sortedCatalogDataSources.get(0);
        if (sortedCatalogDataSources.size() > 1) {
            for (int idx = 1; idx < sortedCatalogDataSources.size(); ++idx) {
                CatalogDataSource current = (CatalogDataSource)sortedCatalogDataSources.get(idx);
                if (!latestDataSrc.getDataSourceReleaseDate().equals(current.getDataSourceReleaseDate())) continue;
                StringWriter sWtr = new StringWriter();
                PrintWriter pWtr = new PrintWriter(sWtr);
                pWtr.println(String.format("Unable to find the latest catalog because multiple catalog datasource.properties had dataSourceReleaseDate=%s", latestDataSrc.getDataSourceReleaseDate()));
                pWtr.println(latestDataSrc.getFile().getAbsolutePath());
                pWtr.println(current.getFile().getAbsolutePath());
                throw new LatestCatalogNotFoundException(sWtr.toString());
            }
        }
        LatestCatalog latest = new LatestCatalog();
        latest.setShortUniqueName(latestDataSrc.getShortUniqueName());
        latest.setDescription(latestDataSrc.getDescription());
        latest.setBuild(latestDataSrc.getBuild());
        latest.setSource(latestDataSrc.getSource());
        latest.setVersion(latestDataSrc.getVersion());
        latest.setDataset(latestDataSrc.getDataset());
        latest.setDataSourceReleaseDate(latestDataSrc.getDataSourceReleaseDate());
        latest.setCatalogPath(((File)dataSrcToTsvBgz.get(latestDataSrc)).getAbsolutePath());
        return latest;
    }
}

