/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util;

import edu.mayo.bior.pipeline.SplitFile;
import edu.mayo.bior.util.Category;
import edu.mayo.bior.util.Keyword;
import edu.mayo.pipes.iterators.Compressor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CatalogUtils {
    private static File catalogFile;
    protected static final String kDatasource = ".datasource.properties";
    protected static final int kDSLen;
    protected static final String kColumns = ".columns.tsv";
    protected static final int kColLen;
    protected static final String kData = ".tsv.bgz";
    private static final String kDeprecated = "DEPRECATED";
    private static final String kCatFileEnd = ".tsv.bgz";
    private static final int kCatFileLen;
    private static final int kEnabledCol = 0;
    private static final int kPathCol = 1;
    private static final int kNumCols = 2;
    private static final String[] kGoldenTests;
    private static final Set<String> kTestGolden;
    private static final int kChromCol = 0;
    private static final int kStartCol = 1;
    private static final int kEndCol = 2;
    private static final int kJSONCol = 3;
    private static final int kNumDataCols = 4;
    public static final String kOverlap = "bior_overlap";
    public static final String kSameVariant = "bior_same_variant";
    public static final boolean kOnlyUnique = true;
    public static final boolean kReturnAllNames = false;
    protected static final boolean kHonorBlacklist = false;
    private static final boolean kIgnoreBlacklist = true;
    public static final int kHumanNameCol = 0;
    public static final int kMachineNameCol = 1;
    public static final int kNumNameCols = 2;
    private static final int kUnique = 0;
    private static final int kType = 1;
    private static final int kCount = 2;
    private static final int kDescription = 3;
    private static final int kName = 4;
    private static final int kMaxNumCols = 5;
    private static final String[] kSpaceStrs;
    private static final String[] kBuildSeparators;
    protected static final String[] kBlacklistHeader;

    public static final Properties getCatalogProperties(String catalogPath) {
        if (CatalogUtils.isEmpty(catalogPath)) {
            return null;
        }
        if (!catalogPath.endsWith(".tsv.bgz")) {
            return null;
        }
        String basePath = catalogPath.substring(0, catalogPath.length() - kCatFileLen);
        File dataSourceFile = new File(basePath + kDatasource);
        if (!dataSourceFile.exists()) {
            return null;
        }
        try {
            Properties catProperties = new Properties();
            FileInputStream input = new FileInputStream(dataSourceFile);
            if (!CatalogUtils.loadProperties(input, catProperties)) {
                return null;
            }
            return catProperties;
        }
        catch (FileNotFoundException oops) {
            return null;
        }
    }

    public static final String getCatalogBuild(String catalogPath) {
        Properties catProperties = CatalogUtils.getCatalogProperties(catalogPath);
        if (catProperties == null) {
            return null;
        }
        return CatalogUtils.getBuild(catProperties);
    }

    static final String getBuild(Properties catProperties) {
        return CatalogUtils.getBuild(catProperties.getProperty("Build"));
    }

    static final String getUniqueName(Properties catProperties) {
        return catProperties.getProperty("ShortUniqueName");
    }

    static final String getHumanName(Properties catProperties, Map<String, String> catNames, String uniqueName) {
        String humanName = catProperties.getProperty("HumanName");
        if (humanName == null) {
            humanName = catNames.get(uniqueName);
        }
        return humanName;
    }

    private static String getCategory(Properties catProperties, Map<String, String> categories, String uniqueName) {
        String category = catProperties.getProperty("Category");
        if (category == null) {
            category = categories.get(uniqueName);
        }
        return category;
    }

    static final String getSource(Properties catProperties) {
        return catProperties.getProperty("Source");
    }

    static final String getDescription(Properties catProperties) {
        return catProperties.getProperty("Description");
    }

    static final String getVersion(Properties catProperties) {
        return catProperties.getProperty("Version");
    }

    public static Map<String, List<Category>> getTheCategories(String catalogsFile, String categoriesFile, String namesFile) throws IOException {
        String line;
        HashMap<String, List<Category>> results = new HashMap<String, List<Category>>();
        Map<String, String> catPaths = CatalogUtils.getStringToStringMap(categoriesFile);
        Map<String, String> catNames = CatalogUtils.getStringToStringMap(namesFile);
        BufferedReader dataReader = Compressor.readFile((File)new File(catalogsFile));
        while ((line = dataReader.readLine()) != null) {
            String path;
            String[] cols;
            if (line.startsWith("#") || (cols = SplitFile.mySplit(line, "\t", -1)).length < 2 || cols[0].equalsIgnoreCase(kDeprecated) || !(path = cols[1]).endsWith(".tsv.bgz")) continue;
            path = path.substring(0, path.length() - kCatFileLen);
            File columnsFile = new File(path + kColumns);
            File dataSourceFile = new File(path + kDatasource);
            if (!columnsFile.exists() || !dataSourceFile.exists()) {
                System.err.println("Missing files:");
                System.err.println(line);
                continue;
            }
            CatalogUtils.parseCategories(columnsFile, dataSourceFile, catPaths, catNames, results);
        }
        return results;
    }

    public static String[][] getCatalogKeywords(String catalogPath, boolean onlyUniqueHuman) {
        File columnsFile = CatalogUtils.getColumnsFile(catalogPath);
        if (columnsFile == null) {
            return null;
        }
        return CatalogUtils.getKeywords(columnsFile, onlyUniqueHuman, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, List<Category>> getAllCategories(String parsePath, String categoriesFile, String namesFile) {
        HashMap<String, List<Category>> results = new HashMap<String, List<Category>>();
        Map<String, String> catPaths = null;
        Map<String, String> catNames = null;
        File root = new File(parsePath);
        FilenameFilter filter = CatalogUtils.getCatalogFilter();
        Comparator<File> fileSorter = CatalogUtils.getCatalogComparator();
        BufferedWriter dataWriter = null;
        try {
            catPaths = CatalogUtils.getStringToStringMap(categoriesFile);
            catNames = CatalogUtils.getStringToStringMap(namesFile);
            catalogFile = new File(root, "catalog_file");
            Compressor comp = new Compressor(null, catalogFile, true);
            dataWriter = comp.getWriter();
            dataWriter.newLine();
            CatalogUtils.closeWriter(dataWriter);
        }
        catch (IOException oops) {
            catalogFile = new File("catalog_file");
        }
        finally {
            CatalogUtils.closeWriter(dataWriter);
        }
        CatalogUtils.parseDirectory(root, filter, fileSorter, catPaths, catNames, results);
        return results;
    }

    public static boolean isDeprecated(String catalogPath) {
        if (catalogPath == null || catalogPath.length() == 0) {
            return false;
        }
        File deprecatedFile = new File(catalogPath.replace(".tsv.bgz", ".DEPRECATED.txt"));
        return deprecatedFile.exists();
    }

    public static void warnIfDeprecated(String catalogPath) {
        if (CatalogUtils.isDeprecated(catalogPath)) {
            System.err.println("Warning: The catalog you are using has been deprecated (" + catalogPath + ").  Please switch to a newer version.");
        }
    }

    private static void parseDirectory(File theDir, FilenameFilter filter, Comparator<File> fileSorter, Map<String, String> catPaths, Map<String, String> catNames, Map<String, List<Category>> results) {
        File[] items = theDir.listFiles(filter);
        File columnsFile = null;
        if (items == null) {
            return;
        }
        Arrays.sort(items, fileSorter);
        for (File theItem : items) {
            if (theItem.isDirectory()) {
                CatalogUtils.parseDirectory(theItem, filter, fileSorter, catPaths, catNames, results);
                continue;
            }
            String name = theItem.getName();
            if (name.endsWith(kColumns)) {
                columnsFile = theItem;
                continue;
            }
            if (columnsFile == null) continue;
            File dataSourceFile = theItem;
            String baseName = dataSourceFile.getName();
            baseName = baseName.substring(0, baseName.length() - kDSLen);
            if (!columnsFile.getName().startsWith(baseName)) {
                columnsFile = null;
                continue;
            }
            CatalogUtils.parseCategories(columnsFile, dataSourceFile, catPaths, catNames, results);
        }
    }

    private static boolean parseCategories(File columnsFile, File dataSourceFile, Map<String, String> catPaths, Map<String, String> catNames, Map<String, List<Category>> results) {
        try {
            Properties catProperties = new Properties();
            FileInputStream input = new FileInputStream(dataSourceFile);
            if (!CatalogUtils.loadProperties(input, catProperties)) {
                return false;
            }
            String catSource = CatalogUtils.getSourceAndDesc(catProperties);
            String uniqueName = CatalogUtils.getUniqueName(catProperties);
            String catPath = CatalogUtils.getCategory(catProperties, catPaths, uniqueName);
            String humanName = CatalogUtils.getHumanName(catProperties, catNames, uniqueName);
            String build = CatalogUtils.getBuild(catProperties);
            List<Category> curList = results.get(build);
            if (curList == null) {
                curList = new ArrayList<Category>();
                results.put(build, curList);
            }
            if (humanName == null) {
                return false;
            }
            if (catPath == null) {
                catPath = "Uncategorized";
            }
            Category parent = CatalogUtils.addPath(catPath, curList);
            Category element = new Category(humanName, uniqueName, catSource, parent);
            CatalogUtils.addKeywords(element, columnsFile);
            curList.add(element);
            return true;
        }
        catch (IOException oops) {
            oops.printStackTrace();
            return false;
        }
    }

    private static String getSourceAndDesc(Properties catProperties) {
        String source = CatalogUtils.getSource(catProperties);
        String description = CatalogUtils.getDescription(catProperties);
        if (CatalogUtils.isEmpty(source)) {
            if (CatalogUtils.isEmpty(description)) {
                return "";
            }
            return description;
        }
        if (CatalogUtils.isEmpty(description)) {
            return source;
        }
        return source + " - " + description;
    }

    static String getBuild(String build) {
        int len;
        int pos = len = build.length();
        for (String separator : kBuildSeparators) {
            int test = build.indexOf(separator);
            if (test <= 0 || test >= pos) continue;
            pos = test;
        }
        if (pos < len) {
            return build.substring(0, pos);
        }
        return build;
    }

    private static Category addPath(String catPath, List<Category> curList) {
        Category last;
        block7: {
            int which;
            int numCategories;
            String[] elements;
            block6: {
                if (CatalogUtils.isEmpty(catPath)) {
                    return null;
                }
                elements = SplitFile.mySplit(catPath, ":", -1);
                last = null;
                String root = elements[0];
                numCategories = curList.size();
                for (which = 0; which < numCategories; ++which) {
                    Category test = curList.get(which);
                    String name = test.getName();
                    if (name.equals(root)) {
                        last = test;
                        break;
                    }
                    if (test.getParent() != null || name.compareTo(root) > 0) break;
                }
                if (last != null) break block6;
                last = new Category(root, root, "", null);
                curList.add(which, last);
                if (elements.length <= 1) break block7;
                last = CatalogUtils.addPath(last, elements, 1, curList);
                break block7;
            }
            int numElements = elements.length;
            for (int pathPos = 1; pathPos < numElements; ++pathPos) {
                String name = elements[pathPos];
                while (which < numCategories) {
                    Category test = curList.get(which);
                    String testName = test.getName();
                    if (testName.equals(name)) {
                        last = test;
                        break;
                    }
                    ++which;
                }
                if (which != numCategories) continue;
                last = CatalogUtils.addPath(last, elements, pathPos, curList);
                break;
            }
        }
        return last;
    }

    private static Category addPath(Category parent, String[] elements, int starting, List<Category> curList) {
        int numElements = elements.length;
        Category last = parent;
        for (int i = starting; i < numElements; ++i) {
            String name = elements[i];
            last = new Category(name, name, "", last);
            curList.add(last);
        }
        return last;
    }

    private static void addKeywords(Category element, File columnsFile) throws IOException {
        String line;
        Set<String> blacklist = CatalogUtils.getBlackList(columnsFile);
        Compressor comp = new Compressor(columnsFile, null);
        BufferedReader dataReader = comp.getReader();
        String catUniqueName = element.getUniqueName();
        StringBuilder keyUniqueName = new StringBuilder(catUniqueName);
        keyUniqueName.append(':');
        int baseLen = keyUniqueName.length();
        while ((line = dataReader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] elements = SplitFile.mySplit(line, "\t", -1, true);
            String uniqueName = elements[0];
            int numElements = elements.length;
            String name = numElements >= 5 ? elements[4] : CatalogUtils.cleanName(uniqueName);
            if (blacklist.contains(uniqueName)) continue;
            keyUniqueName.setLength(baseLen);
            keyUniqueName.append(uniqueName);
            if (numElements < 4) {
                System.out.println("Bad line");
                continue;
            }
            String description = elements[3];
            Keyword theKeyword = new Keyword(keyUniqueName.toString(), name, description);
            element.addKeyword(theKeyword);
        }
    }

    private static String[][] getKeywords(File columnsFile, boolean onlyUniqueHuman, boolean ignoreBlacklist) {
        try {
            String line;
            Compressor comp = new Compressor(columnsFile, null);
            BufferedReader dataReader = comp.getReader();
            ArrayList<String> humanNames = new ArrayList<String>();
            ArrayList<String> machineNames = new ArrayList<String>();
            Set<String> blacklist = ignoreBlacklist ? new HashSet<String>() : CatalogUtils.getBlackList(columnsFile);
            while ((line = dataReader.readLine()) != null) {
                String name;
                if (line.startsWith("#")) continue;
                String[] elements = SplitFile.mySplit(line, "\t", -1, true);
                String uniqueName = elements[0];
                String cleanName = CatalogUtils.cleanName(uniqueName);
                int numElements = elements.length;
                if (blacklist.contains(uniqueName)) continue;
                if (numElements >= 5) {
                    name = elements[4];
                    if (CatalogUtils.isEmpty(name)) {
                        name = cleanName;
                    }
                    if (onlyUniqueHuman && name.equals(cleanName)) {
                        continue;
                    }
                } else {
                    if (onlyUniqueHuman) continue;
                    name = cleanName;
                }
                humanNames.add(name);
                machineNames.add(uniqueName);
            }
            int numNames = Math.min(humanNames.size(), machineNames.size());
            String[] hNames = humanNames.toArray(new String[numNames]);
            String[] mNames = machineNames.toArray(new String[numNames]);
            String[][] results = new String[][]{hNames, mNames};
            return results;
        }
        catch (IOException oops) {
            oops.printStackTrace();
            return null;
        }
    }

    protected static void addKeywordsMakeBlacklist(Category element, File columnsFile) throws IOException {
        String line;
        File blacklistFile = new File(columnsFile.getParentFile(), columnsFile.getName() + ".blacklist");
        Compressor comp = new Compressor(columnsFile, blacklistFile);
        BufferedReader dataReader = comp.getReader();
        BufferedWriter blWriter = comp.getWriter();
        String catUniqueName = element.getUniqueName();
        StringBuilder keyUniqueName = new StringBuilder(catUniqueName);
        for (String hLine : kBlacklistHeader) {
            blWriter.write(hLine);
            blWriter.newLine();
        }
        keyUniqueName.append(':');
        int baseLen = keyUniqueName.length();
        while ((line = dataReader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] elements = SplitFile.mySplit(line, "\t", -1, true);
            String uniqueName = elements[0];
            int numElements = elements.length;
            String name = numElements >= 5 ? elements[4] : CatalogUtils.cleanName(uniqueName);
            if (CatalogUtils.isEmpty(name)) {
                blWriter.write(uniqueName);
                blWriter.newLine();
                continue;
            }
            keyUniqueName.setLength(baseLen);
            keyUniqueName.append(uniqueName);
            if (numElements < 4) {
                System.out.println("Bad line");
                continue;
            }
            String description = elements[3];
            Keyword theKeyword = new Keyword(keyUniqueName.toString(), name, description);
            element.addKeyword(theKeyword);
        }
        blWriter.close();
    }

    private static Set<String> getBlackList(File columnsFile) {
        HashSet<String> results = new HashSet<String>();
        File blacklist = new File(columnsFile.getParentFile(), columnsFile.getName() + ".blacklist");
        boolean makeList = false;
        if (!blacklist.exists()) {
            blacklist = columnsFile;
            makeList = true;
        }
        try {
            String line;
            Compressor comp = new Compressor(blacklist, null);
            BufferedReader dataReader = comp.getReader();
            while ((line = dataReader.readLine()) != null) {
                if (makeList) {
                    String[] elements;
                    String uniqueName;
                    if (line.startsWith("#") || !(uniqueName = (elements = SplitFile.mySplit(line, "\t", -1, true))[0]).startsWith("_")) continue;
                    results.add(uniqueName);
                    continue;
                }
                results.add(line);
            }
        }
        catch (IOException oops) {
            oops.printStackTrace();
        }
        return results;
    }

    private static <T> Set<T> populateSet(Set<T> theSet, T[] theData) {
        if (theSet == null) {
            return null;
        }
        if (theData == null) {
            return theSet;
        }
        for (T item : theData) {
            theSet.add(item);
        }
        return theSet;
    }

    private static final String getGoldenStatus(Set<String> golden) {
        String goldenStatus = golden.isEmpty() ? "No Golden attributes" : (!golden.contains("_landmark") || !golden.contains("_minBP") || !golden.contains("_maxBP") ? CatalogUtils.getAsString("Only has: ", golden, ", ") : (golden.contains("_altAlleles") && golden.contains("_refAllele") ? kSameVariant : kOverlap));
        return goldenStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void validateDataFile(File columnsFile, List<String> lGolden, String uniqueName) {
        HashSet<String> golden = new HashSet<String>(lGolden);
        Iterator iter = golden.iterator();
        BufferedWriter dataWriter = null;
        while (iter.hasNext()) {
            if (kTestGolden.contains(iter.next())) continue;
            iter.remove();
        }
        try {
            Compressor comp = new Compressor(null, catalogFile, true);
            String goldenStatus = CatalogUtils.getGoldenStatus(golden);
            String name = columnsFile.getName();
            dataWriter = comp.getWriter();
            name = name.substring(0, name.length() - kColLen) + ".tsv.bgz";
            File dataFile = new File(columnsFile.getParentFile(), name);
            if (!dataFile.exists()) {
                goldenStatus = "Missing catalog file";
            }
            dataWriter.write(uniqueName);
            dataWriter.write("\t");
            dataWriter.write(goldenStatus);
            dataWriter.write("\t");
            dataWriter.write(dataFile.getAbsolutePath());
            dataWriter.newLine();
            CatalogUtils.closeWriter(dataWriter);
        }
        catch (IOException oops) {
            oops.printStackTrace();
        }
        finally {
            CatalogUtils.closeWriter(dataWriter);
        }
    }

    private static final File getColumnsFile(String catalogPath) {
        if (CatalogUtils.isEmpty(catalogPath)) {
            return null;
        }
        if (!catalogPath.endsWith(".tsv.bgz")) {
            return null;
        }
        String basePath = catalogPath.substring(0, catalogPath.length() - kCatFileLen);
        File columnsFile = new File(basePath + kColumns);
        if (!columnsFile.exists()) {
            return null;
        }
        return columnsFile;
    }

    static final String getBioRType(String catalogPath) {
        File columnsFile = CatalogUtils.getColumnsFile(catalogPath);
        if (columnsFile == null) {
            return "Could not find columns file";
        }
        return CatalogUtils.getBioRType(columnsFile);
    }

    private static final String getBioRType(File columnsFile) {
        try {
            String line;
            Compressor comp = new Compressor(columnsFile, null);
            BufferedReader dataReader = comp.getReader();
            HashSet<String> golden = new HashSet<String>();
            while ((line = dataReader.readLine()) != null) {
                String[] elements;
                String uniqueName;
                if (line.startsWith("#") || !(uniqueName = (elements = SplitFile.mySplit(line, "\t", -1))[0]).startsWith("_")) continue;
                golden.add(uniqueName);
            }
            Iterator iter = golden.iterator();
            while (iter.hasNext()) {
                if (kTestGolden.contains(iter.next())) continue;
                iter.remove();
            }
            return CatalogUtils.getGoldenStatus(golden);
        }
        catch (IOException oops) {
            oops.printStackTrace();
            return "IO Exception reading file";
        }
    }

    static <S, T> void dump(String title, Map<S, T> theMap, PrintStream out) {
        CatalogUtils.dump(title, null, theMap, out);
    }

    private static <S, T> void dump(String title, String lineStart, Map<S, T> theMap, PrintStream out) {
        if (out == null) {
            out = System.err;
        }
        if (!CatalogUtils.isEmpty(title)) {
            out.println(title);
        }
        boolean first = true;
        for (Map.Entry<S, T> pair : theMap.entrySet()) {
            S key = pair.getKey();
            T value = pair.getValue();
            if (first) {
                first = false;
            } else if (lineStart != null) {
                System.out.print(lineStart);
            }
            if (key instanceof Collection) {
                System.out.print(CatalogUtils.getAsString(null, (Collection)key, ", "));
            } else {
                System.out.print(key);
            }
            System.out.print("\t");
            if (value instanceof Map) {
                CatalogUtils.dump(null, lineStart == null ? "\t" : lineStart + "\t", (Map)value, out);
                continue;
            }
            if (value instanceof Collection) {
                System.out.println(CatalogUtils.getAsString(null, (Collection)value, ", "));
                continue;
            }
            System.out.println(value);
        }
    }

    private static <T> String getAsString(String title, Collection<T> items, String connector) {
        StringBuilder result = new StringBuilder(100);
        if (connector == null) {
            connector = " ";
        }
        if (title != null) {
            result.append(title);
        }
        boolean first = true;
        for (T item : items) {
            if (first) {
                first = false;
            } else {
                result.append(connector);
            }
            result.append(item);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void validateDataFile(File columnsFile, List<String> golden) {
        Iterator<String> iter = golden.iterator();
        BufferedReader dataReader = null;
        while (iter.hasNext()) {
            if (kTestGolden.contains(iter.next())) continue;
            iter.remove();
        }
        if (golden.isEmpty()) {
            return;
        }
        String name = columnsFile.getName();
        name = name.substring(0, name.length() - kColLen) + ".tsv.bgz";
        File dataFile = new File(columnsFile.getParentFile(), name);
        if (!dataFile.exists()) {
            return;
        }
        System.err.println(dataFile.getAbsolutePath());
        try {
            String line;
            Compressor comp = new Compressor(dataFile, null);
            dataReader = comp.getReader();
            while ((line = dataReader.readLine()) != null) {
                String[] elements = SplitFile.mySplit(line, "\t", -1, true);
                if (elements.length < 4) continue;
                String json = elements[3];
                boolean printedJSON = false;
                iter = golden.iterator();
                while (iter.hasNext()) {
                    String info = iter.next();
                    if (json.indexOf(info) >= 0) continue;
                    if (!printedJSON) {
                        System.err.println(json);
                        printedJSON = true;
                    }
                    System.err.println(info);
                    iter.remove();
                    if (!golden.isEmpty()) continue;
                    CatalogUtils.closeReader(dataReader);
                    return;
                }
            }
            CatalogUtils.closeReader(dataReader);
            return;
        }
        catch (IOException oops) {
            oops.printStackTrace();
            return;
        }
        finally {
            CatalogUtils.closeReader(dataReader);
        }
    }

    private static String cleanName(String name) {
        StringBuilder replacer = new StringBuilder(name);
        for (String replace : kSpaceStrs) {
            int pos;
            while ((pos = replacer.indexOf(replace)) >= 0) {
                replacer.replace(pos, pos + replace.length(), " ");
            }
        }
        return replacer.toString();
    }

    private static FilenameFilter getCatalogFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.endsWith(CatalogUtils.kDatasource) || name.endsWith(CatalogUtils.kColumns)) {
                    return true;
                }
                return new File(dir, name).isDirectory();
            }
        };
    }

    private static Comparator<File> getCatalogComparator() {
        return new Comparator<File>(){

            @Override
            public int compare(File first, File second) {
                boolean firstDir = first.isDirectory();
                boolean secondDir = second.isDirectory();
                if (firstDir) {
                    if (!secondDir) {
                        return 1;
                    }
                } else if (secondDir) {
                    return -1;
                }
                return first.getName().compareTo(second.getName());
            }
        };
    }

    static final Map<String, String> getStringToStringMap(String mapFile) throws IOException {
        String line;
        HashMap<String, String> results = new HashMap<String, String>();
        if (CatalogUtils.isEmpty(mapFile)) {
            return results;
        }
        BufferedReader dataReader = Compressor.readFile((File)new File(mapFile));
        while ((line = dataReader.readLine()) != null) {
            String[] cols = SplitFile.mySplit(line, "\t", -1);
            if (cols.length < 2) continue;
            String name = cols[0];
            String path = cols[1];
            results.put(name, path);
        }
        return results;
    }

    static boolean loadProperties(InputStream input, Properties theProperties) {
        try {
            theProperties.load(input);
            input.close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ioexp) {
                System.out.println(ioexp.getMessage());
            }
            return false;
        }
        return true;
    }

    public static final boolean isEmpty(String tested) {
        return tested == null || tested.isEmpty();
    }

    public static final boolean closeReader(Reader theReader) {
        if (theReader == null) {
            System.err.println("closeReader called w/ null pointer");
            return false;
        }
        try {
            theReader.close();
            return true;
        }
        catch (IOException oops) {
            oops.printStackTrace();
            return false;
        }
    }

    public static final boolean closeWriter(Writer theWriter) {
        if (theWriter == null) {
            System.err.println("closeWriter called w/ null pointer");
            return false;
        }
        try {
            theWriter.close();
            return true;
        }
        catch (IOException oops) {
            oops.printStackTrace();
            return false;
        }
    }

    static {
        kDSLen = kDatasource.length();
        kColLen = kColumns.length();
        kCatFileLen = ".tsv.bgz".length();
        kGoldenTests = new String[]{"_altAlleles", "_refAllele", "_landmark", "_minBP", "_maxBP", "_type", "_id", "_strand"};
        kTestGolden = CatalogUtils.populateSet(new HashSet(), kGoldenTests);
        kSpaceStrs = new String[]{".", "_"};
        kBuildSeparators = new String[]{".", " "};
        kBlacklistHeader = new String[]{"### These fields will NOT be showing in BioRWeb.  All others will.", "### If this file is NOT present, then assume that all fields, except for the golden attributes (those beginning with _) should be shown", "### If this file is present, but contains no columns, then assume that all fields should be shown"};
    }
}

