/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.createCatalogProps;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.pipeline.createCatalogProps.ColumnTypeCounter;
import edu.mayo.bior.util.progress.NumLineProgressHandler;
import edu.mayo.cli.InvalidDataException;
import edu.mayo.pipes.UNIX.CatGZPipe;
import edu.mayo.pipes.UNIX.CatPipe;
import edu.mayo.pipes.history.ColumnMetaData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ColumnMetaFromCatalogCrawling {
    private JsonParser mJsonParser = new JsonParser();
    public static long NUM_LINES_START = 0L;
    long numLines = NUM_LINES_START;

    public static void main(String[] args) {
        try {
            String a = "1.0";
            String[] strs = a.split(";");
            List<ColumnMetaData> colMeta = new ColumnMetaFromCatalogCrawling().getColumnMetadata("src/test/resources/example_dbSNP_catalog.tsv.bgz", null);
            System.out.println("Done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<ColumnMetaData> getColumnMetadata(String catalogFilePath, NumLineProgressHandler progressHandler) throws IOException, InvalidDataException {
        LinkedHashMap<String, ColumnTypeCounter> colMap = new LinkedHashMap<String, ColumnTypeCounter>();
        boolean isGzip = catalogFilePath.endsWith(".bgz") || catalogFilePath.endsWith(".gz");
        Pipeline pipe = new Pipeline(new Pipe[]{isGzip ? new CatGZPipe("gzip") : new CatPipe()});
        pipe.setStarts(Arrays.asList(new File(catalogFilePath).getCanonicalPath()));
        long numLinesToCallbackOn = -1L;
        if (progressHandler != null) {
            progressHandler.startingRead();
            numLinesToCallbackOn = progressHandler.getNumLinesToCallbackOn();
        }
        while (pipe.hasNext()) {
            String row = (String)pipe.next();
            if (row == null || row.length() == 0 || row.startsWith("#")) continue;
            String[] cols = row.split("\t");
            JsonObject jsonObj = this.mJsonParser.parse(cols[cols.length - 1]).getAsJsonObject();
            this.addJsonKeysToMap(jsonObj.getAsJsonObject(), null, colMap);
            ++this.numLines;
            if (numLinesToCallbackOn <= 0L || this.numLines % numLinesToCallbackOn != 0L) continue;
            progressHandler.readNumLines(this.numLines, -1L);
        }
        if (progressHandler != null) {
            progressHandler.readAllLines(this.numLines);
        }
        ArrayList<ColumnMetaData> colMetaList = new ArrayList<ColumnMetaData>();
        for (String key : colMap.keySet()) {
            ColumnTypeCounter colType = (ColumnTypeCounter)colMap.get(key);
            if (colType == null) continue;
            this.setTypeToStringIfNull(colType);
            this.setHumanReadableNameToColumnNameIfMissing(colType);
            colMetaList.add(colType.getColumnMetaData());
        }
        return colMetaList;
    }

    private void setHumanReadableNameToColumnNameIfMissing(ColumnTypeCounter colType) {
        if (colType == null || colType.getColumnMetaData() == null) {
            return;
        }
        String humanReadableName = colType.getColumnMetaData().getHumanReadableName();
        if (humanReadableName == null || humanReadableName.trim().length() == 0) {
            colType.getColumnMetaData().setHumanReadableName(colType.getColumnMetaData().getColumnName());
        }
    }

    private void setTypeToStringIfNull(ColumnTypeCounter colType) {
        if (null == colType.getColumnMetaData().getType()) {
            colType.getColumnMetaData().setType(ColumnMetaData.Type.String);
        }
    }

    private void addJsonKeysToMap(JsonObject jsonObj, String parentJsonPath, Map<String, ColumnTypeCounter> colMap) throws InvalidDataException {
        for (Map.Entry entry : jsonObj.entrySet()) {
            String key = (parentJsonPath == null || parentJsonPath.length() == 0 ? "" : parentJsonPath + ".") + (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value instanceof JsonNull) {
                if (colMap.get(key) != null) continue;
                colMap.put(key, null);
                continue;
            }
            if (value instanceof JsonObject) {
                this.addJsonKeysToMap(value.getAsJsonObject(), key, colMap);
                continue;
            }
            this.addKeyValue(key, value, colMap);
        }
    }

    private void addKeyValue(String key, JsonElement value, Map<String, ColumnTypeCounter> colMap) throws InvalidDataException {
        boolean isIntToFloat;
        ColumnTypeCounter colTypeCount = colMap.get(key);
        if (colTypeCount == null) {
            colTypeCount = new ColumnTypeCounter(key, "");
            colMap.put(key, colTypeCount);
            this.setTypeAndCount(value, colTypeCount);
            return;
        }
        ColumnMetaData.Type currentType = colTypeCount.getColumnMetaData().getType();
        String currentCount = colTypeCount.getColumnMetaData().getCount();
        ColumnMetaData.Type newType = colTypeCount.determineType(value);
        String newCount = colTypeCount.determineCount(value);
        boolean bl = isIntToFloat = ColumnMetaData.Type.Integer.equals((Object)currentType) && ColumnMetaData.Type.Float.equals((Object)newType);
        if (currentType == null || isIntToFloat) {
            this.setTypeAndCount(value, colTypeCount);
        }
        this.throwExceptionIfIncompatibleTypeChange(key, currentType, newType, isIntToFloat);
        this.throwExceptionIfCountChanged(key, currentCount, newCount);
    }

    private void throwExceptionIfIncompatibleTypeChange(String key, ColumnMetaData.Type currentType, ColumnMetaData.Type newType, boolean isIntToFloat) throws InvalidDataException {
        boolean isTypeChange;
        boolean isFloatToInt = ColumnMetaData.Type.Float.equals((Object)currentType) && ColumnMetaData.Type.Integer.equals((Object)newType);
        boolean bl = isTypeChange = currentType != null && newType != null && !currentType.equals((Object)newType);
        if (isTypeChange && !isIntToFloat && !isFloatToInt) {
            throw new InvalidDataException("ERROR: Incompatible type change for key [" + key + "] from [" + currentType + "] to [" + newType + "] on data line " + (this.numLines + 1L));
        }
    }

    private void throwExceptionIfCountChanged(String key, String currentCount, String newCount) throws InvalidDataException {
        if (currentCount != null && !currentCount.equals(newCount)) {
            throw new InvalidDataException("ERROR: Incompatible count change for key [" + key + "] from [" + currentCount + "] to [" + newCount + "] on data line " + (this.numLines + 1L));
        }
    }

    private void setTypeAndCount(JsonElement value, ColumnTypeCounter colTypeCount) {
        ColumnMetaData.Type valType = colTypeCount.determineType(value);
        colTypeCount.getColumnMetaData().setType(valType);
        String count = colTypeCount.determineCount(value);
        colTypeCount.getColumnMetaData().setCount(count);
    }
}

