/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.catalog.verification.CatalogVerifier;
import edu.mayo.bior.catalog.verification.MessageLogger;
import edu.mayo.bior.catalog.verification.VerifierExecutionException;
import edu.mayo.bior.catalog.verification.VerifierInputException;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.cli.InvalidOptionArgValueException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class VerifyCatalogCommand
implements CommandPlugin {
    protected static final String OPTION_CATALOG_FILE = "d";
    protected static final String OPTION_OUTPUT_FILE = "o";
    protected static final String OPTION_SAMPLE_SIZE = "s";
    protected static final String OPTION_PHASE = "phase";
    protected static final String OPTION_START_LINE = "startLine";
    protected static final String OPTION_NUM_LINES = "numLines";
    private String cmd;

    public void init(Properties props) throws Exception {
        this.cmd = props.getProperty("command.name");
    }

    public void execute(CommandLine cmdLine, Options opts) throws Exception {
        String catalogFilePath = cmdLine.getOptionValue(OPTION_CATALOG_FILE);
        this.verifyCatalogExists(opts, catalogFilePath);
        String outputFilePath = this.getAndVerifyOutputPath(cmdLine, opts);
        MessageLogger messageLogger = new MessageLogger(outputFilePath == null ? this.getDefaultLogFilePath(catalogFilePath) : outputFilePath);
        long sampleSize = this.getSampleSize(cmdLine);
        List<CatalogVerifier.Phase> phasesToExecute = this.getPhasesToExecute(cmdLine);
        long startLine = this.getStartLine(cmdLine);
        long numLines = this.getNumLinesToProcess(cmdLine);
        CatalogVerifier catalogValidator = new CatalogVerifier();
        try {
            catalogValidator.verify(catalogFilePath, CatalogVerifier.VAL_TYPE.STRICT, messageLogger, sampleSize, phasesToExecute, startLine, numLines);
        }
        catch (VerifierInputException inputE) {
            this.logAndThrowException(inputE, messageLogger, "Input exception raised while verifying catalog: " + catalogFilePath + " Exception: " + inputE.getMessage(), 5);
        }
        catch (VerifierExecutionException execE) {
            this.logAndThrowException(execE, messageLogger, "Execution exception raised while verifying catalog: " + catalogFilePath + " Exception: " + execE.getMessage(), 6);
        }
        catch (Exception e) {
            this.logAndThrowException(e, messageLogger, "General error while verifying catalog: " + catalogFilePath + " Exception: " + e.getMessage(), 7);
        }
    }

    private String getDefaultLogFilePath(String catalogFilePath) {
        String currentWorkingDir = System.getProperty("user.dir");
        String filename = new File(catalogFilePath).getName().replace(".tsv.bgz", "_verify.txt");
        File verifyOutFile = new File(currentWorkingDir, filename);
        return verifyOutFile.getAbsolutePath();
    }

    private void logAndThrowException(Exception inputE, MessageLogger messageLogger, String errorMsg, int errorCode) throws Exception {
        System.err.println(errorMsg);
        if (messageLogger != null) {
            messageLogger.logError(errorMsg, errorCode);
        }
        inputE.printStackTrace();
        throw inputE;
    }

    private long getSampleSize(CommandLine line) {
        if (line.hasOption(OPTION_SAMPLE_SIZE)) {
            long oneInXLines = Long.parseLong(line.getOptionValue(OPTION_SAMPLE_SIZE));
            if (oneInXLines < 1L) {
                throw new IllegalArgumentException("The sample size must be at least 1");
            }
            if (oneInXLines > 1L) {
                System.err.println("Warning: Only 1 in " + oneInXLines + " will be sampled, so some issues may be missed.");
            }
            return oneInXLines;
        }
        return 1L;
    }

    private List<CatalogVerifier.Phase> getPhasesToExecute(CommandLine line) {
        if (line.hasOption(OPTION_PHASE)) {
            String phaseStrCsv = line.getOptionValue(OPTION_PHASE);
            return this.getPhaseListFromCsv(phaseStrCsv);
        }
        return CatalogVerifier.getAllPhases();
    }

    private List<CatalogVerifier.Phase> getPhaseListFromCsv(String phaseStrCsv) {
        ArrayList<CatalogVerifier.Phase> phaseList = new ArrayList<CatalogVerifier.Phase>();
        for (String phase : phaseStrCsv.split(",")) {
            String phaseTrimmed = phase.trim();
            if (phaseTrimmed.length() <= 0) continue;
            if (this.isValidPhase(phaseTrimmed)) {
                phaseList.add(CatalogVerifier.Phase.valueOf(phaseTrimmed));
                continue;
            }
            throw new IllegalArgumentException("No valid arguments were supplied for the -phase flag: " + phase);
        }
        if (phaseList.size() == 0) {
            throw new IllegalArgumentException("No valid arguments were supplied for the -phase flag: " + phaseStrCsv);
        }
        return phaseList;
    }

    private boolean isValidPhase(String phaseTrimmed) {
        for (CatalogVerifier.Phase p : CatalogVerifier.Phase.values()) {
            if (!p.name().equals(phaseTrimmed)) continue;
            return true;
        }
        return false;
    }

    private String getOptionAsString(CommandLine cmdLine, String optionFlag) {
        if (cmdLine.hasOption(optionFlag)) {
            return cmdLine.getOptionValue(optionFlag);
        }
        return null;
    }

    private long getStartLine(CommandLine cmdLine) {
        return this.getStartLine(this.getOptionAsString(cmdLine, OPTION_START_LINE));
    }

    protected long getStartLine(String startLineStr) {
        if (startLineStr == null) {
            return 1L;
        }
        long startLine = 1L;
        try {
            startLine = Long.parseLong(startLineStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad argument for " + this.cmd + " --" + OPTION_START_LINE + ": " + startLineStr);
        }
        if (startLine <= 0L) {
            throw new IllegalArgumentException(this.cmd + " argument for --" + OPTION_START_LINE + " must be a positive number.  Was: " + startLineStr);
        }
        return startLine;
    }

    private long getNumLinesToProcess(CommandLine cmdLine) {
        return this.getNumLinesToProcess(this.getOptionAsString(cmdLine, OPTION_NUM_LINES));
    }

    protected long getNumLinesToProcess(String numLinesStr) {
        if (numLinesStr == null) {
            return Long.MAX_VALUE;
        }
        long numLines = Long.MAX_VALUE;
        try {
            numLines = Long.parseLong(numLinesStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad argument for verify's NumLines -numLines: " + numLinesStr);
        }
        if (numLines < 0L) {
            throw new IllegalArgumentException(this.cmd + " argument for --" + OPTION_START_LINE + " must be 0 (for all lines), or a positive number.  Was: " + numLines);
        }
        if (numLines == 0L) {
            numLines = Long.MAX_VALUE;
        }
        return numLines;
    }

    private String getAndVerifyOutputPath(CommandLine line, Options opts) throws InvalidOptionArgValueException, IOException {
        File outputFile;
        File parentDir;
        String outputFilePath = null;
        if (line.hasOption(OPTION_OUTPUT_FILE) && (parentDir = (outputFile = new File(outputFilePath = line.getOptionValue(OPTION_OUTPUT_FILE))).getParentFile()) != null) {
            if (!parentDir.exists()) {
                String dirPath = parentDir.getPath();
                String msg = String.format("The directory '%s' for the output file does not exist.", dirPath);
                throw new InvalidOptionArgValueException(opts.getOption(OPTION_OUTPUT_FILE), outputFilePath, msg);
            }
            if (!parentDir.canWrite()) {
                String dirPath = parentDir.getPath();
                String msg = String.format("The directory '%s' for the output file is not writable.", dirPath);
                throw new InvalidOptionArgValueException(opts.getOption(OPTION_OUTPUT_FILE), outputFilePath, msg);
            }
        }
        return outputFilePath;
    }

    private void verifyCatalogExists(Options opts, String catalogFilePath) throws InvalidOptionArgValueException {
        if (!new File(catalogFilePath).exists()) {
            String msg = "The catalog file path '" + catalogFilePath + "' does not exist. Please specify a valid catalog file path.";
            throw new InvalidOptionArgValueException(opts.getOption(OPTION_CATALOG_FILE), catalogFilePath, msg);
        }
    }
}

