/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.bior.util.validation.GoldenValidator;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.cli.InvalidDataException;
import edu.mayo.pipes.JSON.InjectIntoJsonPipe;
import edu.mayo.pipes.JSON.inject.ColumnArrayInjector;
import edu.mayo.pipes.JSON.inject.ColumnInjector;
import edu.mayo.pipes.JSON.inject.Injector;
import edu.mayo.pipes.JSON.inject.LiteralInjector;
import edu.mayo.pipes.JSON.modify.JsonTypeExtended;
import edu.mayo.pipes.SplitPipe;
import edu.mayo.pipes.UNIX.CatPipe;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tab2JSONCommand
implements CommandPlugin {
    private static Logger sLogger = LoggerFactory.getLogger(Tab2JSONCommand.class);
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        String config = "";
        if (line.hasOption('c')) {
            config = line.getOptionValue('c');
        }
        this.parseAndInject(config);
    }

    protected void parseAndInject(String configFile) throws InvalidDataException {
        Injector[] injectors = this.parseConfigFile(configFile);
        Metadata metadata = new Metadata(this.operation);
        HistoryInPipe preLogic = new HistoryInPipe(metadata);
        InjectIntoJsonPipe logic = new InjectIntoJsonPipe(true, injectors);
        HistoryOutPipe postLogic = new HistoryOutPipe();
        this.mPipeline.execute(preLogic, logic, postLogic);
    }

    public Injector[] parseConfigFile(String filename) throws InvalidDataException {
        ArrayList<Object> injectors = new ArrayList<Object>();
        ArrayList<LiteralInjector> addQueue = new ArrayList<LiteralInjector>();
        Pipeline parse = new Pipeline(new Pipe[]{new CatPipe(), new SplitPipe("\t")});
        parse.setStarts(Arrays.asList(filename));
        int count = 0;
        while (parse.hasNext()) {
            ArrayList arrayList = (ArrayList)parse.next();
            if (arrayList.size() < 6) {
                sLogger.warn("WARNING: Tab2JSONCommand.parseConfigFile(): Invalid config file format; less that 6 columns. Ignoring line contents: " + arrayList.toString());
            } else {
                Integer colNum = new Integer((String)arrayList.get(0));
                String jsonKeyName = (String)arrayList.get(1);
                JsonTypeExtended jsonDataType = this.getJsonType((String)arrayList.get(2), arrayList.toString());
                String injectionType = ((String)arrayList.get(3)).toUpperCase();
                String delimiterOrLiteralVal = (String)arrayList.get(4);
                String goldenAttrUsage = (String)arrayList.get(5);
                if (!this.isValidInjectorType(injectionType)) {
                    throw new InvalidDataException("Tab2JSONCommand: JSON injector type specified is not valid: " + injectionType + " for config values: " + arrayList.toString());
                }
                if (!goldenAttrUsage.equals(".")) {
                    if (GoldenValidator.isValidGolden(goldenAttrUsage)) {
                        GoldenValidator.validateDataType(goldenAttrUsage, jsonDataType.toString());
                    } else {
                        throw new InvalidDataException("Tab2JSONCommand: JSON golden attribute specified is not valid: " + goldenAttrUsage + " for config values: " + arrayList.toString());
                    }
                }
                LiteralInjector i = null;
                LiteralInjector j = null;
                if (injectionType.equalsIgnoreCase(kInjectorTypes.LITERAL.name())) {
                    i = new LiteralInjector(jsonKeyName, delimiterOrLiteralVal, jsonDataType);
                    if (!goldenAttrUsage.equalsIgnoreCase(".")) {
                        j = new LiteralInjector(goldenAttrUsage, delimiterOrLiteralVal, jsonDataType);
                        addQueue.add(j);
                    }
                } else if (injectionType.equalsIgnoreCase(kInjectorTypes.COLUMN.name())) {
                    i = new ColumnInjector(colNum.intValue(), jsonKeyName, jsonDataType);
                    if (!goldenAttrUsage.equalsIgnoreCase(".")) {
                        j = new ColumnInjector(colNum.intValue(), goldenAttrUsage, jsonDataType);
                        addQueue.add(j);
                    }
                } else if (injectionType.equalsIgnoreCase(kInjectorTypes.ARRAY.name())) {
                    i = new ColumnArrayInjector(colNum.intValue(), jsonKeyName, jsonDataType, delimiterOrLiteralVal, true, false);
                    if (!goldenAttrUsage.equalsIgnoreCase(".")) {
                        j = new ColumnArrayInjector(colNum.intValue(), goldenAttrUsage, jsonDataType, delimiterOrLiteralVal, true, false);
                        addQueue.add(j);
                    }
                }
                injectors.add(i);
            }
            ++count;
        }
        for (Injector injector : addQueue) {
            injectors.add(injector);
        }
        Injector[] ret = new Injector[injectors.size()];
        ret = injectors.toArray(ret);
        return ret;
    }

    private JsonTypeExtended getJsonType(String jsonTypeStr, String jsonConfigLine) throws InvalidDataException {
        if ("NUMBER".equalsIgnoreCase(jsonTypeStr)) {
            return JsonTypeExtended.FLOAT;
        }
        try {
            return JsonTypeExtended.valueOf((String)jsonTypeStr.toUpperCase());
        }
        catch (Exception e) {
            throw new InvalidDataException("Tab2JSONCommand: JSON data type specified is not valid: " + jsonTypeStr + " for config values: " + jsonConfigLine);
        }
    }

    private boolean isValidInjectorType(String inputInjector) {
        for (kInjectorTypes each : kInjectorTypes.values()) {
            if (!each.name().equals(inputInjector)) continue;
            return true;
        }
        return false;
    }

    private static enum kInjectorTypes {
        COLUMN,
        LITERAL,
        ARRAY;

    }
}

