/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.bior.util.CatalogUtils;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.bioinformatics.sequence.RefAllelePipe;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.File;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class RefAlleleCommand
implements CommandPlugin {
    private static final char OPTION_CATALOG_FILE = 'd';
    private static final char OPTION_COLUMN = 'c';
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        String catalogFile = "";
        if (line.hasOption('d')) {
            catalogFile = line.getOptionValue('d');
            CatalogUtils.warnIfDeprecated(catalogFile);
        }
        int jsonColumn = -1;
        if (line.hasOption('c')) {
            jsonColumn = Integer.parseInt(line.getOptionValue('c'));
        }
        Metadata metadata = new Metadata(new File(catalogFile).getCanonicalPath(), this.operation);
        HistoryInPipe preLogic = new HistoryInPipe(metadata);
        RefAllelePipe logic = new RefAllelePipe(catalogFile, jsonColumn);
        HistoryOutPipe postLogic = new HistoryOutPipe();
        this.mPipeline.execute(preLogic, logic, postLogic);
    }
}

