/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.util.FilenameComparatorByNumericPart;
import edu.mayo.cli.CommandPlugin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeCommand
implements CommandPlugin {
    private static Logger sLogger = LoggerFactory.getLogger(MergeCommand.class);
    private static final char OPTION_NO_ZIP = 'n';
    private static final char OPTION_OUTPUT_FILE = 'o';
    private static final char OPTION_KEEP_DUPLICATES = 'k';
    private static final char OPTION_SORT_INPUT_FILES = 's';

    public void init(Properties arg0) throws Exception {
    }

    public void execute(CommandLine cmdLine, Options options) throws Exception {
        String outfile = cmdLine.getOptionValue('o');
        boolean isZipOutput = !cmdLine.hasOption('n');
        boolean isKeepDuplicates = cmdLine.hasOption('k');
        boolean isSortInputFileList = cmdLine.hasOption('s');
        sLogger.info("Output file: " + outfile);
        sLogger.info("Should output be zipped?: " + isZipOutput);
        sLogger.info("Sort the input files?: " + isSortInputFileList);
        List inputVcfs = cmdLine.getArgList();
        this.logList("Input files (unsorted): ", inputVcfs);
        if (isSortInputFileList) {
            Collections.sort(inputVcfs, new FilenameComparatorByNumericPart());
            this.logList("Sorted input file list: ", inputVcfs);
        }
        MergeCommand.verifyInputFiles(inputVcfs);
        sLogger.info("Input files have been resolved");
        this.mergeVcfs(inputVcfs, outfile, isZipOutput, isKeepDuplicates);
        sLogger.info("Done.");
    }

    private void logList(String msg, List<String> inputVcfs) {
        sLogger.info(msg);
        for (String input : inputVcfs) {
            sLogger.info("  " + input);
        }
    }

    private static void verifyInputFiles(List<String> inputVcfs) {
        if (inputVcfs == null || inputVcfs.size() == 0) {
            throw new IllegalArgumentException("No input vcf files were specified");
        }
        for (String inputVcf : inputVcfs) {
            if (new File(inputVcf).exists()) continue;
            throw new IllegalArgumentException("Input vcf file does not exist: " + inputVcf);
        }
    }

    public void mergeVcfs(List<String> inputVcfPaths, String outputPath, boolean isZipOutput, boolean isKeepDuplicates) throws Exception {
        BufferedWriter fout = null;
        List<InputVcf> inVcfs = null;
        try {
            fout = isZipOutput ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(outputPath)))) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outputPath)));
            List<String> headers = this.getAllHeadersInOrder(inputVcfPaths);
            this.writeHeaders(headers, fout);
            sLogger.info("\nScanning all files to find chromosome ranges...");
            List<ChromRange> allChromRanges = this.getAllChromRangesAllFilesSorted(inputVcfPaths);
            sLogger.info("\nNow merging chromosome ranges into the output file...");
            List<String> chromosomes = this.getChroms(allChromRanges);
            for (String chrom : chromosomes) {
                List<ChromRange> chromRanges = this.getRangesForChrom(chrom, allChromRanges);
                sLogger.info("Processing chromosome: " + chrom);
                sLogger.info("   Ranges for chrom: " + chromRanges);
                inVcfs = this.getInputVcfs(chromRanges);
                this.openVcfs(inVcfs);
                String lastLine = "";
                while (this.isAVcfOpenYet(inVcfs)) {
                    Collections.sort(inVcfs);
                    String nextLine = inVcfs.get(0).popLine();
                    if (isKeepDuplicates || !nextLine.equals(lastLine)) {
                        fout.write(nextLine);
                        fout.newLine();
                    }
                    lastLine = nextLine;
                    this.removeSpentVcfs(inVcfs);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error merging vcfs: " + e.getMessage());
            throw e;
        }
        finally {
            if (fout != null) {
                fout.close();
            }
            this.closeAllVcfs(inVcfs);
        }
    }

    private void openVcfs(List<InputVcf> inVcfs) throws FileNotFoundException, IOException {
        for (InputVcf vcf : inVcfs) {
            vcf.open();
        }
    }

    private void removeSpentVcfs(List<InputVcf> inVcfs) {
        for (int i = inVcfs.size() - 1; i >= 0; --i) {
            if (inVcfs.get(i).isOpen()) continue;
            inVcfs.remove(i);
        }
    }

    private List<InputVcf> getInputVcfs(List<ChromRange> chromRanges) {
        ArrayList<InputVcf> inputVcfList = new ArrayList<InputVcf>();
        for (ChromRange chromRange : chromRanges) {
            InputVcf inVcf = new InputVcf(chromRange.filePath, chromRange.filePositionFirst, chromRange.numLines);
            inputVcfList.add(inVcf);
        }
        return inputVcfList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getAllHeadersInOrder(List<String> inputVcfPaths) throws IOException {
        String fileFormatLine = null;
        String colHeaderLine = null;
        ArrayList<String> headerLines = new ArrayList<String>();
        try (BufferedReader fin = null;){
            for (String vcfPath : inputVcfPaths) {
                fin = this.isZippedInput(vcfPath) ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(vcfPath)))) : new BufferedReader(new InputStreamReader(new FileInputStream(vcfPath)));
                String line = null;
                while ((line = fin.readLine()) != null && line.startsWith("#")) {
                    if (line.toLowerCase().startsWith("##fileformat")) {
                        fileFormatLine = line;
                        continue;
                    }
                    if (line.startsWith("##")) {
                        if (headerLines.contains(line)) continue;
                        headerLines.add(line);
                        continue;
                    }
                    colHeaderLine = line;
                }
                fin.close();
            }
            Collections.sort(headerLines, String.CASE_INSENSITIVE_ORDER);
            if (fileFormatLine != null && fileFormatLine.length() > 0) {
                headerLines.add(0, fileFormatLine);
            }
            if (colHeaderLine != null && colHeaderLine.length() > 0) {
                headerLines.add(colHeaderLine);
            }
        }
        return headerLines;
    }

    private void writeHeaders(List<String> headers, BufferedWriter fout) throws IOException {
        for (String header : headers) {
            fout.write(header);
            fout.newLine();
        }
    }

    private List<String> getChroms(List<ChromRange> allChromRanges) {
        ArrayList<String> chroms = new ArrayList<String>();
        for (ChromRange range : allChromRanges) {
            if (chroms.contains(range.chrom.toLowerCase())) continue;
            chroms.add(range.chrom.toLowerCase());
        }
        return chroms;
    }

    private List<ChromRange> getRangesForChrom(String chrom, List<ChromRange> allChromRanges) {
        ArrayList<ChromRange> matchingRanges = new ArrayList<ChromRange>();
        for (ChromRange range : allChromRanges) {
            if (!chrom.equalsIgnoreCase(range.chrom)) continue;
            matchingRanges.add(range);
        }
        return matchingRanges;
    }

    private void closeAllVcfs(List<InputVcf> inputVcfs) throws IOException {
        if (inputVcfs == null) {
            return;
        }
        for (InputVcf vcf : inputVcfs) {
            vcf.close();
        }
    }

    private boolean isAVcfOpenYet(List<InputVcf> inputVcfs) {
        for (InputVcf vcf : inputVcfs) {
            if (!vcf.isOpen()) continue;
            return true;
        }
        return false;
    }

    private boolean isZippedInput(String filePath) {
        boolean isZip = false;
        try {
            FileInputStream fin = new FileInputStream(filePath);
            PushbackInputStream pb = new PushbackInputStream(fin, 2);
            byte[] signature = new byte[2];
            pb.read(signature);
            pb.unread(signature);
            isZip = signature[0] == 31 && signature[1] == -117;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return isZip;
    }

    List<ChromRange> getAllChromRangesAllFilesSorted(List<String> inputVcfs) throws IOException {
        ArrayList<ChromRange> chromRangeList = new ArrayList<ChromRange>();
        for (String vcfPath : inputVcfs) {
            chromRangeList.addAll(this.getAllChromRangesFromFile(vcfPath));
        }
        Collections.sort(chromRangeList);
        return chromRangeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ChromRange> getAllChromRangesFromFile(String vcfPath) throws IOException {
        ArrayList<ChromRange> chromRangesInFile = new ArrayList<ChromRange>();
        try (InputStream fin = null;){
            sLogger.info("Finding chromosome ranges within file: " + vcfPath);
            fin = this.isZippedInput(vcfPath) ? new GZIPInputStream(new FileInputStream(vcfPath)) : new FileInputStream(vcfPath);
            long fileposLineStart = 0L;
            byte[] fileBuffer = new byte[0x100000];
            int bufferLen = -1;
            byte[] lineBuffer = new byte[0x100000];
            int lineLen = 0;
            ArrayList<NextLine> lines = new ArrayList<NextLine>();
            long filePos = 0L;
            while ((bufferLen = fin.read(fileBuffer)) != -1) {
                for (int i = 0; i < bufferLen; ++i) {
                    if (fileBuffer[i] == 13 || fileBuffer[i] == 10) {
                        String line = new String(lineBuffer, 0, lineLen);
                        if (line != null && line.length() > 0 && !line.startsWith("#")) {
                            lines.add(new NextLine(line, fileposLineStart));
                        }
                        lineLen = 0;
                        fileposLineStart = filePos + 1L;
                    } else {
                        lineBuffer[lineLen++] = fileBuffer[i];
                    }
                    ++filePos;
                }
            }
            if (lineLen > 0) {
                String line = new String(lineBuffer, 0, lineLen);
                lines.add(new NextLine(line, fileposLineStart));
            }
            ChromRange chromRange = null;
            for (NextLine line : lines) {
                if (chromRange == null || !chromRange.chrom.equalsIgnoreCase(line.chrom) || chromRange.startLast > line.start) {
                    sLogger.info("  Range-last: " + chromRange);
                    chromRange = new ChromRange(line.chrom, line.start, line.start, vcfPath, line.filePos, 0L);
                    sLogger.info("  Range-new:  " + chromRange);
                    chromRangesInFile.add(chromRange);
                } else {
                    chromRange.startLast = line.start;
                }
                ++chromRange.numLines;
            }
        }
        return chromRangesInFile;
    }

    private int compareChrom(String chrom1, String chrom2) {
        chrom1 = chrom1.toLowerCase().replace("chr", "");
        chrom2 = chrom2.toLowerCase().replace("chr", "");
        if (this.isInt(chrom1) && this.isInt(chrom2)) {
            return Integer.valueOf(chrom1).compareTo(Integer.valueOf(chrom2));
        }
        return chrom1.compareToIgnoreCase(chrom2);
    }

    private boolean isInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    class NextLine {
        public long filePos;
        public String chrom;
        public long start;

        public NextLine(String line, long filePos) {
            this.filePos = filePos;
            String[] parts = line.split("\t");
            this.chrom = parts[0].toUpperCase().replace("CHR", "").trim();
            this.start = Long.parseLong(parts[1].trim());
        }

        public String toString() {
            return "[" + this.chrom + ":" + this.start + " (file:" + this.filePos + ")]";
        }
    }

    class ChromRange
    implements Comparable<ChromRange> {
        public String chrom;
        public long startFirst;
        public long startLast;
        public String filePath;
        public long filePositionFirst;
        public long numLines;

        public ChromRange(String chrom, long startFirst, long startLast, String filePath, long fileposLineFirst, long numLines) {
            this.chrom = chrom;
            this.startFirst = startFirst;
            this.startLast = startLast;
            this.filePath = filePath;
            this.filePositionFirst = fileposLineFirst;
            this.numLines = numLines;
        }

        public String toString() {
            return "[" + this.chrom + ":" + this.startFirst + "-" + this.startLast + ", " + this.filePath + ":" + this.filePositionFirst + " (" + this.numLines + " lines)]";
        }

        @Override
        public int compareTo(ChromRange other) {
            int chromCompare = MergeCommand.this.compareChrom(this.chrom, other.chrom);
            if (chromCompare != 0) {
                return chromCompare;
            }
            return Long.valueOf(this.startFirst).compareTo(other.startFirst);
        }
    }

    class InputVcf
    implements Comparable<InputVcf> {
        private String filePath;
        private BufferedReader fin;
        private String currentLine;
        private long maxLinesToRead = 0L;
        private long startingFilePos = 0L;
        private long numLinesRead = 0L;

        public InputVcf(String filePath) {
            this.filePath = filePath;
        }

        public InputVcf(String filePath, long startingFilePos, long maxLinesToRead) {
            this.filePath = filePath;
            this.maxLinesToRead = maxLinesToRead;
            this.startingFilePos = startingFilePos;
        }

        @Override
        public int compareTo(InputVcf otherVcf) {
            if (this.currentLine == null && otherVcf.currentLine == null) {
                return 0;
            }
            if (this.currentLine == null) {
                return 1;
            }
            if (otherVcf.currentLine == null) {
                return -1;
            }
            String[] partsThis = this.currentLine.split("\t");
            String[] partsOther = otherVcf.currentLine.split("\t");
            if (partsThis.length < 2 || partsOther.length < 2 || !NumberUtils.isNumber((String)partsThis[1]) || !NumberUtils.isNumber((String)partsOther[1])) {
                return this.currentLine.compareToIgnoreCase(otherVcf.currentLine);
            }
            int chromCompare = MergeCommand.this.compareChrom(partsThis[0], partsOther[0]);
            if (chromCompare != 0) {
                return chromCompare;
            }
            return Integer.valueOf(NumberUtils.toInt((String)partsThis[1])).compareTo(NumberUtils.toInt((String)partsOther[1]));
        }

        public void open() throws FileNotFoundException, IOException {
            this.fin = MergeCommand.this.isZippedInput(this.filePath) ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.filePath)))) : new BufferedReader(new InputStreamReader(new FileInputStream(this.filePath)));
            this.fin.skip(this.startingFilePos);
            this.currentLine = this.fin.readLine();
            ++this.numLinesRead;
        }

        public void close() throws IOException {
            if (this.fin != null) {
                this.fin.close();
            }
        }

        public String popLine() throws IOException {
            String line = this.currentLine;
            if (this.maxLinesToRead != 0L && this.numLinesRead >= this.maxLinesToRead || this.currentLine == null) {
                this.close();
                this.currentLine = null;
            } else if (this.fin != null && this.currentLine != null) {
                this.currentLine = this.fin.readLine();
                ++this.numLinesRead;
            }
            return line;
        }

        public boolean isOpen() {
            return this.currentLine != null;
        }
    }
}

