/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import com.tinkerpop.pipes.IdentityPipe;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.bioinformatics.genbank.Genbank2JSONPipe;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class GBKs2JSONCommand
implements CommandPlugin {
    private static final char OPTION_FEATURE = 'f';
    private static final char OPTION_FILE_TYPE = 't';
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        ArrayList<String> featureTypes = new ArrayList<String>();
        if (line.hasOption('f')) {
            for (String value : line.getOptionValues('f')) {
                featureTypes.add(value);
            }
        }
        String[] featureArr = featureTypes.toArray(new String[0]);
        String type = "DNA";
        if (line.hasOption('t')) {
            type = new String(line.getOptionValue('t'));
        }
        IdentityPipe preLogic = new IdentityPipe();
        Genbank2JSONPipe logic = featureTypes.size() > 0 ? new Genbank2JSONPipe(type, featureArr) : new Genbank2JSONPipe(type);
        IdentityPipe postLogic = new IdentityPipe();
        this.mPipeline.execute(preLogic, logic, postLogic);
    }
}

