/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import edu.mayo.bior.catalog.latest.LatestCatalog;
import edu.mayo.bior.catalog.latest.LatestCatalogFinder;
import edu.mayo.bior.cli.cmd.CommandUtil;
import edu.mayo.cli.CommandPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogLatestCommand
implements CommandPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatalogLatestCommand.class);
    private static final String TAB = "\t";
    private static final String OPTION_ROOT_DIR = "r";
    private static final String OPTION_BUILD = "B";
    private static final String OPTION_SOURCE = "s";
    private static final String OPTION_CONTAINS = "c";
    private static final String OPTION_PATH = "p";
    private static LatestCatalogFinder mockFinder;

    public void init(Properties properties) throws Exception {
    }

    public void execute(CommandLine cl, Options options) throws Exception {
        File rootDir = CommandUtil.handleDirectory(cl, OPTION_ROOT_DIR, Arrays.asList(CommandUtil.DirectoryAttributes.EXISTS, CommandUtil.DirectoryAttributes.READABLE, CommandUtil.DirectoryAttributes.EXECUTEABLE));
        LOGGER.info(String.format("Root dir: %s", rootDir.getAbsolutePath()));
        String build = cl.getOptionValue(OPTION_BUILD);
        LOGGER.info(String.format("Build: %s", build));
        String source = cl.getOptionValue(OPTION_SOURCE);
        LOGGER.info(String.format("Source: %s", source));
        String contains = null;
        if (cl.hasOption(OPTION_CONTAINS)) {
            contains = cl.getOptionValue(OPTION_CONTAINS);
            LOGGER.info(String.format("Contains: %s", contains));
        }
        ArrayList<JsonPath> jsonPaths = new ArrayList<JsonPath>();
        if (cl.hasOption(OPTION_PATH)) {
            for (String path : cl.getOptionValues(OPTION_PATH)) {
                LOGGER.info(String.format("JSON Path: %s", path));
                jsonPaths.add(JsonPath.compile((String)path, (Predicate[])new Predicate[0]));
            }
        }
        LatestCatalogFinder finder = mockFinder != null ? mockFinder : new LatestCatalogFinder();
        LatestCatalog latestCatalog = finder.findLatestCatalog(rootDir, source, build, contains);
        if (jsonPaths.size() == 0) {
            this.printJsonToConsole(latestCatalog);
        } else {
            this.printExtractedFieldsToConsole(latestCatalog, jsonPaths);
        }
    }

    private void printJsonToConsole(LatestCatalog latestCatalog) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        gson.toJson((Object)latestCatalog, (Appendable)System.out);
    }

    private void printExtractedFieldsToConsole(LatestCatalog latestCatalog, List<JsonPath> jsonPaths) {
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson((Object)latestCatalog);
        StringBuilder output = new StringBuilder();
        for (JsonPath jsonPath : jsonPaths) {
            String value = jsonPath.read(json).toString();
            output.append(value);
            output.append(TAB);
        }
        output.deleteCharAt(output.length() - 1);
        System.out.println(output);
    }

    static void setLatestCatalogFinder(LatestCatalogFinder latestCatalogFinder) {
        mockFinder = latestCatalogFinder;
    }
}

