/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.buildcatalog.BuildCatalog;
import edu.mayo.bior.buildcatalog.BuildStepKey;
import edu.mayo.cli.CommandPlugin;
import java.io.File;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildCatalogCommand
implements CommandPlugin {
    private static final Logger sLogger = LoggerFactory.getLogger(BuildCatalogCommand.class);
    private static final char OPTION_BUILD_INFO_FILE = 'b';
    private static final char OPTION_START_STEP = 's';
    private static final char OPTION_END_STEP = 'e';

    public void init(Properties props) {
    }

    public void execute(CommandLine cl, Options options) throws Exception {
        File buildInfoFile = new File(cl.getOptionValue('b'));
        if (!buildInfoFile.canRead()) {
            throw new IllegalArgumentException("Error: Specified build information file does not exist: " + buildInfoFile.getPath());
        }
        BuildStepKey stepStart = this.getStep(cl.getOptionValue('s'), BuildStepKey.MAKE_JSON);
        BuildStepKey stepEnd = this.getStep(cl.getOptionValue('e'), BuildStepKey.VERIFY);
        BuildCatalog biorBuildCatalog = new BuildCatalog();
        biorBuildCatalog.build(buildInfoFile.getCanonicalPath(), stepStart, stepEnd);
    }

    private BuildStepKey getStep(String stepStr, BuildStepKey defaultStep) {
        if (stepStr == null) {
            return defaultStep;
        }
        for (BuildStepKey stepKey : BuildStepKey.values()) {
            if (!stepKey.getDisplayName().equalsIgnoreCase(stepStr)) continue;
            return stepKey;
        }
        StringBuilder msg = new StringBuilder("Step not recognized: " + stepStr + ".\nValid steps are:\n");
        for (BuildStepKey key : BuildStepKey.values()) {
            msg.append("    " + key.getDisplayName() + "\n");
        }
        throw new IllegalArgumentException(msg.toString());
    }
}

