/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.verification;

import edu.mayo.bior.catalog.CatalogDataSource;
import edu.mayo.bior.catalog.CatalogFileUtils;
import edu.mayo.bior.catalog.CatalogFiles;
import edu.mayo.bior.catalog.CatalogFormatException;
import edu.mayo.bior.catalog.DataSourceKey;
import edu.mayo.bior.catalog.HumanBuildAssembly;
import edu.mayo.bior.catalog.verification.CatalogOrderVerifier;
import edu.mayo.bior.catalog.verification.CatalogOrderVerifierThread;
import edu.mayo.bior.catalog.verification.CatalogRowVerifier;
import edu.mayo.bior.catalog.verification.HumanReferenceInfo;
import edu.mayo.bior.catalog.verification.MessageLogger;
import edu.mayo.bior.catalog.verification.VerifierExecutionException;
import edu.mayo.bior.catalog.verification.VerifierInputException;
import edu.mayo.bior.catalog.verification.VerifyUtils;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.ColumnMetaDataOperations;
import edu.mayo.pipes.history.ColumnMetaDataVerificationMessages;
import edu.mayo.pipes.util.PropertiesFileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class CatalogVerifier {
    private CatalogFiles mCatalogFiles = null;
    ColumnMetaDataOperations mColumnMetaOps = null;
    private CatalogDataSource mCatalogDataSource = null;
    private HashMap<String, ColumnMetaData> mCatalogColumnsMap = null;
    private TreeMap<String, String> mBIORIndexMapColNameToFilePathMap = null;
    private HumanReferenceInfo mReferenceInfo = null;
    private VAL_TYPE mValType = VAL_TYPE.STRICT;
    private MessageLogger mLogger = null;

    public int verify(String catalogFilePath, VAL_TYPE valLevel, MessageLogger logger) throws VerifierInputException, VerifierExecutionException {
        return this.verify(catalogFilePath, valLevel, logger, 1L);
    }

    public int verify(String catalogFilePath, VAL_TYPE valLevel, MessageLogger logger, long oneInXLinesToVerify) throws VerifierInputException, VerifierExecutionException {
        return this.verify(catalogFilePath, valLevel, logger, oneInXLinesToVerify, CatalogVerifier.getAllPhases(), 1L, Long.MAX_VALUE);
    }

    public static List<Phase> getAllPhases() {
        return Arrays.asList(Phase.values());
    }

    public int verify(String catalogFilePath, VAL_TYPE valLevel, MessageLogger logger, long oneInXLinesToVerify, List<Phase> phasesToExecute, long startLine, long numLines) throws VerifierInputException, VerifierExecutionException {
        this.configureFiles(catalogFilePath, valLevel, logger);
        if (phasesToExecute.contains((Object)Phase.METADATA)) {
            this.verifyMetadataFiles();
        }
        CatalogOrderVerifier chromOrderVerifier = null;
        if (phasesToExecute.contains((Object)Phase.ORDER)) {
            chromOrderVerifier = this.verifyChromAndPosOrderAndTabixAndH2Indexes(oneInXLinesToVerify);
        }
        if (phasesToExecute.contains((Object)Phase.JSON)) {
            this.verifyJsonFieldsAndRefAlleles(oneInXLinesToVerify, startLine, numLines);
        }
        this.logAndOutputMessages();
        return this.areAnyErrors(chromOrderVerifier, this.getLogger());
    }

    private void configureFiles(String catalogFilePath, VAL_TYPE valLevel, MessageLogger logger) throws VerifierInputException, VerifierExecutionException {
        this.mValType = valLevel;
        this.mCatalogFiles = this.getCatalogFiles(new File(catalogFilePath));
        this.mLogger = this.getMessageLogger(logger);
        String statusMsg = String.format("Verifying catalog '%s' starting at %s", catalogFilePath, VerifyUtils.composeDateTime());
        System.out.println(statusMsg);
        this.logInfo(statusMsg);
        if (this.mCatalogFiles.getColumnsFile() != null) {
            try {
                this.mColumnMetaOps = new ColumnMetaDataOperations(this.mCatalogFiles.getColumnsFile());
                this.mCatalogColumnsMap = this.mColumnMetaOps.load();
            }
            catch (IOException e) {
                this.logError("Problem reading columns.tsv. Details: " + e.getMessage(), 100);
            }
        }
        HumanBuildAssembly humanRefAssembly = null;
        if (this.mCatalogFiles.getDataSourceFile() != null) {
            try {
                this.mCatalogDataSource = new CatalogDataSource(this.mCatalogFiles.getDataSourceFile());
                humanRefAssembly = this.mCatalogDataSource.getHumanBuildAssembly();
            }
            catch (CatalogFormatException e) {
                this.logError("datasource.properties has issue: " + e.getMessage(), 112);
            }
        }
        this.mReferenceInfo = new HumanReferenceInfo(humanRefAssembly, this.getLogger());
        this.mBIORIndexMapColNameToFilePathMap = this.verifyBIORIndexFilenames(this.mCatalogFiles.getCatalogFile());
    }

    private HumanBuildAssembly getHumanBuildAssemblyFromDatasourceProperties(File dataSourceFile) throws IOException {
        HumanBuildAssembly assembly = null;
        try {
            if (dataSourceFile != null) {
                String assemblyStr = new PropertiesFileUtil(dataSourceFile.getAbsolutePath()).get(DataSourceKey.Build.name());
                assembly = HumanBuildAssembly.assemblyFromString(assemblyStr);
            }
        }
        catch (Exception e) {
            assembly = null;
        }
        return assembly;
    }

    protected void verifyMetadataFiles() throws VerifierInputException {
        this.verifyCatalogCommonCharacteristics();
    }

    protected CatalogOrderVerifier verifyChromAndPosOrderAndTabixAndH2Indexes(long oneInXLinesToVerify) throws VerifierInputException {
        return this.verifyChromosomeOrder(oneInXLinesToVerify);
    }

    protected void verifyJsonFieldsAndRefAlleles(long oneInXLinesToVerify, long startLine, long numLines) throws VerifierInputException {
        CatalogRowVerifier rowVerifier = new CatalogRowVerifier(this.mCatalogFiles.getCatalogFile(), this.mCatalogDataSource, this.mCatalogColumnsMap, this.getLogger(), oneInXLinesToVerify, startLine, numLines);
        rowVerifier.verify();
        rowVerifier.reportColumnUsage();
    }

    private int areAnyErrors(CatalogOrderVerifier chromOrderVerifier, MessageLogger messageLogger) {
        boolean areOrderCheckingErrors = chromOrderVerifier == null ? false : chromOrderVerifier.areErrorsLogged();
        boolean areOtherErrors = messageLogger.hasErrors();
        return areOrderCheckingErrors || areOtherErrors ? 1 : 0;
    }

    private void logAndOutputMessages() {
        String msg = String.format("Verify #ERROR: %d, #WARNING: %d.", this.mLogger.numErrors(), this.mLogger.numWarnings());
        this.mLogger.logInfo(msg);
        if (this.mLogger.getLogFile() != null) {
            msg = msg + String.format(" See details in '%s'", this.mLogger.getLogFile().getPath());
        }
        System.out.println(msg);
    }

    private MessageLogger getMessageLogger(MessageLogger logger) throws VerifierExecutionException {
        if (logger == null) {
            String logfilePath = System.getProperty("user.dir") + "/" + this.mCatalogFiles.getPrefix() + "_verify.txt";
            try {
                logger = new MessageLogger(logfilePath);
            }
            catch (IOException io) {
                String msg = String.format("Problem creating writer for log file '%s'. Msg: %s", logfilePath, io.getMessage());
                throw new VerifierExecutionException(msg);
            }
        }
        return logger;
    }

    private CatalogFiles getCatalogFiles(File mCatalogFile) throws VerifierInputException {
        try {
            this.mCatalogFiles = new CatalogFiles(mCatalogFile);
        }
        catch (CatalogFormatException e) {
            throw new VerifierInputException(e.getMessage());
        }
        return this.mCatalogFiles;
    }

    private void verifyCatalogCommonCharacteristics() throws VerifierInputException {
        this.verifySupportingCatalogFilesExist(this.mCatalogFiles);
        File columnsFile = this.mCatalogFiles.getColumnsFile();
        if (columnsFile != null) {
            try {
                ColumnMetaDataVerificationMessages msgs = this.mColumnMetaOps.verifyContents();
                this.logAnyWarnings(msgs, columnsFile);
                this.logAnyErrors(msgs, columnsFile);
                this.logNoColumnsIfNecessary(this.mCatalogColumnsMap, columnsFile);
            }
            catch (IOException e) {
                this.logError("Exception raised reading in columns.tsv file name: " + columnsFile.getAbsolutePath(), 100);
            }
        }
        if (this.mCatalogDataSource == null) {
            this.logError("Failed to instantiate and verify data source properties. Unable to set some catalog characteristics.", 101);
        } else {
            this.mCatalogDataSource.verify(this.mValType, this.mLogger);
        }
        if (this.mBIORIndexMapColNameToFilePathMap == null) {
            this.logInfo(String.format("No H2 indexes configured for '%s'", this.mCatalogFiles.getCatalogFile()));
        }
        this.verifyBlackList(this.mCatalogFiles.getBlacklistFile(), this.mCatalogColumnsMap);
        this.verifyBlackList(this.mCatalogFiles.getBlacklistBiorwebFile(), this.mCatalogColumnsMap);
    }

    private void logNoColumnsIfNecessary(HashMap<String, ColumnMetaData> mCatalogColumns2, File columnsFile) {
        if (this.mCatalogColumnsMap.keySet().size() == 0) {
            String msg = String.format("No columns were read from '%s'", columnsFile.getPath());
            this.logError(msg, 102);
        }
    }

    private void logAnyErrors(ColumnMetaDataVerificationMessages msgs, File columnsFile) {
        List errors = msgs.getErrors();
        if (!errors.isEmpty()) {
            String msg = String.format("Columns.tsv file '%s' has the following ERROR messages which could affect verification:", columnsFile.getPath());
            this.logInfo(msg);
        }
        for (String error : errors) {
            this.logError(error, 103);
        }
    }

    private void logAnyWarnings(ColumnMetaDataVerificationMessages msgs, File columnsFile) {
        List warnings = msgs.getWarnings();
        if (!warnings.isEmpty()) {
            String msg = String.format("Columns.tsv file '%s' has the following WARNING messages:", columnsFile.getPath());
            this.logInfo(msg);
        }
        for (String warning : warnings) {
            this.logWarning(warning);
        }
    }

    private void verifySupportingCatalogFilesExist(CatalogFiles catalog) {
        File tabixIndexFile = catalog.getTabixIndexFile();
        this.verifySupportingFileAsError(tabixIndexFile, ".tsv.bgz.tbi", 104);
        if (tabixIndexFile == null || !tabixIndexFile.exists()) {
            this.logError("Cannot check to ensure tabix file is newer than catalog file since tabix file does not exist.", 105);
        } else if (this.mCatalogFiles.getCatalogFile().lastModified() > tabixIndexFile.lastModified()) {
            this.logError("Tabix index file timestamp is older than the catalog file.", 106);
        }
        this.verifySupportingFileAsError(catalog.getColumnsFile(), catalog.getPrefix() + ".columns.tsv", 107);
        this.verifySupportingFileAsError(catalog.getDataSourceFile(), catalog.getPrefix() + ".datasource.properties", 108);
        this.verifySupportingFileAsWarning(catalog.getBlacklistFile(), catalog.getPrefix() + ".columns.tsv.blacklist");
        this.verifySupportingFileAsWarning(catalog.getBlacklistBiorwebFile(), catalog.getPrefix() + ".columns.tsv.blacklist.biorweb");
    }

    private void verifySupportingFileAsWarning(File file, String fileDescription) {
        if (file == null || !file.exists()) {
            this.logWarning(fileDescription + " file does not exist");
        }
    }

    private void verifySupportingFileAsError(File file, String fileDescription, int code) {
        if (file == null || !file.exists()) {
            this.logError(fileDescription + " file does not exist", code);
        }
    }

    private TreeMap<String, String> verifyBIORIndexFilenames(File catalogFile) {
        TreeMap<String, String> biorIndexMap = new TreeMap<String, String>();
        File indexDir = new File(this.mCatalogFiles.getDir() + File.separator + "index");
        if (!indexDir.isDirectory()) {
            return null;
        }
        File[] fList = indexDir.listFiles();
        if (fList != null) {
            for (File indexFile : fList) {
                String colNameIndexed = this.getColNameFromIndex(indexFile, this.mCatalogFiles.getPrefix());
                if (!indexFile.getName().endsWith(".idx.h2.db")) continue;
                if (this.mCatalogColumnsMap == null) {
                    this.logWarning("Don't have columns.tsv to check index key '" + colNameIndexed + "'");
                } else if (this.mCatalogColumnsMap.get(colNameIndexed) == null) {
                    this.logWarning("Index key '" + colNameIndexed + "' not found in columns.tsv.");
                }
                if (catalogFile.lastModified() > indexFile.lastModified()) {
                    String msg = String.format("Regenerate index for key '%s'. Catalog '%s' is newer than the index file '%s'", colNameIndexed, catalogFile.getPath(), indexFile.getPath());
                    this.logError(msg, 109);
                    continue;
                }
                biorIndexMap.put(colNameIndexed, indexFile.getAbsolutePath());
            }
        }
        if (biorIndexMap.size() == 0) {
            this.logWarning("BIOR Index checking: No valid H2 database file names found in index subdirectory for catalog name: " + this.mCatalogFiles.getPrefix());
        }
        return biorIndexMap;
    }

    private String getColNameFromIndex(File indexFile, String catalogPrefix) {
        String indexName = indexFile.getName();
        String suffix = ".idx.h2.db";
        String catalogPrefixWithoutVcf = catalogPrefix.endsWith(".vcf") ? catalogPrefix.substring(0, catalogPrefix.length() - 4) : catalogPrefix;
        String colName = indexName;
        if (colName.endsWith(suffix)) {
            colName = colName.substring(0, colName.length() - suffix.length());
        }
        if (colName.startsWith(catalogPrefix + ".")) {
            colName = colName.substring(catalogPrefix.length() + 1);
        } else if (colName.startsWith(catalogPrefixWithoutVcf + ".")) {
            colName = colName.substring(catalogPrefixWithoutVcf.length() + 1);
        }
        return colName;
    }

    private void verifyBlackList(File blacklistFile, HashMap<String, ColumnMetaData> catalogColumnInfo) {
        if (blacklistFile == null) {
            return;
        }
        if (catalogColumnInfo == null || catalogColumnInfo.keySet().size() == 0) {
            String msg = String.format("Cannot verify content of '%s' as we have no columns.tsv info", blacklistFile.getPath());
            this.logWarning(msg);
            return;
        }
        BufferedReader rdr = CatalogFileUtils.getBufferedReader(blacklistFile.getAbsolutePath());
        if (rdr == null) {
            String msg = String.format("Problem getting object to read blacklist file '%s'", blacklistFile.getPath());
            this.logError(msg, 110);
            return;
        }
        try {
            String line;
            HashSet<String> unknownBlacklistKeys = new HashSet<String>();
            while ((line = rdr.readLine()) != null) {
                String key = line.trim();
                if (key.startsWith("#") || catalogColumnInfo.get(key) != null) continue;
                unknownBlacklistKeys.add(line.trim());
            }
            if (!unknownBlacklistKeys.isEmpty()) {
                String description = "columns";
                if (unknownBlacklistKeys.size() == 1) {
                    description = "a column";
                }
                ArrayList sortedBlacklistKeys = new ArrayList(unknownBlacklistKeys);
                Collections.sort(sortedBlacklistKeys);
                String msg = String.format("'%s' contains %s not found in the columns.tsv file: %s", blacklistFile.getPath(), description, StringUtils.join(sortedBlacklistKeys, (String)","));
                this.logWarning(msg);
            }
        }
        catch (IOException io) {
            String msg = String.format("Issue reading blacklist file '%s'. Msg: %s", blacklistFile.getPath(), io.getMessage());
            this.logError(msg, 111);
        }
    }

    protected MessageLogger getLogger() {
        return this.mLogger;
    }

    protected void setLogger(MessageLogger l) {
        this.mLogger = l;
    }

    protected void logInfo(String msg) {
        this.mLogger.logInfo(msg);
    }

    protected void logWarning(String msg) {
        this.mLogger.logWarning(msg);
    }

    protected void logError(String msg, int code) {
        this.mLogger.logError(msg, code);
    }

    private CatalogOrderVerifierThread startCatalogOrderCheckingThread() throws VerifierInputException {
        CatalogOrderVerifier validator = new CatalogOrderVerifier(this.mReferenceInfo.getExpectedChrOrderList(), this.mCatalogFiles.getCatalogFile().getAbsolutePath(), this.mBIORIndexMapColNameToFilePathMap, this.mLogger);
        CatalogOrderVerifierThread thread = new CatalogOrderVerifierThread(validator);
        thread.start();
        return thread;
    }

    private CatalogOrderVerifier verifyChromosomeOrder(long oneInXLinesToVerify) throws VerifierInputException {
        CatalogOrderVerifier orderVerifier = new CatalogOrderVerifier(this.mReferenceInfo.getExpectedChrOrderList(), this.mCatalogFiles.getCatalogFile().getAbsolutePath(), this.mBIORIndexMapColNameToFilePathMap, this.mLogger, oneInXLinesToVerify);
        orderVerifier.verify();
        return orderVerifier;
    }

    public static void main(String[] args) throws Exception {
        File file = new File(args[0]);
        String catalogFilePath = file.getPath();
        CatalogVerifier catalogValidator = new CatalogVerifier();
        try {
            catalogValidator.verify(catalogFilePath, VAL_TYPE.STRICT, null, 1L);
        }
        catch (Exception e) {
            System.err.println("Exception raised in bior_verify_catalog: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static enum VAL_TYPE {
        LENIENT,
        STRICT;

    }

    public static enum Phase {
        METADATA,
        ORDER,
        JSON;

    }
}

