/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.verification;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.catalog.CatalogFileUtils;
import edu.mayo.bior.catalog.CatalogFiles;
import edu.mayo.bior.catalog.CatalogFormatException;
import edu.mayo.bior.catalog.CatalogTabixEntry;
import edu.mayo.bior.catalog.verification.CatalogEntryGoldenJson;
import edu.mayo.bior.catalog.verification.MessageLogger;
import edu.mayo.bior.catalog.verification.VerifierInputException;
import edu.mayo.bior.catalog.verification.VerifyUtils;
import edu.mayo.pipes.JSON.lookup.LookupPipe;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import htsjdk.tribble.readers.TabixReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogOrderVerifier {
    private static final Logger sLogger = LoggerFactory.getLogger(CatalogOrderVerifier.class);
    public static final String UNKNOWN_CHR = "UNKNOWN";
    private String mCatalogFilePath = null;
    private List<String> mExpectChrOrder = null;
    private Map<String, String> mIndexNamePathMap = null;
    private JsonParser mJsonParser = new JsonParser();
    private Set arrayKeysReported = new HashSet();
    private long mOneInXLinesToVerify = 1L;
    private MessageLogger logger = null;
    private static final String DBL_QUOTE = "\"";
    private static final String NL = VerifyUtils.NL;

    private Map<String, String> getBiorIndexMap() {
        return this.mIndexNamePathMap;
    }

    public CatalogOrderVerifier(List<String> expectedChrOrderList, String catalogFilePath, Map<String, String> indexNameToPathMap, MessageLogger messageLogger) throws VerifierInputException {
        this(expectedChrOrderList, catalogFilePath, indexNameToPathMap, messageLogger, 1L);
    }

    public CatalogOrderVerifier(List<String> expectedChrOrderList, String catalogFilePath, Map<String, String> indexNameToPathMap, MessageLogger messageLogger, long oneInXLinesToVerify) throws VerifierInputException {
        try {
            new CatalogFiles(catalogFilePath);
            this.mOneInXLinesToVerify = oneInXLinesToVerify;
        }
        catch (CatalogFormatException e) {
            throw new VerifierInputException(e.getMessage());
        }
        this.setExpectedChrOrderList(expectedChrOrderList);
        this.setCatalogFileName(catalogFilePath);
        this.setBiorIndexMap(indexNameToPathMap);
        this.logger = messageLogger;
    }

    public void verify() {
        String statusMsg = String.format("Verifying chromosomal order and indexes for '%s' starting at %s", this.mCatalogFilePath, VerifyUtils.composeDateTime());
        System.out.println(statusMsg);
        this.logger.logInfo(statusMsg);
        TreeSet<Map.Entry<String, String>> biorIndexEntrySet = new TreeSet();
        TreeMap<String, CatalogTabixEntry> lastRowWithThisBiorIndexValue = new TreeMap<String, CatalogTabixEntry>();
        if (this.getBiorIndexMap() != null) {
            biorIndexEntrySet = this.getBiorIndexMap().entrySet();
            for (String key : this.getBiorIndexMap().keySet()) {
                if (key.contains(".")) {
                    String msg = String.format("Currently we are not verifying indexes on hierarchichal keys (key '%s')", key);
                    this.logger.logWarning(msg);
                    continue;
                }
                lastRowWithThisBiorIndexValue.put(key, null);
            }
        }
        HashSet<String> chrAlreadySeen = new HashSet<String>();
        ArrayList<String> chrSeenInOrder = new ArrayList<String>();
        CatalogTabixEntry previousRow = null;
        boolean seen4TabixColumns = false;
        boolean seen1TabixColumn = false;
        try {
            String line;
            BufferedReader catalogRdr = CatalogFileUtils.getBufferedReader(this.mCatalogFilePath);
            if (catalogRdr == null) {
                throw new IOException(String.format("Couldn't create an object to read catalog '%s'", this.mCatalogFilePath));
            }
            TabixReader tabixReader = null;
            try {
                tabixReader = new TabixReader(this.mCatalogFilePath);
            }
            catch (IOException io) {
                String msg = "Couldn't create a Tabix reader for catalog: '" + this.mCatalogFilePath + "'. Msg: " + io.getMessage();
                this.logger.logError(msg, 200);
            }
            long lineReadCount = 0L;
            long lineVerifiedCount = 0L;
            boolean keepChecking = true;
            while ((line = catalogRdr.readLine()) != null && keepChecking) {
                CatalogTabixEntry currentRow;
                if (line.trim().startsWith("#") || this.shouldSkipRow(++lineReadCount) || (currentRow = VerifyUtils.readCatalogRow(line, this.logger)) == null) continue;
                if (currentRow.is4Field()) {
                    seen4TabixColumns = true;
                } else if (currentRow.is1Field()) {
                    seen1TabixColumn = true;
                }
                if (seen4TabixColumns && seen1TabixColumn) {
                    this.logger.logError("Saw a mix of 4 columns and 1 columns in catalog. Stopping checking", 201);
                    keepChecking = false;
                    continue;
                }
                for (String biorIndexKey : lastRowWithThisBiorIndexValue.keySet()) {
                    if (!currentRow.getJsonString().contains(this.composeJsonIndexStr(biorIndexKey))) continue;
                    lastRowWithThisBiorIndexValue.put(biorIndexKey, currentRow);
                }
                if (currentRow.is4Field()) {
                    if (previousRow != null && currentRow.getChromosome().equals(previousRow.getChromosome())) {
                        this.verifySameChromosome(currentRow, previousRow, line);
                    } else {
                        this.verifyNewChromosome(currentRow, previousRow, biorIndexEntrySet, lastRowWithThisBiorIndexValue, chrAlreadySeen, tabixReader, line);
                        chrSeenInOrder.add(currentRow.getChromosome());
                    }
                    ++lineVerifiedCount;
                    chrAlreadySeen.add(currentRow.getChromosome());
                }
                previousRow = currentRow;
            }
            if (previousRow != null && previousRow.isPositional()) {
                if (!previousRow.isUnknownPosition()) {
                    this.verifyLastTabixLine(previousRow, tabixReader);
                }
                this.verifyIndexes(null, previousRow, biorIndexEntrySet, lastRowWithThisBiorIndexValue);
            }
            this.logger.logInfo("Order of chromosomes: " + StringUtils.join(chrSeenInOrder, (String)","));
            statusMsg = String.format("Chrom and position order: Number of lines read (%d) and verified (%d)", lineReadCount, lineVerifiedCount);
            this.logger.logInfo(statusMsg);
            statusMsg = String.format("Completed verifying order and indexes at %s", VerifyUtils.composeDateTime());
            this.logger.logInfo(statusMsg);
        }
        catch (CatalogFormatException e) {
            String msg = String.format("Problem with Catalog format. Msg: %s", e.getMessage());
            sLogger.error(ExceptionUtils.getStackTrace((Throwable)e));
            this.logger.logError(msg, 112);
        }
        catch (IOException e) {
            sLogger.error(ExceptionUtils.getStackTrace((Throwable)e));
            this.logger.logError(e.getMessage(), 202);
        }
    }

    private boolean shouldSkipRow(long rowsInCatalog) {
        long zeroBasedRowInCatalog = rowsInCatalog - 1L;
        return zeroBasedRowInCatalog % this.mOneInXLinesToVerify != 0L;
    }

    private void verifyNewChromosome(CatalogTabixEntry currentRow, CatalogTabixEntry previousRow, Set<Map.Entry<String, String>> biorIndexEntrySet, TreeMap<String, CatalogTabixEntry> lastRowWithThisBiorIndexValue, Set<String> chrAlreadySeen, TabixReader tabixReader, String line) throws IOException, CatalogFormatException {
        if (chrAlreadySeen.contains(currentRow.getChromosome())) {
            String msg = String.format("Already saw this chr '%s' in previous block of catalog. Line: %s", currentRow.getChromosome(), line);
            this.logger.logError(msg, 300);
        }
        if (previousRow != null && !previousRow.isUnknownPosition()) {
            this.verifyLastTabixLine(previousRow, tabixReader);
        }
        if (!currentRow.isUnknownPosition()) {
            this.verifyFirstTabixLine(currentRow, tabixReader);
        }
        this.verifyIndexes(currentRow, previousRow, biorIndexEntrySet, lastRowWithThisBiorIndexValue);
        this.verifyChromosomeInExpectedOrder(currentRow, previousRow, line);
    }

    private void verifyFirstTabixLine(CatalogTabixEntry row, TabixReader tabixReader) throws IOException, CatalogFormatException {
        this.verifyTabixLine(row, tabixReader, true, "first");
    }

    private void verifyLastTabixLine(CatalogTabixEntry row, TabixReader tabixReader) throws IOException, CatalogFormatException {
        this.verifyTabixLine(row, tabixReader, false, "last");
    }

    private void verifyTabixLine(CatalogTabixEntry row, TabixReader tabixReader, boolean firstResult, String description) throws IOException, CatalogFormatException {
        if (row == null) {
            return;
        }
        if (tabixReader == null) {
            return;
        }
        if (!VerifyUtils.isTabixRetrievalSuccessful(tabixReader, row, firstResult)) {
            String msg = String.format("Failed to retrieve %s tabix entry for chromosome %s from line '%s'", description, row.getChromosome(), row.getLine());
            this.logger.logError(msg, 203);
        }
    }

    private String composeRowChromosome(CatalogTabixEntry row) {
        String rowChromosome = "null";
        if (row != null) {
            rowChromosome = row.getChromosome();
        }
        return rowChromosome;
    }

    private void verifySameChromosome(CatalogTabixEntry currentRow, CatalogTabixEntry previousRow, String line) {
        if (previousRow.getMinPosition() > currentRow.getMinPosition()) {
            String msg = String.format("Previous position [%s] within chromosome is greater than current row position [%s]. Line: '%s'", previousRow.getMinPosition(), currentRow.getMinPosition(), line);
            this.logger.logError(msg, 301);
        }
        try {
            CatalogEntryGoldenJson currentRowGolden = new CatalogEntryGoldenJson(VerifyUtils.getJsonObject(currentRow.getJsonString()));
            CatalogEntryGoldenJson previousRowGolden = new CatalogEntryGoldenJson(VerifyUtils.getJsonObject(previousRow.getJsonString()));
            if (currentRowGolden.isVariant() && currentRowGolden.equals(previousRowGolden)) {
                String msg = String.format("Duplicate variant information at position %s:%d-%d", previousRowGolden.getChr(), previousRowGolden.getMinBP(), previousRowGolden.getMaxBP());
                this.logger.logWarning(msg);
            }
        }
        catch (CatalogFormatException catalogFormatException) {
            // empty catch block
        }
    }

    private void verifyChromosomeInExpectedOrder(CatalogTabixEntry currentRow, CatalogTabixEntry previousRow, String line) {
        if (previousRow == null) {
            return;
        }
        if (this.hasExpectedChrOrderList()) {
            int currentLnChrIdx = this.mExpectChrOrder.indexOf(currentRow.getChromosome());
            if (currentLnChrIdx < 0) {
                if (currentRow.getChromosome().equals(UNKNOWN_CHR)) {
                    this.logger.logInfo(String.format("Saw %s chromosome", UNKNOWN_CHR));
                }
                String msg = String.format("Chromosome '%s' is not in expected chromosome list.", currentRow.getChromosome());
                this.logger.logError(msg, 302);
                return;
            }
            int previousLnChrIdx = this.mExpectChrOrder.indexOf(previousRow.getChromosome());
            if (previousLnChrIdx > currentLnChrIdx) {
                String msg = String.format("Catalog entry for chromosome '%s' not in expected chromosome order. Previous chromosome catalog entries were for '%s', but the current catalog entry is for '%s'. Full Catalog Entry is: '%s'", currentRow.getChromosome(), this.mExpectChrOrder.get(previousLnChrIdx), this.mExpectChrOrder.get(currentLnChrIdx), line);
                this.logger.logWarning(msg);
            } else if (currentLnChrIdx == previousLnChrIdx) {
                String msg = String.format("Unexpected code-path reached: Previous chr index in list '%s' equal to current chr index in list '%s'. Should NOT find this condition. Line: '%s'", previousLnChrIdx, currentLnChrIdx, line);
                throw new RuntimeException(msg);
            }
        }
    }

    public boolean areErrorsLogged() {
        return this.logger.hasErrors();
    }

    private void setBiorIndexMap(Map<String, String> indexNamePathMap) {
        this.mIndexNamePathMap = indexNamePathMap;
    }

    public String getCatalogFileName() {
        return this.mCatalogFilePath;
    }

    private void setCatalogFileName(String catalogFileName) {
        this.mCatalogFilePath = catalogFileName;
    }

    private void setExpectedChrOrderList(List<String> expectedChrOrder) {
        this.mExpectChrOrder = expectedChrOrder;
    }

    private boolean hasExpectedChrOrderList() {
        return this.mExpectChrOrder != null && this.mExpectChrOrder.size() > 0;
    }

    public MessageLogger getLogger() {
        return this.logger;
    }

    private void verifyIndexes(CatalogTabixEntry currentRow, CatalogTabixEntry previousRow, Set<Map.Entry<String, String>> biorIndexEntrySet, TreeMap<String, CatalogTabixEntry> lastRowWithThisBiorIndex) {
        for (Map.Entry<String, String> entry : biorIndexEntrySet) {
            String msg;
            String biorIndexName = entry.getKey();
            String biorIndexFileName = entry.getValue();
            try {
                this.verifyIndex(previousRow, biorIndexName, biorIndexFileName, lastRowWithThisBiorIndex, "last");
            }
            catch (Exception e) {
                msg = String.format("Problem trying to check BIOR index: '%s' for last row of chromosome '%s'", biorIndexName, this.composeRowChromosome(previousRow));
                this.logger.logError(msg, 204);
            }
            try {
                this.verifyIndex(currentRow, biorIndexName, biorIndexFileName, lastRowWithThisBiorIndex, "first");
            }
            catch (Exception e) {
                msg = String.format("Problem trying to check BIOR index: '%s' for first row of chromosome '%s'", biorIndexName, this.composeRowChromosome(currentRow));
                this.logger.logError(msg, 205);
            }
        }
    }

    private void verifyIndex(CatalogTabixEntry row, String biorIndexName, String biorIndexFileName, TreeMap<String, CatalogTabixEntry> lastRowWithThisBiorIndex, String description) throws SQLException, IOException {
        if (row == null) {
            return;
        }
        CatalogTabixEntry catEntryToUse = row.getJsonString().contains(this.composeJsonIndexStr(biorIndexName)) ? row : lastRowWithThisBiorIndex.get(biorIndexName);
        if (catEntryToUse == null) {
            return;
        }
        if (!this.isBiorIndexRetrievalSuccessful(new File(this.getCatalogFileName()), new File(biorIndexFileName), biorIndexName, catEntryToUse.getJsonString())) {
            String msg = String.format("Failed to retrieve BIOR Index entry for %s line of chromosome %s for key '%s'. Line: '%s'", description, row.getChromosome(), biorIndexName, row.getLine());
            this.logger.logError(msg, 206);
        }
    }

    private String composeJsonIndexStr(String biorIndexName) {
        return DBL_QUOTE + biorIndexName + DBL_QUOTE + ":";
    }

    private boolean isBiorIndexRetrievalSuccessful(File catalogFile, File biorIndexFile, String indexedColumnName, String json) throws SQLException, IOException {
        JsonObject catalogRowJsonObj;
        try {
            catalogRowJsonObj = this.mJsonParser.parse(json).getAsJsonObject();
        }
        catch (Exception e) {
            String msg = String.format("Couldn't parse json '%s'. Msg: '%s'", json, e.getMessage());
            this.logger.logError(msg, 400);
            return false;
        }
        String valueForIndexedKey = this.getValueForIndexedKey(catalogRowJsonObj, indexedColumnName);
        if (valueForIndexedKey == null) {
            return true;
        }
        if (valueForIndexedKey.equals(".")) {
            return true;
        }
        List<String> matches = this.findMatches(catalogFile, biorIndexFile, json, valueForIndexedKey);
        if (matches.size() == 1) {
            return true;
        }
        if (matches.size() == 0) {
            return false;
        }
        String msg = String.format("BIOR index lookup on key '%s' with value '%s' found more than 1 row (%d) with matching json", indexedColumnName, valueForIndexedKey, matches.size());
        this.logger.logWarning(msg);
        return true;
    }

    private List<String> findMatches(File catalogFile, File biorIndexFile, String json, String valueForIndexedKey) throws SQLException, IOException {
        String catalog = catalogFile.getPath();
        String index = biorIndexFile.getPath();
        Metadata md = new Metadata(catalog, "bior_lookup");
        Pipeline p = new Pipeline(new Pipe[]{new HistoryInPipe(md), new LookupPipe(catalog, index), new HistoryOutPipe()});
        p.setStarts(Collections.singletonList(valueForIndexedKey));
        ArrayList<String> matches = new ArrayList<String>();
        while (p.hasNext()) {
            String resultJson;
            String resultIndexedValue;
            String result = (String)p.next();
            String[] elems = result.split("\t");
            if (result.startsWith("#") || elems.length != 2 || !valueForIndexedKey.equals(resultIndexedValue = elems[0]) || !json.equals(resultJson = elems[1])) continue;
            matches.add(result);
        }
        return matches;
    }

    private String getValueForIndexedKey(JsonObject jsonObj, String keyOfValueToRetrieve) {
        for (Map.Entry thisEntry : jsonObj.entrySet()) {
            String jsonKey = (String)thisEntry.getKey();
            if (!jsonKey.equals(keyOfValueToRetrieve)) continue;
            JsonElement jsonElem = (JsonElement)thisEntry.getValue();
            if (jsonElem.isJsonNull()) {
                return null;
            }
            if (jsonElem.isJsonArray()) {
                if (!this.arrayKeysReported.contains(keyOfValueToRetrieve)) {
                    String msg = String.format("Currently we are not verifying indexes on arrays (key '%s')", keyOfValueToRetrieve);
                    this.logger.logWarning(msg);
                    this.arrayKeysReported.add(keyOfValueToRetrieve);
                }
                return null;
            }
            if (jsonElem.isJsonPrimitive()) {
                JsonPrimitive primitive = jsonElem.getAsJsonPrimitive();
                if (primitive.isString()) {
                    return primitive.getAsString();
                }
                return primitive.toString();
            }
            return jsonElem.toString();
        }
        return null;
    }
}

