/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.stats;

import edu.mayo.bior.catalog.stats.AsciiCharacterStats;
import edu.mayo.bior.catalog.stats.ValueSampling;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class CatalogColumnStats {
    private String columnName;
    private long numEntries;
    private long numCharacters;
    private AsciiCharacterStats totalAsciiStats;
    private AsciiCharacterStats lineAsciiStats;
    private HashMap<String, ValueSampling> valueSamplings = new LinkedHashMap<String, ValueSampling>();

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String colName) {
        this.columnName = colName;
    }

    public long getNumCharacters() {
        return this.numCharacters;
    }

    public void setNumCharacters(Long numCharacters) {
        this.numCharacters = numCharacters;
    }

    public void incrementNumCharacters() {
        ++this.numCharacters;
    }

    public long getNumEntries() {
        return this.numEntries;
    }

    public void setNumEntries(long numEntries) {
        this.numEntries = numEntries;
    }

    public void incrementNumEntries() {
        ++this.numEntries;
    }

    public AsciiCharacterStats getTotalAsciiStats() {
        return this.totalAsciiStats;
    }

    public void setTotalAsciiStats(AsciiCharacterStats totalAsciiStats) {
        this.totalAsciiStats = totalAsciiStats;
    }

    public AsciiCharacterStats getLineAsciiStats() {
        return this.lineAsciiStats;
    }

    public void setLineAsciiStats(AsciiCharacterStats lineAsciiStats) {
        this.lineAsciiStats = lineAsciiStats;
    }

    public Collection<ValueSampling> getValueSamplings() {
        return this.valueSamplings.values();
    }

    public long getNumUniqueValues() {
        return this.valueSamplings.size();
    }

    public ValueSampling getValueSampling(String value) {
        return this.valueSamplings.get(value);
    }

    public void incrementValueCount(String value) {
        this.valueSamplings.get(value).incrementFrequency();
    }

    public void addValueSampling(ValueSampling valSampling) {
        this.valueSamplings.put(valSampling.getValue(), valSampling);
    }

    public void setValueSamplings(Collection<ValueSampling> valueSamplings) {
        this.valueSamplings.clear();
        for (ValueSampling valSampleToAdd : valueSamplings) {
            this.valueSamplings.put(valSampleToAdd.getValue(), valSampleToAdd);
        }
    }
}

