/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util;

import com.tinkerpop.blueprints.CloseableIterable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MultiIterable<S>
implements CloseableIterable<S> {
    private final List<Iterable<S>> iterables;

    public MultiIterable(List<Iterable<S>> iterables) {
        this.iterables = iterables;
    }

    @Override
    public Iterator<S> iterator() {
        if (this.iterables.size() == 0) {
            return Collections.emptyList().iterator();
        }
        return new Iterator<S>(){
            private Iterator<S> currentIterator;
            private int current;
            {
                this.currentIterator = ((Iterable)MultiIterable.this.iterables.get(0)).iterator();
                this.current = 0;
            }

            @Override
            public void remove() {
                this.currentIterator.remove();
            }

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.currentIterator.hasNext()) {
                        return true;
                    }
                    ++this.current;
                    if (this.current >= MultiIterable.this.iterables.size()) break;
                    this.currentIterator = ((Iterable)MultiIterable.this.iterables.get(this.current)).iterator();
                }
                return false;
            }

            @Override
            public S next() {
                while (true) {
                    if (this.currentIterator.hasNext()) {
                        return this.currentIterator.next();
                    }
                    ++this.current;
                    if (this.current >= MultiIterable.this.iterables.size()) break;
                    this.currentIterator = ((Iterable)MultiIterable.this.iterables.get(this.current)).iterator();
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public void close() {
        for (Iterable<S> itty : this.iterables) {
            if (!(itty instanceof CloseableIterable)) continue;
            ((CloseableIterable)itty).close();
        }
    }
}

