/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;
import org.biojavax.ga.functions.GACrossResult;
import org.biojavax.ga.functions.SimpleGACrossResult;

public interface CrossOverFunction
extends Changeable {
    public static final int DEFAULT_MAX_CROSS = Integer.MAX_VALUE;
    public static final double[] DEFAULT_CROSS_PROB = new double[]{0.0};
    public static final ChangeType MAX_CROSSES = new ChangeType("maximum number of crosses", CrossOverFunction.class, "MAX_CROSSES");
    public static final ChangeType CROSS_PROB = new ChangeType("cross over probabilities", CrossOverFunction.class, "CROSS_PROB");
    public static final CrossOverFunction NO_CROSS = new NoCross();

    public GACrossResult performCrossOver(SymbolList var1, SymbolList var2) throws ChangeVetoException;

    public void setMaxCrossOvers(int var1) throws ChangeVetoException;

    public int getMaxCrossOvers();

    public void setCrossOverProbs(double[] var1) throws ChangeVetoException;

    public double[] getCrossOverProbs();

    public static final class NoCross
    implements CrossOverFunction {
        @Override
        public double[] getCrossOverProbs() {
            return new double[]{0.0};
        }

        @Override
        public int getMaxCrossOvers() {
            return 0;
        }

        @Override
        public GACrossResult performCrossOver(SymbolList chromA, SymbolList chromB) {
            return new SimpleGACrossResult(new PointLocation[0], new SymbolList[]{chromA, chromB});
        }

        @Override
        public void setCrossOverProbs(double[] crossOverProb) throws ChangeVetoException {
            throw new ChangeVetoException("Cannot set the crossOverProb for a NO_CROSS function");
        }

        @Override
        public void setMaxCrossOvers(int max) throws ChangeVetoException {
            throw new ChangeVetoException("Cannot change the maximum crossovers in a NO_CROSS function");
        }

        @Override
        public boolean isUnchanging(ChangeType t) {
            return true;
        }

        @Override
        public void removeChangeListener(ChangeListener c) {
        }

        @Override
        public void addChangeListener(ChangeListener cl) {
        }

        @Override
        public void addChangeListener(ChangeListener cl, ChangeType ct) {
        }

        @Override
        public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        }
    }
}

