/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import org.biojava.bio.BioError;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.functions.CrossOverFunction;

public abstract class AbstractCrossOverFunction
extends AbstractChangeable
implements CrossOverFunction {
    private int maxCross;
    private double[] crossProbs;

    protected AbstractCrossOverFunction() {
        try {
            this.setMaxCrossOvers(Integer.MAX_VALUE);
            this.setCrossOverProbs(CrossOverFunction.DEFAULT_CROSS_PROB);
        }
        catch (ChangeVetoException ex) {
            throw new BioError("Cannot set the default values of the CrossOverFunction", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setMaxCrossOvers(int maxCrossOvers) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.maxCross = maxCrossOvers;
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, CrossOverFunction.MAX_CROSSES, new Integer(maxCrossOvers), new Integer(this.maxCross));
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(CrossOverFunction.MAX_CROSSES);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.maxCross = maxCrossOvers;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    @Override
    public final int getMaxCrossOvers() {
        return this.maxCross;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCrossOverProbs(double[] crossOverProbs) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.crossProbs = crossOverProbs;
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, CrossOverFunction.CROSS_PROB, crossOverProbs, this.crossProbs);
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(CrossOverFunction.CROSS_PROB);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.crossProbs = crossOverProbs;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    @Override
    public final double[] getCrossOverProbs() {
        return this.crossProbs;
    }
}

