/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import org.biojavax.bio.seq.Position;

public interface PositionResolver {
    public int getMin(Position var1);

    public int getMax(Position var1);

    public static class AverageResolver
    implements PositionResolver {
        @Override
        public int getMin(Position s) {
            int min = s.getStart();
            int max = s.getEnd();
            return (min + max) / 2;
        }

        @Override
        public int getMax(Position e) {
            int min = e.getStart();
            int max = e.getEnd();
            return (min + max) / 2;
        }
    }

    public static class MinimalResolver
    implements PositionResolver {
        @Override
        public int getMin(Position s) {
            return s.getEnd();
        }

        @Override
        public int getMax(Position e) {
            return e.getStart();
        }
    }

    public static class MaximalResolver
    implements PositionResolver {
        @Override
        public int getMin(Position s) {
            return s.getStart();
        }

        @Override
        public int getMax(Position e) {
            return e.getEnd();
        }
    }
}

