/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import java.util.ArrayList;
import java.util.Collection;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.CrossRef;
import org.biojavax.bio.seq.CompoundRichLocation;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.SimplePosition;
import org.biojavax.ontology.ComparableTerm;

public class MultiSourceCompoundRichLocation
extends CompoundRichLocation
implements RichLocation {
    public MultiSourceCompoundRichLocation(Collection members) {
        this(MultiSourceCompoundRichLocation.getJoinTerm(), members);
    }

    public MultiSourceCompoundRichLocation(ComparableTerm term, Collection members) {
        if (term == null) {
            throw new IllegalArgumentException("Term cannot be null");
        }
        if (members == null || members.size() < 2) {
            throw new IllegalArgumentException("Must have at least two members");
        }
        this.term = term;
        this.members = new ArrayList();
        for (Object o : members) {
            if (!(o instanceof RichLocation)) {
                o = RichLocation.Tools.enrich((Location)o);
            }
            RichLocation rl = (RichLocation)o;
            this.members.add(rl);
            this.size += Math.max(rl.getMin(), rl.getMax()) - Math.min(rl.getMin(), rl.getMax());
        }
    }

    @Override
    public CrossRef getCrossRef() {
        return null;
    }

    @Override
    public int getCircularLength() {
        return 0;
    }

    @Override
    public void setCircularLength(int sourceSeqLength) throws ChangeVetoException {
        if (sourceSeqLength > 0) {
            throw new ChangeVetoException("MultiSourceCompoundRichLocations cannot be circular");
        }
    }

    @Override
    public RichLocation.Strand getStrand() {
        return RichLocation.Strand.UNKNOWN_STRAND;
    }

    @Override
    public int getMin() {
        return 1;
    }

    @Override
    public int getMax() {
        return this.size;
    }

    @Override
    public Position getMinPosition() {
        return new SimplePosition(false, false, 1);
    }

    @Override
    public Position getMaxPosition() {
        return new SimplePosition(false, false, this.size);
    }

    @Override
    public Location translate(int dist) {
        if (this.members.isEmpty()) {
            return this;
        }
        ArrayList<Location> newmembers = new ArrayList<Location>();
        for (RichLocation rl : this.members) {
            newmembers.add(rl.translate(dist));
        }
        return new MultiSourceCompoundRichLocation(this.getTerm(), newmembers);
    }
}

