/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.db;

import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.bio.BioEntry;
import org.biojavax.bio.BioEntryIterator;
import org.biojavax.bio.db.AbstractBioEntryDB;
import org.biojavax.bio.db.BioEntryDB;
import org.biojavax.bio.db.RichSequenceDB;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public abstract class AbstractRichSequenceDB
extends AbstractBioEntryDB
implements RichSequenceDB {
    @Override
    public Sequence getSequence(String id) throws BioException, IllegalIDException {
        return this.getRichSequence(id);
    }

    @Override
    public BioEntry getBioEntry(String id) throws BioException, IllegalIDException {
        return this.getRichSequence(id);
    }

    @Override
    public BioEntryDB getBioEntrys(Set ids) throws BioException, IllegalIDException {
        return this.getRichSequences(ids);
    }

    @Override
    public BioEntryDB getBioEntrys(Set ids, BioEntryDB db) throws BioException, IllegalIDException {
        RichSequenceDB db2 = this.getRichSequences(ids);
        BioEntryIterator i = db2.getBioEntryIterator();
        while (i.hasNext()) {
            BioEntry be = i.nextBioEntry();
            try {
                db.addBioEntry(be);
            }
            catch (ChangeVetoException ce) {
                throw new BioException("Unexpectedly unable to add to a BioEntryDB", ce);
            }
        }
        return db;
    }

    @Override
    public void addSequence(Sequence seq) throws IllegalIDException, BioException, ChangeVetoException {
        this.addRichSequence(RichSequence.Tools.enrich(seq));
    }

    @Override
    public void removeSequence(String id) throws IllegalIDException, BioException, ChangeVetoException {
        this.removeRichSequence(id);
    }

    @Override
    public void addBioEntry(BioEntry seq) throws IllegalIDException, BioException, ChangeVetoException {
        throw new ChangeVetoException("Cannot add BioEntrys to a RichSequence database - use addRichSequence");
    }

    @Override
    public void removeBioEntry(String id) throws IllegalIDException, BioException, ChangeVetoException {
        throw new ChangeVetoException("Cannot remove BioEntrys from a RichSequence database - use addRichSequence");
    }

    @Override
    public void addRichSequence(RichSequence seq) throws IllegalIDException, BioException, ChangeVetoException {
        throw new ChangeVetoException("Cannot add RichSequences to a read-only database");
    }

    @Override
    public void removeRichSequence(String id) throws IllegalIDException, BioException, ChangeVetoException {
        throw new ChangeVetoException("Cannot remove RichSequences from a read-only database");
    }

    @Override
    public SequenceIterator sequenceIterator() {
        return this.getRichSequenceIterator();
    }

    @Override
    public BioEntryIterator getBioEntryIterator() {
        return this.getRichSequenceIterator();
    }

    @Override
    public RichSequenceIterator getRichSequenceIterator() {
        return new RichSequenceIterator(){
            private Iterator pID;
            {
                this.pID = AbstractRichSequenceDB.this.ids().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.pID.hasNext();
            }

            @Override
            public Sequence nextSequence() throws BioException {
                return this.nextRichSequence();
            }

            @Override
            public BioEntry nextBioEntry() throws BioException {
                return this.nextRichSequence();
            }

            @Override
            public RichSequence nextRichSequence() throws BioException {
                return AbstractRichSequenceDB.this.getRichSequence((String)this.pID.next());
            }
        };
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff) {
        MergeFeatureHolder results = new MergeFeatureHolder();
        try {
            RichSequenceIterator si = this.getRichSequenceIterator();
            while (si.hasNext()) {
                RichSequence seq = si.nextRichSequence();
                results.addFeatureHolder(seq.filter(ff));
            }
        }
        catch (BioException ex) {
            throw new BioRuntimeException(ex);
        }
        catch (ChangeVetoException cve) {
            throw new BioError("Assertion failed: couldn't modify newly created MergeFeatureHolder", cve);
        }
        return results;
    }
}

