/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class ChangeForwarder
implements ChangeListener {
    private final Object source;
    private final transient ChangeSupport changeSupport;

    public ChangeForwarder(Object source, ChangeSupport changeSupport) {
        this.source = source;
        this.changeSupport = changeSupport;
    }

    public Object getSource() {
        return this.source;
    }

    public ChangeSupport changeSupport() {
        return this.changeSupport;
    }

    protected ChangeEvent generateEvent(ChangeEvent ce) throws ChangeVetoException {
        return new ChangeEvent(this.getSource(), ce.getType(), null, null, ce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preChange(ChangeEvent ce) throws ChangeVetoException {
        ChangeEvent nce = this.generateEvent(ce);
        if (nce != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(nce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postChange(ChangeEvent ce) {
        block5: {
            try {
                ChangeEvent nce = this.generateEvent(ce);
                if (nce == null) break block5;
                ChangeSupport changeSupport = this.changeSupport;
                synchronized (changeSupport) {
                    this.changeSupport.firePostChangeEvent(nce);
                }
            }
            catch (ChangeVetoException cve) {
                throw new AssertionFailure("Assertion Failure: Change was vetoed after it had been accepted by preChange", cve);
            }
        }
    }

    public static class Retyper
    extends ChangeForwarder {
        private final ChangeType type;

        public Retyper(Object source, ChangeSupport changeSupport, ChangeType type) {
            super(source, changeSupport);
            this.type = type;
        }

        public ChangeType getType() {
            return this.type;
        }

        @Override
        protected ChangeEvent generateEvent(ChangeEvent ce) throws ChangeVetoException {
            return new ChangeEvent(this.getSource(), this.getType(), null, null, ce);
        }
    }
}

