/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.HashSet;
import java.util.Set;
import org.biojava.stats.svm.NestedKernel;

public class DiagonalAddKernel
extends NestedKernel {
    private Set posClass = new HashSet();
    private Set negClass = new HashSet();
    private double lambda = 1.0;

    public void addPos(Object o) {
        this.posClass.add(o);
    }

    public void addNeg(Object o) {
        this.negClass.add(o);
    }

    public void setLambda(double l) {
        this.lambda = l;
    }

    public double getLambda() {
        return this.lambda;
    }

    @Override
    public double evaluate(Object a, Object b) {
        double dot = this.getNestedKernel().evaluate(a, b);
        if (a == b) {
            int size = 0;
            if (this.posClass.contains(a)) {
                size = this.posClass.size();
            } else if (this.negClass.contains(a)) {
                size = this.negClass.size();
            }
            dot += this.getLambda() * (double)size / (double)(this.posClass.size() + this.negClass.size());
        }
        return dot;
    }

    public String toString() {
        return "DiagonalAdd K(a, b | l, s+, s-, k) = k(a, b) + d[a, b]; d[a, b] = { a != b, 0; a == b, l * {class(a == +), s+; class(a == -), s-} }; k = " + this.getNestedKernel().toString();
    }
}

