/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ListTools;
import org.biojava.utils.Unchangeable;

public final class SoftMaskedAlphabet
extends Unchangeable
implements FiniteAlphabet {
    private IntegerAlphabet.SubIntegerAlphabet binary;
    private FiniteAlphabet alpha;
    private String name;
    private FiniteAlphabet delegateAlpha;
    private MaskingDetector maskingDetector;

    private SoftMaskedAlphabet(FiniteAlphabet alpha, String name) throws IllegalAlphabetException {
        this.alpha = alpha;
        this.binary = IntegerAlphabet.getSubAlphabet(0, 1);
        this.name = name;
        this.delegateAlpha = (FiniteAlphabet)AlphabetManager.getCrossProductAlphabet(new ListTools.Doublet(alpha, this.binary));
    }

    public static SoftMaskedAlphabet getInstance(FiniteAlphabet alphaToMask) throws IllegalAlphabetException {
        return SoftMaskedAlphabet.getInstance(alphaToMask, MaskingDetector.DEFAULT);
    }

    public static SoftMaskedAlphabet getInstance(FiniteAlphabet alphaToMask, MaskingDetector maskingDetector) throws IllegalAlphabetException {
        String lookup = "Softmasked {" + alphaToMask.getName() + "}";
        if (AlphabetManager.registered(lookup)) {
            return (SoftMaskedAlphabet)AlphabetManager.alphabetForName(lookup);
        }
        SoftMaskedAlphabet sma = new SoftMaskedAlphabet(alphaToMask, lookup);
        AlphabetManager.registerAlphabet(sma.getName(), (Alphabet)sma);
        sma.maskingDetector = maskingDetector;
        return sma;
    }

    public FiniteAlphabet getMaskedAlphabet() {
        return this.alpha;
    }

    protected FiniteAlphabet getDelegate() {
        return this.delegateAlpha;
    }

    @Override
    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List getAlphabets() {
        return new ListTools.Doublet(this.alpha, this.binary);
    }

    public Symbol getSymbol(List l) throws IllegalSymbolException {
        return this.delegateAlpha.getSymbol(l);
    }

    public Symbol getAmbiguity(Set s) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Ambiguity should be handled at the level of the wrapped Alphabet");
    }

    @Override
    public Symbol getGapSymbol() {
        return AlphabetManager.getGapSymbol(new ListTools.Doublet(this.alpha, this.binary));
    }

    @Override
    public boolean contains(Symbol s) {
        return this.delegateAlpha.contains(s);
    }

    @Override
    public void validate(Symbol s) throws IllegalSymbolException {
        if (!this.contains(s)) {
            throw new IllegalSymbolException(s, s.getName() + " is not a valid part of " + this.getName());
        }
    }

    public MaskingDetector getMaskingDetector() {
        return this.maskingDetector;
    }

    @Override
    public SymbolTokenization getTokenization(String type) throws BioException {
        return new CaseSensitiveTokenization(this, type);
    }

    @Override
    public int size() {
        return this.delegateAlpha.size();
    }

    public Iterator iterator() {
        return this.delegateAlpha.iterator();
    }

    @Override
    public void addSymbol(Symbol s) throws ChangeVetoException {
        throw new ChangeVetoException("SoftMaskedAlphabets cannot add new Symbols");
    }

    @Override
    public void removeSymbol(Symbol s) throws ChangeVetoException {
        throw new ChangeVetoException("SoftMaskedAlphabets cannot remove Symbols");
    }

    public boolean isMasked(BasisSymbol s) throws IllegalSymbolException {
        this.validate(s);
        IntegerAlphabet.IntegerSymbol b = (IntegerAlphabet.IntegerSymbol)s.getSymbols().get(1);
        return b.intValue() == 1;
    }

    public class CaseSensitiveTokenization
    extends Unchangeable
    implements SymbolTokenization {
        private SymbolTokenization delegate;
        private SoftMaskedAlphabet alpha;

        private CaseSensitiveTokenization(SoftMaskedAlphabet alpha, String type) throws BioException {
            this.alpha = alpha;
            this.delegate = alpha.getMaskedAlphabet().getTokenization(type);
        }

        @Override
        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        @Override
        public Alphabet getAlphabet() {
            return this.alpha;
        }

        @Override
        public SymbolTokenization.TokenType getTokenType() {
            return this.delegate.getTokenType();
        }

        @Override
        public Symbol parseToken(String token) throws IllegalSymbolException {
            MaskingDetector md = this.alpha.getMaskingDetector();
            Symbol component = this.delegate.parseToken(token);
            IntegerAlphabet.IntegerSymbol bin = md.isMasked(token) ? SoftMaskedAlphabet.this.binary.getSymbol(1) : SoftMaskedAlphabet.this.binary.getSymbol(0);
            return this.alpha.getSymbol((List)new ListTools.Doublet(component, bin));
        }

        @Override
        public String tokenizeSymbolList(SymbolList sl) throws IllegalSymbolException {
            StringBuffer sb = new StringBuffer(sl.length());
            for (int i = 1; i <= sl.length(); ++i) {
                sb.append(this.tokenizeSymbol(sl.symbolAt(i)));
            }
            return sb.toString();
        }

        @Override
        public StreamParser parseStream(SeqIOListener l) {
            return new CharStreamParser(l);
        }

        @Override
        public String tokenizeSymbol(Symbol s) throws IllegalSymbolException {
            SoftMaskedAlphabet.this.validate(s);
            Symbol a = (Symbol)((BasisSymbol)s).getSymbols().get(0);
            String token = this.delegate.tokenizeSymbol(a);
            if (this.alpha.isMasked((BasisSymbol)s)) {
                return SoftMaskedAlphabet.this.maskingDetector.mask(token);
            }
            return SoftMaskedAlphabet.this.maskingDetector.unmask(token);
        }

        private class CharStreamParser
        implements StreamParser {
            private SeqIOListener listener;
            private Symbol[] buffer;

            public CharStreamParser(SeqIOListener l) {
                this.listener = l;
                this.buffer = new Symbol[256];
            }

            @Override
            public void characters(char[] data, int start, int len) throws IllegalSymbolException {
                int cnt = 0;
                while (cnt < len) {
                    int bcnt = 0;
                    while (cnt < len && bcnt < this.buffer.length) {
                        this.buffer[bcnt++] = CaseSensitiveTokenization.this.parseToken(new String("" + data[start + cnt++]));
                    }
                    try {
                        this.listener.addSymbols(CaseSensitiveTokenization.this.getAlphabet(), this.buffer, 0, bcnt);
                    }
                    catch (IllegalAlphabetException ex) {
                        throw new BioError("Assertion failed: can't add symbols.", ex);
                    }
                }
            }

            @Override
            public void close() {
            }
        }
    }

    public static interface MaskingDetector {
        public static final MaskingDetector DEFAULT = new DefaultMaskingDetector();

        public boolean isMasked(String var1);

        public String mask(String var1);

        public String unmask(String var1);

        public static class DefaultMaskingDetector
        implements MaskingDetector {
            @Override
            public boolean isMasked(String token) {
                for (int i = 0; i < token.length(); ++i) {
                    if (!Character.isUpperCase(token.charAt(i))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String mask(String token) {
                return token.toLowerCase();
            }

            @Override
            public String unmask(String token) {
                return token.toUpperCase();
            }
        }
    }
}

