/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.symbol.AbstractSimpleBasisSymbol;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.bio.symbol.Symbol;

public class SimpleAtomicSymbol
extends AbstractSimpleBasisSymbol
implements AtomicSymbol,
Serializable {
    protected SimpleAtomicSymbol(Annotation annotation, List syms) throws IllegalSymbolException {
        super(annotation, syms);
    }

    @Override
    protected Alphabet createMatches() {
        return new SingletonAlphabet(this);
    }

    private Object writeReplace() {
        return new SBSH(this);
    }

    private static class SBSH
    implements Serializable {
        private List syms;
        private Annotation ann;

        public SBSH(SimpleAtomicSymbol sym) {
            this.syms = sym.getSymbols();
            this.ann = sym.getAnnotation();
        }

        public Object readResolve() throws ObjectStreamException {
            try {
                Symbol sym = AlphabetManager.createSymbol(this.ann, this.syms, null);
                return sym;
            }
            catch (IllegalSymbolException ex) {
                throw new InvalidObjectException("Couldn't resolve symbol:" + this.syms);
            }
        }
    }
}

