/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractLocation;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

class CompoundLocation
extends AbstractLocation
implements Location,
Serializable {
    private List locations;
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;

    CompoundLocation(List locs) {
        this.locations = new ArrayList(locs);
        Collections.sort(this.locations, Location.naturalOrder);
        this.locations = Collections.unmodifiableList(this.locations);
        Location minL = (Location)this.locations.get(0);
        Location maxL = (Location)this.locations.get(locs.size() - 1);
        this.min = minL.getMin();
        this.max = maxL.getMax();
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public boolean contains(int p) {
        if (p < this.min || p > this.max) {
            return false;
        }
        int m = this.locations.size();
        int n = 0;
        while (m >= n) {
            int i = (m + n) / 2;
            Location l = (Location)this.locations.get(i);
            if (p < l.getMin()) {
                m = i - 1;
                continue;
            }
            if (p > l.getMax()) {
                n = i + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Location l) {
        return LocationTools.contains(this, l);
    }

    @Override
    public boolean overlaps(Location l) {
        return LocationTools.overlaps(this, l);
    }

    @Override
    public Location union(Location loc) {
        return LocationTools.union(this, loc);
    }

    @Override
    public Location intersection(Location loc) {
        return LocationTools.intersection(this, loc);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Location)) {
            return false;
        }
        return LocationTools.areEqual(this, (Location)o);
    }

    @Override
    public SymbolList symbols(SymbolList seq) {
        if (this.isContiguous()) {
            return seq.subList(this.min, this.max);
        }
        ArrayList<Symbol> res = new ArrayList<Symbol>();
        Iterator i = this.blockIterator();
        while (i.hasNext()) {
            Location l = (Location)i.next();
            res.addAll(l.symbols(seq).toList());
        }
        try {
            return new SimpleSymbolList(seq.getAlphabet(), res);
        }
        catch (IllegalSymbolException ex) {
            throw new BioError(ex);
        }
    }

    @Override
    public Location translate(int dist) {
        if (dist == 0) {
            return this;
        }
        ArrayList<Location> res = new ArrayList<Location>();
        Iterator i = this.locations.iterator();
        while (i.hasNext()) {
            res.add(((Location)i.next()).translate(dist));
        }
        return new CompoundLocation(res);
    }

    @Override
    public boolean isContiguous() {
        return this.locations.size() <= 1;
    }

    List getBlockList() {
        return this.locations;
    }

    public Iterator blockIterator() {
        return this.locations.iterator();
    }

    @Override
    public int hashCode() {
        return this.getMin() ^ this.getMax();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getMin() + ", " + this.getMax() + " {");
        Iterator i = this.locations.iterator();
        if (i.hasNext()) {
            sb.append("(" + i.next() + ")");
        }
        while (i.hasNext()) {
            sb.append(", (" + i.next() + ")");
        }
        sb.append("}");
        return sb.substring(0);
    }
}

