/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.symbol.AbstractTranslationTable;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ManyToOneTranslationTable;
import org.biojava.bio.symbol.Symbol;

public abstract class AbstractManyToOneTranslationTable
extends AbstractTranslationTable
implements ManyToOneTranslationTable {
    @Override
    public abstract Alphabet getSourceAlphabet();

    @Override
    public abstract Alphabet getTargetAlphabet();

    protected abstract Set doUntranslate(Symbol var1) throws IllegalSymbolException;

    @Override
    public Set untranslate(Symbol sym) throws IllegalSymbolException {
        HashSet<Set> s = this.doUntranslate(sym);
        if (s == null) {
            if (sym instanceof AtomicSymbol) {
                this.getSourceAlphabet().validate(sym);
                throw new IllegalSymbolException("Unable to map " + sym.getName());
            }
            if (sym == null) {
                throw new NullPointerException("Can't translate null");
            }
            s = new HashSet<Set>();
            Iterator<Symbol> i = ((FiniteAlphabet)sym.getMatches()).iterator();
            while (i.hasNext()) {
                Symbol is = i.next();
                s.add(this.untranslate(is));
            }
        }
        return s;
    }
}

